/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1beta.CreateRealmRequest;
import com.google.cloud.gaming.v1beta.DeleteRealmRequest;
import com.google.cloud.gaming.v1beta.GetRealmRequest;
import com.google.cloud.gaming.v1beta.ListRealmsRequest;
import com.google.cloud.gaming.v1beta.ListRealmsResponse;
import com.google.cloud.gaming.v1beta.LocationName;
import com.google.cloud.gaming.v1beta.MockRealmsService;
import com.google.cloud.gaming.v1beta.PreviewRealmUpdateRequest;
import com.google.cloud.gaming.v1beta.PreviewRealmUpdateResponse;
import com.google.cloud.gaming.v1beta.Realm;
import com.google.cloud.gaming.v1beta.RealmName;
import com.google.cloud.gaming.v1beta.RealmsServiceClient;
import com.google.cloud.gaming.v1beta.RealmsServiceSettings;
import com.google.cloud.gaming.v1beta.TargetState;
import com.google.cloud.gaming.v1beta.UpdateRealmRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RealmsServiceClientTest {
    private static MockRealmsService mockRealmsService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private RealmsServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockRealmsService = new MockRealmsService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockRealmsService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        RealmsServiceSettings settings = ((RealmsServiceSettings.Builder)((RealmsServiceSettings.Builder)RealmsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = RealmsServiceClient.create((RealmsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listRealmsTest() throws Exception {
        Realm responsesElement = Realm.newBuilder().build();
        ListRealmsResponse expectedResponse = ListRealmsResponse.newBuilder().setNextPageToken("").addAllRealms(Arrays.asList(responsesElement)).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        RealmsServiceClient.ListRealmsPagedResponse pagedListResponse = this.client.listRealms(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRealmsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRealmsRequest actualRequest = (ListRealmsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRealmsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listRealms(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRealmsTest2() throws Exception {
        Realm responsesElement = Realm.newBuilder().build();
        ListRealmsResponse expectedResponse = ListRealmsResponse.newBuilder().setNextPageToken("").addAllRealms(Arrays.asList(responsesElement)).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        RealmsServiceClient.ListRealmsPagedResponse pagedListResponse = this.client.listRealms(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRealmsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRealmsRequest actualRequest = (ListRealmsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRealmsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listRealms(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRealmTest() throws Exception {
        Realm expectedResponse = Realm.newBuilder().setName(RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setTimeZone("timeZone-2077180903").setEtag("etag3123477").setDescription("description-1724546052").build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        Realm actualResponse = this.client.getRealm(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRealmRequest actualRequest = (GetRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.getRealm(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRealmTest2() throws Exception {
        Realm expectedResponse = Realm.newBuilder().setName(RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setTimeZone("timeZone-2077180903").setEtag("etag3123477").setDescription("description-1724546052").build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Realm actualResponse = this.client.getRealm(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRealmRequest actualRequest = (GetRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRealmExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getRealm(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createRealmTest() throws Exception {
        Realm expectedResponse = Realm.newBuilder().setName(RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setTimeZone("timeZone-2077180903").setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Realm realm = Realm.newBuilder().build();
        String realmId = "realmId1080654858";
        Realm actualResponse = (Realm)this.client.createRealmAsync(parent, realm, realmId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRealmRequest actualRequest = (CreateRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)realmId, (Object)actualRequest.getRealmId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Realm realm = Realm.newBuilder().build();
            String realmId = "realmId1080654858";
            this.client.createRealmAsync(parent, realm, realmId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createRealmTest2() throws Exception {
        Realm expectedResponse = Realm.newBuilder().setName(RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setTimeZone("timeZone-2077180903").setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Realm realm = Realm.newBuilder().build();
        String realmId = "realmId1080654858";
        Realm actualResponse = (Realm)this.client.createRealmAsync(parent, realm, realmId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRealmRequest actualRequest = (CreateRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)realmId, (Object)actualRequest.getRealmId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRealmExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Realm realm = Realm.newBuilder().build();
            String realmId = "realmId1080654858";
            this.client.createRealmAsync(parent, realm, realmId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRealmTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        this.client.deleteRealmAsync(name).get();
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRealmRequest actualRequest = (DeleteRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.deleteRealmAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRealmTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteRealmAsync(name).get();
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRealmRequest actualRequest = (DeleteRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRealmExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteRealmAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateRealmTest() throws Exception {
        Realm expectedResponse = Realm.newBuilder().setName(RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setTimeZone("timeZone-2077180903").setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("updateRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        Realm realm = Realm.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Realm actualResponse = (Realm)this.client.updateRealmAsync(realm, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateRealmRequest actualRequest = (UpdateRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            Realm realm = Realm.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateRealmAsync(realm, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewRealmUpdateTest() throws Exception {
        PreviewRealmUpdateResponse expectedResponse = PreviewRealmUpdateResponse.newBuilder().setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        PreviewRealmUpdateRequest request = PreviewRealmUpdateRequest.newBuilder().setRealm(Realm.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
        PreviewRealmUpdateResponse actualResponse = this.client.previewRealmUpdate(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewRealmUpdateRequest actualRequest = (PreviewRealmUpdateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getRealm(), (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertEquals((Object)request.getPreviewTime(), (Object)actualRequest.getPreviewTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewRealmUpdateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            PreviewRealmUpdateRequest request = PreviewRealmUpdateRequest.newBuilder().setRealm(Realm.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
            this.client.previewRealmUpdate(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

