/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.gaming.v1.GameServerConfig;
import com.google.cloud.gaming.v1.GameServerConfigName;
import com.google.cloud.gaming.v1.GameServerConfigsServiceClient;
import com.google.cloud.gaming.v1.GameServerConfigsServiceSettings;
import com.google.cloud.gaming.v1.GameServerDeploymentName;
import com.google.cloud.gaming.v1.ListGameServerConfigsResponse;
import com.google.cloud.gaming.v1.stub.HttpJsonGameServerConfigsServiceStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerConfigsServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static GameServerConfigsServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonGameServerConfigsServiceStub.getMethodDescriptors(), GameServerConfigsServiceSettings.getDefaultEndpoint());
        GameServerConfigsServiceSettings settings = ((GameServerConfigsServiceSettings.Builder)((GameServerConfigsServiceSettings.Builder)GameServerConfigsServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)GameServerConfigsServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = GameServerConfigsServiceClient.create((GameServerConfigsServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listGameServerConfigsTest() throws Exception {
        GameServerConfig responsesElement = GameServerConfig.newBuilder().build();
        ListGameServerConfigsResponse expectedResponse = ListGameServerConfigsResponse.newBuilder().setNextPageToken("").addAllGameServerConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse pagedListResponse = client.listGameServerConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGameServerConfigsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.listGameServerConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGameServerConfigsTest2() throws Exception {
        GameServerConfig responsesElement = GameServerConfig.newBuilder().build();
        ListGameServerConfigsResponse expectedResponse = ListGameServerConfigsResponse.newBuilder().setNextPageToken("").addAllGameServerConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-6046/locations/location-6046/gameServerDeployments/gameServerDeployment-6046";
        GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse pagedListResponse = client.listGameServerConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGameServerConfigsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6046/locations/location-6046/gameServerDeployments/gameServerDeployment-6046";
            client.listGameServerConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerConfigTest() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        mockService.addResponse((Object)expectedResponse);
        GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        GameServerConfig actualResponse = client.getGameServerConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
            client.getGameServerConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerConfigTest2() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2748/locations/location-2748/gameServerDeployments/gameServerDeployment-2748/configs/config-2748";
        GameServerConfig actualResponse = client.getGameServerConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2748/locations/location-2748/gameServerDeployments/gameServerDeployment-2748/configs/config-2748";
            client.getGameServerConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerConfigTest() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
        GameServerConfig actualResponse = (GameServerConfig)client.createGameServerConfigAsync(parent, gameServerConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGameServerConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
            client.createGameServerConfigAsync(parent, gameServerConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerConfigTest2() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-6046/locations/location-6046/gameServerDeployments/gameServerDeployment-6046";
        GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
        GameServerConfig actualResponse = (GameServerConfig)client.createGameServerConfigAsync(parent, gameServerConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGameServerConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6046/locations/location-6046/gameServerDeployments/gameServerDeployment-6046";
            GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
            client.createGameServerConfigAsync(parent, gameServerConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        client.deleteGameServerConfigAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGameServerConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
            client.deleteGameServerConfigAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-2748/locations/location-2748/gameServerDeployments/gameServerDeployment-2748/configs/config-2748";
        client.deleteGameServerConfigAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGameServerConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2748/locations/location-2748/gameServerDeployments/gameServerDeployment-2748/configs/config-2748";
            client.deleteGameServerConfigAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

