/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.gaming.v1.FetchDeploymentStateRequest;
import com.google.cloud.gaming.v1.FetchDeploymentStateResponse;
import com.google.cloud.gaming.v1.GameServerDeployment;
import com.google.cloud.gaming.v1.GameServerDeploymentName;
import com.google.cloud.gaming.v1.GameServerDeploymentRollout;
import com.google.cloud.gaming.v1.GameServerDeploymentsServiceClient;
import com.google.cloud.gaming.v1.GameServerDeploymentsServiceSettings;
import com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse;
import com.google.cloud.gaming.v1.LocationName;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutResponse;
import com.google.cloud.gaming.v1.TargetState;
import com.google.cloud.gaming.v1.stub.HttpJsonGameServerDeploymentsServiceStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerDeploymentsServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static GameServerDeploymentsServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonGameServerDeploymentsServiceStub.getMethodDescriptors(), GameServerDeploymentsServiceSettings.getDefaultEndpoint());
        GameServerDeploymentsServiceSettings settings = ((GameServerDeploymentsServiceSettings.Builder)((GameServerDeploymentsServiceSettings.Builder)GameServerDeploymentsServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)GameServerDeploymentsServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = GameServerDeploymentsServiceClient.create((GameServerDeploymentsServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listGameServerDeploymentsTest() throws Exception {
        GameServerDeployment responsesElement = GameServerDeployment.newBuilder().build();
        ListGameServerDeploymentsResponse expectedResponse = ListGameServerDeploymentsResponse.newBuilder().setNextPageToken("").addAllGameServerDeployments(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse pagedListResponse = client.listGameServerDeployments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerDeploymentsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGameServerDeploymentsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listGameServerDeployments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGameServerDeploymentsTest2() throws Exception {
        GameServerDeployment responsesElement = GameServerDeployment.newBuilder().build();
        ListGameServerDeploymentsResponse expectedResponse = ListGameServerDeploymentsResponse.newBuilder().setNextPageToken("").addAllGameServerDeployments(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse pagedListResponse = client.listGameServerDeployments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerDeploymentsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGameServerDeploymentsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listGameServerDeployments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerDeploymentTest() throws Exception {
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockService.addResponse((Object)expectedResponse);
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerDeployment actualResponse = client.getGameServerDeployment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.getGameServerDeployment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerDeploymentTest2() throws Exception {
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689";
        GameServerDeployment actualResponse = client.getGameServerDeployment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689";
            client.getGameServerDeployment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerDeploymentTest() throws Exception {
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)client.createGameServerDeploymentAsync(parent, gameServerDeployment).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGameServerDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
            client.createGameServerDeploymentAsync(parent, gameServerDeployment).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerDeploymentTest2() throws Exception {
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)client.createGameServerDeploymentAsync(parent, gameServerDeployment).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGameServerDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
            client.createGameServerDeploymentAsync(parent, gameServerDeployment).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerDeploymentTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        client.deleteGameServerDeploymentAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGameServerDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.deleteGameServerDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerDeploymentTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689";
        client.deleteGameServerDeploymentAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGameServerDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689";
            client.deleteGameServerDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateGameServerDeploymentTest() throws Exception {
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)client.updateGameServerDeploymentAsync(gameServerDeployment, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateGameServerDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateGameServerDeploymentAsync(gameServerDeployment, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerDeploymentRolloutTest() throws Exception {
        GameServerDeploymentRollout expectedResponse = GameServerDeploymentRollout.newBuilder().setName("name3373707").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDefaultGameServerConfig("defaultGameServerConfig-1852465704").addAllGameServerConfigOverrides(new ArrayList()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerDeploymentRollout actualResponse = client.getGameServerDeploymentRollout(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerDeploymentRolloutExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.getGameServerDeploymentRollout(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerDeploymentRolloutTest2() throws Exception {
        GameServerDeploymentRollout expectedResponse = GameServerDeploymentRollout.newBuilder().setName("name3373707").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDefaultGameServerConfig("defaultGameServerConfig-1852465704").addAllGameServerConfigOverrides(new ArrayList()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689";
        GameServerDeploymentRollout actualResponse = client.getGameServerDeploymentRollout(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerDeploymentRolloutExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689";
            client.getGameServerDeploymentRollout(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateGameServerDeploymentRolloutTest() throws Exception {
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerDeploymentRolloutTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GameServerDeploymentRollout rollout = GameServerDeploymentRollout.newBuilder().setName("projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDefaultGameServerConfig("defaultGameServerConfig-1852465704").addAllGameServerConfigOverrides(new ArrayList()).setEtag("etag3123477").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)client.updateGameServerDeploymentRolloutAsync(rollout, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateGameServerDeploymentRolloutExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerDeploymentRollout rollout = GameServerDeploymentRollout.newBuilder().setName("projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDefaultGameServerConfig("defaultGameServerConfig-1852465704").addAllGameServerConfigOverrides(new ArrayList()).setEtag("etag3123477").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateGameServerDeploymentRolloutAsync(rollout, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void previewGameServerDeploymentRolloutTest() throws Exception {
        PreviewGameServerDeploymentRolloutResponse expectedResponse = PreviewGameServerDeploymentRolloutResponse.newBuilder().addAllUnavailable(new ArrayList()).setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PreviewGameServerDeploymentRolloutRequest request = PreviewGameServerDeploymentRolloutRequest.newBuilder().setRollout(GameServerDeploymentRollout.newBuilder().setName("projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDefaultGameServerConfig("defaultGameServerConfig-1852465704").addAllGameServerConfigOverrides(new ArrayList()).setEtag("etag3123477").build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
        PreviewGameServerDeploymentRolloutResponse actualResponse = client.previewGameServerDeploymentRollout(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void previewGameServerDeploymentRolloutExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PreviewGameServerDeploymentRolloutRequest request = PreviewGameServerDeploymentRolloutRequest.newBuilder().setRollout(GameServerDeploymentRollout.newBuilder().setName("projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDefaultGameServerConfig("defaultGameServerConfig-1852465704").addAllGameServerConfigOverrides(new ArrayList()).setEtag("etag3123477").build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
            client.previewGameServerDeploymentRollout(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void fetchDeploymentStateTest() throws Exception {
        FetchDeploymentStateResponse expectedResponse = FetchDeploymentStateResponse.newBuilder().addAllClusterState(new ArrayList()).addAllUnavailable(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        FetchDeploymentStateRequest request = FetchDeploymentStateRequest.newBuilder().setName("projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689").build();
        FetchDeploymentStateResponse actualResponse = client.fetchDeploymentState(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void fetchDeploymentStateExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FetchDeploymentStateRequest request = FetchDeploymentStateRequest.newBuilder().setName("projects/project-8689/locations/location-8689/gameServerDeployments/gameServerDeployment-8689").build();
            client.fetchDeploymentState(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

