/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1beta.CreateGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.GameServerConfig;
import com.google.cloud.gaming.v1beta.GameServerConfigName;
import com.google.cloud.gaming.v1beta.GameServerConfigsServiceClient;
import com.google.cloud.gaming.v1beta.GameServerConfigsServiceSettings;
import com.google.cloud.gaming.v1beta.GameServerDeploymentName;
import com.google.cloud.gaming.v1beta.GetGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsResponse;
import com.google.cloud.gaming.v1beta.MockGameServerConfigsService;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerConfigsServiceClientTest {
    private static MockGameServerConfigsService mockGameServerConfigsService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private GameServerConfigsServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockGameServerConfigsService = new MockGameServerConfigsService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockGameServerConfigsService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        GameServerConfigsServiceSettings settings = ((GameServerConfigsServiceSettings.Builder)((GameServerConfigsServiceSettings.Builder)GameServerConfigsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GameServerConfigsServiceClient.create((GameServerConfigsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGameServerConfigsTest() throws Exception {
        GameServerConfig responsesElement = GameServerConfig.newBuilder().build();
        ListGameServerConfigsResponse expectedResponse = ListGameServerConfigsResponse.newBuilder().setNextPageToken("").addAllGameServerConfigs(Arrays.asList(responsesElement)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)expectedResponse);
        GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse pagedListResponse = this.client.listGameServerConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerConfigsRequest actualRequest = (ListGameServerConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.listGameServerConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGameServerConfigsTest2() throws Exception {
        GameServerConfig responsesElement = GameServerConfig.newBuilder().build();
        ListGameServerConfigsResponse expectedResponse = ListGameServerConfigsResponse.newBuilder().setNextPageToken("").addAllGameServerConfigs(Arrays.asList(responsesElement)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse pagedListResponse = this.client.listGameServerConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerConfigsRequest actualRequest = (ListGameServerConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listGameServerConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerConfigTest() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        mockGameServerConfigsService.addResponse((AbstractMessage)expectedResponse);
        GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        GameServerConfig actualResponse = this.client.getGameServerConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerConfigRequest actualRequest = (GetGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
            this.client.getGameServerConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerConfigTest2() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        mockGameServerConfigsService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        GameServerConfig actualResponse = this.client.getGameServerConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerConfigRequest actualRequest = (GetGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getGameServerConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerConfigTest() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)resultOperation);
        GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
        GameServerConfig actualResponse = (GameServerConfig)this.client.createGameServerConfigAsync(parent, gameServerConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerConfigRequest actualRequest = (CreateGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)gameServerConfig, (Object)actualRequest.getGameServerConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
            this.client.createGameServerConfigAsync(parent, gameServerConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createGameServerConfigTest2() throws Exception {
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFleetConfigs(new ArrayList()).addAllScalingConfigs(new ArrayList()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
        GameServerConfig actualResponse = (GameServerConfig)this.client.createGameServerConfigAsync(parent, gameServerConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerConfigRequest actualRequest = (CreateGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)gameServerConfig, (Object)actualRequest.getGameServerConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
            this.client.createGameServerConfigAsync(parent, gameServerConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGameServerConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)resultOperation);
        GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        this.client.deleteGameServerConfigAsync(name).get();
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerConfigRequest actualRequest = (DeleteGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
            this.client.deleteGameServerConfigAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGameServerConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteGameServerConfigAsync(name).get();
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerConfigRequest actualRequest = (DeleteGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteGameServerConfigAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

