/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;

public final class ByteArrays {
    private static final String ELLIPSIS = "...";
    private static final BaseEncoding encoder = BaseEncoding.base64();

    private ByteArrays() {
    }

    static String toBase64(ByteArray data) {
        return encoder.encode(data.toByteArray());
    }

    static ByteArray fromBase64(String data) {
        return ByteArray.copyFrom((byte[])encoder.decode((CharSequence)data));
    }

    public static String toString(ByteArray byteArray) {
        return ByteArrays.toString(byteArray.asReadOnlyByteBuffer());
    }

    static String toString(ByteBuffer data) {
        return ByteArrays.appendToString(data, new StringBuilder(), Integer.MAX_VALUE).toString();
    }

    static String toString(ByteArray byteArray, int maxLength) {
        return ByteArrays.appendToString(byteArray, new StringBuilder(), maxLength).toString();
    }

    static StringBuilder appendToString(ByteArray byteArray, StringBuilder b, int maxLength) {
        return ByteArrays.appendToString(byteArray.asReadOnlyByteBuffer(), b, maxLength);
    }

    static StringBuilder appendToString(ByteBuffer data, StringBuilder b, int maxLength) {
        maxLength = Math.max(ELLIPSIS.length(), maxLength);
        int startPos = b.length();
        int lastFit = 0;
        boolean truncate = false;
        while (data.remaining() > 0 && !truncate) {
            ByteArrays.byteToString(b, data.get());
            if (b.length() + ELLIPSIS.length() - startPos <= maxLength) {
                lastFit = b.length();
                continue;
            }
            truncate = b.length() - startPos > maxLength;
        }
        if (truncate) {
            b.setLength(lastFit);
            b.append(ELLIPSIS);
        }
        return b;
    }

    private static void byteToString(StringBuilder b, byte d) {
        if (ByteArrays.isAsciiPrintable(d)) {
            b.append((char)d);
        } else {
            b.append('\\').append(Integer.toString(0xFF & d, 8));
        }
    }

    private static boolean isAsciiPrintable(byte b) {
        return b >= 32 && b < 127;
    }
}

