/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.GrpcTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.spi.DefaultSpannerRpc;
import com.google.cloud.spanner.spi.SpannerRpc;
import com.google.cloud.spanner.spi.SpannerRpcFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLException;

public class SpannerOptions
extends ServiceOptions<Spanner, SpannerRpc, SpannerOptions> {
    private static final String API_SHORT_NAME = "Spanner";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/spanner.admin", (Object)"https://www.googleapis.com/auth/spanner.data");
    private static final int MAX_CHANNELS = 256;
    private static final RpcChannelFactory DEFAULT_RPC_CHANNEL_FACTORY = new NettyRpcChannelFactory(DefaultSpannerRpc.API_CLIENT);
    private final List<ManagedChannel> rpcChannels;
    private final SessionPoolOptions sessionPoolOptions;
    private final int prefetchChunks;
    private final int numChannels;
    private final String userAgent;

    private SpannerOptions(Builder builder) {
        super(SpannerFactory.class, SpannerRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new SpannerDefaults());
        this.numChannels = builder.numChannels;
        this.userAgent = builder.userAgentPrefix;
        RpcChannelFactory defaultRpcChannelFactory = this.userAgent == null ? DEFAULT_RPC_CHANNEL_FACTORY : new NettyRpcChannelFactory(this.userAgent + " " + DefaultSpannerRpc.API_CLIENT);
        this.rpcChannels = SpannerOptions.createChannels(this.getHost(), (RpcChannelFactory)MoreObjects.firstNonNull((Object)builder.rpcChannelFactory, (Object)defaultRpcChannelFactory), this.numChannels);
        this.sessionPoolOptions = builder.sessionPoolOptions != null ? builder.sessionPoolOptions : SessionPoolOptions.newBuilder().build();
        this.prefetchChunks = builder.prefetchChunks;
    }

    public static SpannerOptions getDefaultInstance() {
        return SpannerOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<ManagedChannel> getRpcChannels() {
        return this.rpcChannels;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public int getPrefetchChunks() {
        return this.prefetchChunks;
    }

    public static GrpcTransportOptions getDefaultGrpcTransportOptions() {
        return GrpcTransportOptions.newBuilder().build();
    }

    public static RpcChannelFactory getDefaultRpcChannelFactory() {
        return DEFAULT_RPC_CHANNEL_FACTORY;
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    private static List<ManagedChannel> createChannels(String rootUrl, RpcChannelFactory factory, int numChannels) {
        Preconditions.checkArgument((numChannels >= 1 && numChannels <= 256 ? 1 : 0) != 0, (String)"Number of channels must fall in the range [1, %s], found: %s", (Object[])new Object[]{256, numChannels});
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < numChannels; ++i) {
            builder.add((Object)SpannerOptions.createChannel(rootUrl, factory));
        }
        return builder.build();
    }

    private static ManagedChannel createChannel(String rootUrl, RpcChannelFactory factory) {
        URL url;
        try {
            url = new URL(rootUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid host: " + rootUrl, e);
        }
        ManagedChannel channel = factory.newChannel(url.getHost(), url.getPort() > 0 ? url.getPort() : url.getDefaultPort());
        return channel;
    }

    public Set<String> getScopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private static class SpannerDefaults
    implements ServiceDefaults<Spanner, SpannerRpc, SpannerOptions> {
        private SpannerDefaults() {
        }

        public SpannerFactory getDefaultServiceFactory() {
            return DefaultSpannerFactory.INSTANCE;
        }

        public SpannerRpcFactory getDefaultRpcFactory() {
            return DefaultSpannerRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return SpannerOptions.getDefaultGrpcTransportOptions();
        }
    }

    static class NettyRpcChannelFactory
    implements RpcChannelFactory {
        private static final int MAX_MESSAGE_SIZE = 0x6400000;
        private final String userAgent;
        private final List<ClientInterceptor> interceptors;

        NettyRpcChannelFactory(String userAgent) {
            this(userAgent, (List<ClientInterceptor>)ImmutableList.of());
        }

        NettyRpcChannelFactory(String userAgent, List<ClientInterceptor> interceptors) {
            this.userAgent = userAgent;
            this.interceptors = interceptors;
        }

        @Override
        public ManagedChannel newChannel(String host, int port) {
            return ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).sslContext(NettyRpcChannelFactory.newSslContext()).intercept(this.interceptors)).maxMessageSize(0x6400000).userAgent(this.userAgent)).build();
        }

        private static SslContext newSslContext() {
            try {
                return GrpcSslContexts.forClient().ciphers(null).build();
            }
            catch (SSLException e) {
                throw new RuntimeException("SSL configuration failed: " + e.getMessage(), e);
            }
        }
    }

    public static interface RpcChannelFactory {
        public ManagedChannel newChannel(String var1, int var2);
    }

    public static class Builder
    extends ServiceOptions.Builder<Spanner, SpannerRpc, SpannerOptions, Builder> {
        private static final int DEFAULT_PREFETCH_CHUNKS = 4;
        private RpcChannelFactory rpcChannelFactory;
        private int numChannels = 4;
        private int prefetchChunks = 4;
        private SessionPoolOptions sessionPoolOptions;
        private String userAgentPrefix;

        private Builder() {
        }

        Builder(SpannerOptions options) {
            super((ServiceOptions)options);
            this.numChannels = options.numChannels;
            this.sessionPoolOptions = options.sessionPoolOptions;
            this.prefetchChunks = options.prefetchChunks;
            this.userAgentPrefix = options.userAgent;
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only grpc transport is allowed for Spanner.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public Builder setRpcChannelFactory(RpcChannelFactory factory) {
            this.rpcChannelFactory = factory;
            return this;
        }

        public Builder setNumChannels(int numChannels) {
            this.numChannels = numChannels;
            return this;
        }

        public Builder setSessionPoolOption(SessionPoolOptions sessionPoolOptions) {
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setPrefetchChunks(int prefetchChunks) {
            this.prefetchChunks = prefetchChunks;
            return this;
        }

        public Builder setUserAgentPrefix(String userAgentPrefix) {
            this.userAgentPrefix = userAgentPrefix;
            return this;
        }

        public SpannerOptions build() {
            return new SpannerOptions(this);
        }
    }

    private static class DefaultSpannerRpcFactory
    implements SpannerRpcFactory {
        private static final DefaultSpannerRpcFactory INSTANCE = new DefaultSpannerRpcFactory();

        private DefaultSpannerRpcFactory() {
        }

        public SpannerRpc create(SpannerOptions options) {
            return new DefaultSpannerRpc(options);
        }
    }

    private static class DefaultSpannerFactory
    implements SpannerFactory {
        private static final DefaultSpannerFactory INSTANCE = new DefaultSpannerFactory();

        private DefaultSpannerFactory() {
        }

        public Spanner create(SpannerOptions serviceOptions) {
            return new SpannerImpl(serviceOptions);
        }
    }
}

