/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Date;
import com.google.cloud.spanner.Timestamp;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Struct
extends AbstractStructReader {
    Struct() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Struct)) {
            return false;
        }
        Struct that = (Struct)o;
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (Objects.equals(this.getAsObject(i), that.getAsObject(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            result = 31 * result + Objects.hashCode(this.getAsObject(i));
        }
        return result;
    }

    private Object getAsObject(int columnIndex) {
        Type type = this.getColumnType(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        switch (type.getCode()) {
            case BOOL: {
                return this.getBooleanInternal(columnIndex);
            }
            case INT64: {
                return this.getLongInternal(columnIndex);
            }
            case FLOAT64: {
                return this.getDoubleInternal(columnIndex);
            }
            case STRING: {
                return this.getStringInternal(columnIndex);
            }
            case BYTES: {
                return this.getBytesInternal(columnIndex);
            }
            case TIMESTAMP: {
                return this.getTimestampInternal(columnIndex);
            }
            case DATE: {
                return this.getDateInternal(columnIndex);
            }
            case ARRAY: {
                switch (type.getArrayElementType().getCode()) {
                    case BOOL: {
                        return this.getBooleanListInternal(columnIndex);
                    }
                    case INT64: {
                        return this.getLongListInternal(columnIndex);
                    }
                    case FLOAT64: {
                        return this.getDoubleListInternal(columnIndex);
                    }
                    case STRING: {
                        return this.getStringListInternal(columnIndex);
                    }
                    case BYTES: {
                        return this.getBytesListInternal(columnIndex);
                    }
                    case TIMESTAMP: {
                        return this.getTimestampListInternal(columnIndex);
                    }
                    case DATE: {
                        return this.getDateListInternal(columnIndex);
                    }
                    case STRUCT: {
                        return this.getStructListInternal(columnIndex);
                    }
                }
                throw new AssertionError((Object)("Invalid type " + type));
            }
        }
        throw new AssertionError((Object)("Invalid type " + type));
    }

    private static class ValueListStruct
    extends Struct {
        private final Type type;
        private final List<Value> values;

        private ValueListStruct(List<Type.StructField> types, List<Value> values) {
            this.type = Type.struct(types);
            this.values = ImmutableList.copyOf(values);
        }

        @Override
        protected boolean getBooleanInternal(int columnIndex) {
            return this.values.get(columnIndex).getBool();
        }

        @Override
        protected long getLongInternal(int columnIndex) {
            return this.values.get(columnIndex).getInt64();
        }

        @Override
        protected double getDoubleInternal(int columnIndex) {
            return this.values.get(columnIndex).getFloat64();
        }

        @Override
        protected String getStringInternal(int columnIndex) {
            return this.values.get(columnIndex).getString();
        }

        @Override
        protected ByteArray getBytesInternal(int columnIndex) {
            return this.values.get(columnIndex).getBytes();
        }

        @Override
        protected Timestamp getTimestampInternal(int columnIndex) {
            return this.values.get(columnIndex).getTimestamp();
        }

        @Override
        protected Date getDateInternal(int columnIndex) {
            return this.values.get(columnIndex).getDate();
        }

        @Override
        protected boolean[] getBooleanArrayInternal(int columnIndex) {
            return Booleans.toArray(this.getBooleanListInternal(columnIndex));
        }

        @Override
        protected List<Boolean> getBooleanListInternal(int columnIndex) {
            return this.values.get(columnIndex).getBoolArray();
        }

        @Override
        protected long[] getLongArrayInternal(int columnIndex) {
            return Longs.toArray(this.getLongListInternal(columnIndex));
        }

        @Override
        protected List<Long> getLongListInternal(int columnIndex) {
            return this.values.get(columnIndex).getInt64Array();
        }

        @Override
        protected double[] getDoubleArrayInternal(int columnIndex) {
            return Doubles.toArray(this.getDoubleListInternal(columnIndex));
        }

        @Override
        protected List<Double> getDoubleListInternal(int columnIndex) {
            return this.values.get(columnIndex).getFloat64Array();
        }

        @Override
        protected List<String> getStringListInternal(int columnIndex) {
            return this.values.get(columnIndex).getStringArray();
        }

        @Override
        protected List<ByteArray> getBytesListInternal(int columnIndex) {
            return this.values.get(columnIndex).getBytesArray();
        }

        @Override
        protected List<Timestamp> getTimestampListInternal(int columnIndex) {
            return this.values.get(columnIndex).getTimestampArray();
        }

        @Override
        protected List<Date> getDateListInternal(int columnIndex) {
            return this.values.get(columnIndex).getDateArray();
        }

        @Override
        protected List<Struct> getStructListInternal(int columnIndex) {
            return this.values.get(columnIndex).getStructArray();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isNull(int columnIndex) {
            return this.values.get(columnIndex).isNull();
        }

        public String toString() {
            return this.values.toString();
        }
    }

    public static final class Builder {
        private final List<Type.StructField> types = new ArrayList<Type.StructField>();
        private final List<Value> values = new ArrayList<Value>();
        private final ValueBinder<Builder> binder = new ValueBinder<Builder>(){

            @Override
            Builder handle(Value value) {
                Builder.this.checkBindingInProgress(true);
                Builder.this.addInternal(Builder.this.currentField, value);
                Builder.this.currentField = null;
                return Builder.this;
            }
        };
        private String currentField;

        private Builder() {
        }

        public ValueBinder<Builder> set(String fieldName) {
            this.checkBindingInProgress(false);
            this.currentField = (String)Preconditions.checkNotNull((Object)fieldName);
            return this.binder;
        }

        public Builder add(String fieldName, Value value) {
            this.checkBindingInProgress(false);
            this.addInternal(fieldName, value);
            return this;
        }

        public Builder add(String fieldName, Iterable<Type.StructField> fieldTypes, @Nullable Iterable<Struct> elements) {
            return this.add(fieldName, Value.structArray(fieldTypes, elements));
        }

        public Struct build() {
            this.checkBindingInProgress(false);
            return new ValueListStruct(this.types, this.values);
        }

        private void addInternal(String fieldName, Value value) {
            this.types.add(Type.StructField.of(fieldName, value.getType()));
            this.values.add(value);
        }

        private void checkBindingInProgress(boolean expectInProgress) {
            if (expectInProgress) {
                Preconditions.checkState((this.currentField != null ? 1 : 0) != 0, (Object)"No binding currently active");
            } else if (this.currentField != null) {
                throw new IllegalStateException("Incomplete binding for column " + this.currentField);
            }
        }
    }
}

