/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.GrpcTransportOptions;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Timestamp;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

final class SessionPool {
    private static final Logger logger = Logger.getLogger(SessionPool.class.getName());
    private final SessionPoolOptions options;
    private final DatabaseId db;
    private final SpannerImpl spanner;
    private final ScheduledExecutorService executor;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    final PoolMaintainer poolMaintainer;
    private final Clock clock;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int pendingClosure;
    @GuardedBy(value="lock")
    private SettableFuture<Void> closureFuture;
    @GuardedBy(value="lock")
    private final Queue<PooledSession> readSessions = new LinkedList<PooledSession>();
    @GuardedBy(value="lock")
    private final Queue<PooledSession> writePreparedSessions = new LinkedList<PooledSession>();
    @GuardedBy(value="lock")
    private final Queue<Waiter> readWaiters = new LinkedList<Waiter>();
    @GuardedBy(value="lock")
    private final Queue<Waiter> readWriteWaiters = new LinkedList<Waiter>();
    @GuardedBy(value="lock")
    private int numSessionsBeingPrepared = 0;
    @GuardedBy(value="lock")
    private int totalSessions = 0;
    @GuardedBy(value="lock")
    private int numSessionsBeingCreated = 0;
    @GuardedBy(value="lock")
    private int numSessionsInUse = 0;
    @GuardedBy(value="lock")
    private int maxSessionsInUse = 0;

    static SessionPool createPool(SpannerOptions spannerOptions, DatabaseId db, SpannerImpl spanner) {
        return SessionPool.createPool(spannerOptions.getSessionPoolOptions(), (GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService>)((GrpcTransportOptions)spannerOptions.getTransportOptions()).getExecutorFactory(), db, spanner);
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, DatabaseId db, SpannerImpl spanner) {
        return SessionPool.createPool(poolOptions, executorFactory, db, spanner, new Clock());
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, DatabaseId db, SpannerImpl spanner, Clock clock) {
        SessionPool pool = new SessionPool(poolOptions, executorFactory, (ScheduledExecutorService)executorFactory.get(), db, spanner, clock);
        pool.initPool();
        return pool;
    }

    private SessionPool(SessionPoolOptions options, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, ScheduledExecutorService executor, DatabaseId db, SpannerImpl spanner, Clock clock) {
        this.options = options;
        this.executorFactory = executorFactory;
        this.executor = executor;
        this.db = db;
        this.spanner = spanner;
        this.clock = clock;
        this.poolMaintainer = new PoolMaintainer();
    }

    private void initPool() {
        this.poolMaintainer.init();
        for (int i = 0; i < this.options.getMinSessions(); ++i) {
            this.createSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closureFuture != null;
        }
    }

    private void handleException(SpannerException e, PooledSession session) {
        if (this.isSessionNotFound(e)) {
            this.invalidateSession();
        } else {
            this.releaseSession(session);
        }
    }

    private boolean isSessionNotFound(SpannerException e) {
        return e.getErrorCode() == ErrorCode.NOT_FOUND && e.getMessage().contains("Session not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession() {
        Object object = this.lock;
        synchronized (object) {
            --this.totalSessions;
            this.createSession();
        }
    }

    private PooledSession findSessionToKeepAlive(Queue<PooledSession> queue, Instant keepAliveThreshold) {
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            PooledSession session = (PooledSession)iterator.next();
            if (!session.lastUseTime.isBefore((ReadableInstant)keepAliveThreshold)) continue;
            iterator.remove();
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Session getReadSession() throws SpannerException {
        Waiter waiter = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                throw new IllegalStateException("Pool has been closed");
            }
            Session sess = this.readSessions.poll();
            if (sess != null) {
                this.incrementNumSessionsInUse();
                return sess;
            }
            sess = this.writePreparedSessions.poll();
            if (sess != null) {
                this.incrementNumSessionsInUse();
                return sess;
            }
            this.maybeCreateSession();
            waiter = new Waiter();
            this.readWaiters.add(waiter);
        }
        Session session = waiter.take();
        this.incrementNumSessionsInUse();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Session getReadWriteSession() {
        Waiter waiter = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                throw new IllegalStateException("Pool has been closed");
            }
            PooledSession sess = this.writePreparedSessions.poll();
            if (sess != null) {
                this.incrementNumSessionsInUse();
                return sess;
            }
            if (this.numSessionsBeingPrepared <= this.readWriteWaiters.size()) {
                sess = this.readSessions.poll();
                if (sess != null) {
                    this.prepareSession(sess);
                } else {
                    this.maybeCreateSession();
                }
            }
            waiter = new Waiter();
            this.readWriteWaiters.add(waiter);
        }
        Session session = waiter.take();
        this.incrementNumSessionsInUse();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            if (this.maxSessionsInUse < ++this.numSessionsInUse) {
                this.maxSessionsInUse = this.numSessionsInUse;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCreateSession() {
        Object object = this.lock;
        synchronized (object) {
            if (this.numWaiters() >= this.numSessionsBeingCreated) {
                if (this.canCreateSession()) {
                    this.createSession();
                } else if (this.options.isFailIfPoolExhausted()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.RESOURCE_EXHAUSTED, "No session available");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSession(PooledSession session) {
        Preconditions.checkNotNull((Object)session);
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                this.closeSessionAsync(session.delegate);
                return;
            }
            if (this.readWaiters.size() == 0 && this.numSessionsBeingPrepared >= this.readWriteWaiters.size()) {
                if (this.shouldPrepareSession()) {
                    this.prepareSession(session);
                } else {
                    this.readSessions.add(session);
                }
            } else if (this.shouldUnblockReader()) {
                this.readWaiters.poll().put(session);
            } else {
                this.prepareSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreateSessionFailure(SpannerException e) {
        Object object = this.lock;
        synchronized (object) {
            if (this.readWaiters.size() > 0) {
                this.readWaiters.poll().put(e);
            } else if (this.readWriteWaiters.size() > 0) {
                this.readWriteWaiters.poll().put(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrepareSessionFailure(SpannerException e, PooledSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isSessionNotFound(e)) {
                this.invalidateSession();
            } else if (this.readWriteWaiters.size() > 0) {
                this.readWriteWaiters.poll().put(e);
            } else {
                this.releaseSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> closeAsync() {
        SettableFuture<Void> retFuture = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                throw new IllegalStateException("Close has already been invoked");
            }
            Waiter waiter = this.readWaiters.poll();
            while (waiter != null) {
                waiter.put(SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Client has been closed"));
                waiter = this.readWaiters.poll();
            }
            waiter = this.readWriteWaiters.poll();
            while (waiter != null) {
                waiter.put(SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Client has been closed"));
                waiter = this.readWriteWaiters.poll();
            }
            this.closureFuture = SettableFuture.create();
            retFuture = this.closureFuture;
            this.pendingClosure = this.totalSessions + this.numSessionsBeingCreated;
            if (this.pendingClosure == 0) {
                this.closureFuture.set(null);
            } else {
                for (PooledSession session : Iterables.consumingIterable((Iterable)Iterables.concat(this.readSessions, this.writePreparedSessions))) {
                    this.closeSessionAsync(session.delegate);
                }
            }
        }
        retFuture.addListener(new Runnable(){

            @Override
            public void run() {
                SessionPool.this.executorFactory.release((ExecutorService)SessionPool.this.executor);
            }
        }, MoreExecutors.directExecutor());
        return retFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldUnblockReader() {
        Object object = this.lock;
        synchronized (object) {
            int numWriteWaiters = this.readWriteWaiters.size() - this.numSessionsBeingPrepared;
            return this.readWaiters.size() > numWriteWaiters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldPrepareSession() {
        Object object = this.lock;
        synchronized (object) {
            int preparedSessions = this.writePreparedSessions.size() + this.numSessionsBeingPrepared;
            return (double)preparedSessions < Math.floor(this.options.getWriteSessionsFraction() * (float)this.totalSessions);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numWaiters() {
        Object object = this.lock;
        synchronized (object) {
            return this.readWaiters.size() + this.readWriteWaiters.size();
        }
    }

    private void closeSessionAsync(final Session sess) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                SessionPool.this.closeSession(sess);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(Session sess) {
        try {
            sess.close();
        }
        catch (SpannerException e) {
            logger.log(Level.INFO, "Error while closing session: " + sess.getName(), (Throwable)((Object)e));
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                --this.pendingClosure;
                if (this.pendingClosure == 0) {
                    this.closureFuture.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSession(final PooledSession sess) {
        Object object = this.lock;
        synchronized (object) {
            ++this.numSessionsBeingPrepared;
        }
        this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean closeSession = false;
                try {
                    logger.log(Level.FINE, "Preparing session");
                    sess.prepareReadWriteTransaction();
                    logger.log(Level.FINE, "Session prepared");
                    Object object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.numSessionsBeingPrepared--;
                        if (SessionPool.this.closureFuture != null) {
                            closeSession = true;
                        } else if (SessionPool.this.readWriteWaiters.size() > 0) {
                            ((Waiter)SessionPool.this.readWriteWaiters.poll()).put(sess);
                        } else if (SessionPool.this.readWaiters.size() > 0) {
                            ((Waiter)SessionPool.this.readWaiters.poll()).put(sess);
                        } else {
                            SessionPool.this.writePreparedSessions.add(sess);
                        }
                    }
                }
                catch (SpannerException e) {
                    Object object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.numSessionsBeingPrepared--;
                        if (SessionPool.this.closureFuture != null) {
                            closeSession = true;
                        } else {
                            SessionPool.this.handlePrepareSessionFailure(e, sess);
                        }
                    }
                }
                finally {
                    if (closeSession) {
                        SessionPool.this.closeSession(sess);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCreateSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalSessions + this.numSessionsBeingCreated < this.options.getMaxSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSession() {
        logger.log(Level.FINE, "Creating session");
        Object object = this.lock;
        synchronized (object) {
            ++this.numSessionsBeingCreated;
            this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Session session = null;
                    try {
                        session = SessionPool.this.spanner.createSession(SessionPool.this.db);
                        logger.log(Level.FINE, "Session created");
                    }
                    catch (SpannerException e) {
                        Object object = SessionPool.this.lock;
                        synchronized (object) {
                            SessionPool.this.numSessionsBeingCreated--;
                            if (SessionPool.this.closureFuture != null) {
                                SessionPool.this.pendingClosure--;
                                if (SessionPool.this.pendingClosure == 0) {
                                    SessionPool.this.closureFuture.set(null);
                                }
                            }
                            SessionPool.this.handleCreateSessionFailure(e);
                        }
                        return;
                    }
                    boolean closeSession = false;
                    Object object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.numSessionsBeingCreated--;
                        if (SessionPool.this.closureFuture != null) {
                            closeSession = true;
                        } else {
                            SessionPool.this.totalSessions++;
                            Preconditions.checkState((SessionPool.this.totalSessions <= SessionPool.this.options.getMaxSessions() ? 1 : 0) != 0);
                            SessionPool.this.releaseSession(new PooledSession(session));
                        }
                    }
                    if (closeSession) {
                        SessionPool.this.closeSession(session);
                    }
                }
            });
        }
    }

    final class PoolMaintainer {
        private final Duration windowLength = Duration.millis((long)TimeUnit.MINUTES.toMillis(10L));
        @VisibleForTesting
        static final long LOOP_FREQUENCY = 10000L;
        @VisibleForTesting
        final long numClosureCycles = this.windowLength.getMillis() / 10000L;
        private final Duration keepAliveMilis = Duration.millis((long)TimeUnit.MINUTES.toMillis(SessionPool.access$1300(SessionPool.this).getKeepAliveIntervalMinutes()));
        @VisibleForTesting
        final long numKeepAliveCycles = this.keepAliveMilis.getMillis() / 10000L;
        Instant lastResetTime = new Instant(0L);
        int numSessionsToClose = 0;
        int sessionsToClosePerLoop = 0;

        PoolMaintainer() {
        }

        void init() {
            SessionPool.this.executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    PoolMaintainer.this.maintainPool();
                }
            }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        }

        void maintainPool() {
            if (SessionPool.this.isClosed()) {
                return;
            }
            Instant currTime = SessionPool.this.clock.instant();
            this.closeIdleSessions(currTime);
            this.keepAliveSessions(currTime);
            this.replenishPool();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeIdleSessions(Instant currTime) {
            LinkedList<PooledSession> sessionsToClose = new LinkedList<PooledSession>();
            Iterator iterator = SessionPool.this.lock;
            synchronized (iterator) {
                if (currTime.isAfter((ReadableInstant)this.lastResetTime.plus((ReadableDuration)this.windowLength))) {
                    this.numSessionsToClose = SessionPool.this.totalSessions - (SessionPool.this.maxSessionsInUse + SessionPool.this.options.getMaxIdleSessions());
                    if (this.numSessionsToClose <= SessionPool.this.options.getMinSessions()) {
                        this.numSessionsToClose = 0;
                    } else {
                        this.sessionsToClosePerLoop = (int)Math.ceil((double)this.numSessionsToClose / (double)this.numClosureCycles);
                    }
                    SessionPool.this.maxSessionsInUse = 0;
                    this.lastResetTime = currTime;
                }
                if (this.numSessionsToClose > 0) {
                    while (sessionsToClose.size() < Math.min(this.numSessionsToClose, this.sessionsToClosePerLoop)) {
                        PooledSession sess = (PooledSession)SessionPool.this.readSessions.poll();
                        if (sess != null) {
                            sessionsToClose.add(sess);
                            continue;
                        }
                        sess = (PooledSession)SessionPool.this.writePreparedSessions.poll();
                        if (sess == null) break;
                        sessionsToClose.add(sess);
                    }
                    SessionPool.this.totalSessions = SessionPool.this.totalSessions - sessionsToClose.size();
                    this.numSessionsToClose -= sessionsToClose.size();
                }
            }
            for (PooledSession sess : sessionsToClose) {
                logger.log(Level.FINE, "Closing session %s", sess.getName());
                try {
                    sess.delegate.close();
                }
                catch (SpannerException e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Failed to close session: " + sess.getName(), (Throwable)((Object)e));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepAliveSessions(Instant currTime) {
            long numSessionsToKeepAlive = 0L;
            Object object = SessionPool.this.lock;
            synchronized (object) {
                numSessionsToKeepAlive = (long)Math.ceil((double)SessionPool.this.totalSessions / (double)this.numKeepAliveCycles);
            }
            Instant keepAliveThreshold = currTime.minus((ReadableDuration)this.keepAliveMilis);
            while (numSessionsToKeepAlive > 0L) {
                PooledSession sessionToKeepAlive = null;
                Object object2 = SessionPool.this.lock;
                synchronized (object2) {
                    sessionToKeepAlive = SessionPool.this.findSessionToKeepAlive(SessionPool.this.readSessions, keepAliveThreshold);
                    if (sessionToKeepAlive == null) {
                        sessionToKeepAlive = SessionPool.this.findSessionToKeepAlive(SessionPool.this.writePreparedSessions, keepAliveThreshold);
                    }
                }
                if (sessionToKeepAlive == null) break;
                try {
                    logger.log(Level.FINE, "Keeping alive session " + sessionToKeepAlive.getName());
                    --numSessionsToKeepAlive;
                    sessionToKeepAlive.keepAlive();
                    SessionPool.this.releaseSession(sessionToKeepAlive);
                }
                catch (SpannerException e) {
                    SessionPool.this.handleException(e, sessionToKeepAlive);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replenishPool() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                for (int i = 0; i < SessionPool.this.options.getMinSessions() - (SessionPool.this.totalSessions + SessionPool.this.numSessionsBeingCreated); ++i) {
                    SessionPool.this.createSession();
                }
            }
        }
    }

    private static final class Waiter {
        private final SynchronousQueue<SessionOrError> waiter = new SynchronousQueue();

        private Waiter() {
        }

        private void put(Session session) {
            Uninterruptibles.putUninterruptibly(this.waiter, (Object)new SessionOrError(session));
        }

        private void put(SpannerException e) {
            Uninterruptibles.putUninterruptibly(this.waiter, (Object)new SessionOrError(e));
        }

        private Session take() throws SpannerException {
            SessionOrError s = (SessionOrError)Uninterruptibles.takeUninterruptibly(this.waiter);
            if (s.e != null) {
                throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)s.e));
            }
            return s.session;
        }
    }

    private static final class SessionOrError {
        private Session session;
        private SpannerException e;

        SessionOrError(Session session) {
            this.session = session;
            this.e = null;
        }

        SessionOrError(SpannerException e) {
            this.session = null;
            this.e = e;
        }
    }

    final class PooledSession
    implements Session {
        @VisibleForTesting
        final Session delegate;
        private volatile Instant lastUseTime;
        private volatile SpannerException lastException;

        private PooledSession(Session delegate) {
            this.delegate = delegate;
            this.markUsed();
        }

        @Override
        public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            try {
                this.markUsed();
                Timestamp timestamp = this.delegate.write(mutations);
                return timestamp;
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
            finally {
                this.close();
            }
        }

        @Override
        public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            try {
                this.markUsed();
                Timestamp timestamp = this.delegate.writeAtLeastOnce(mutations);
                return timestamp;
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
            finally {
                this.close();
            }
        }

        @Override
        public ReadContext singleUse() {
            try {
                return new AutoClosingReadContext(this.delegate.singleUse(), this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadContext singleUse(TimestampBound bound) {
            try {
                return new AutoClosingReadContext(this.delegate.singleUse(bound), this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            try {
                return new AutoClosingReadTransaction(this.delegate.singleUseReadOnlyTransaction(), this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
            try {
                return new AutoClosingReadTransaction(this.delegate.singleUseReadOnlyTransaction(bound), this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction() {
            try {
                return new AutoClosingReadTransaction(this.delegate.readOnlyTransaction(), this, false);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
            try {
                return new AutoClosingReadTransaction(this.delegate.readOnlyTransaction(bound), this, false);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public TransactionRunner readWriteTransaction() {
            final TransactionRunner runner = this.delegate.readWriteTransaction();
            return new TransactionRunner(){

                @Override
                @Nullable
                public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
                    try {
                        T result;
                        PooledSession.this.markUsed();
                        T t = result = runner.run(callable);
                        return t;
                    }
                    catch (SpannerException e) {
                        throw PooledSession.this.lastException = e;
                    }
                    finally {
                        PooledSession.this.close();
                    }
                }

                @Override
                public Timestamp getCommitTimestamp() {
                    return runner.getCommitTimestamp();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                SessionPool.this.numSessionsInUse--;
            }
            if (this.lastException != null && SessionPool.this.isSessionNotFound(this.lastException)) {
                SessionPool.this.invalidateSession();
            } else {
                this.lastException = null;
                SessionPool.this.releaseSession(this);
            }
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void prepareReadWriteTransaction() {
            this.markUsed();
            this.delegate.prepareReadWriteTransaction();
        }

        private void keepAlive() {
            this.markUsed();
            this.delegate.singleUse(TimestampBound.ofMaxStaleness(60L, TimeUnit.SECONDS)).executeQuery(Statement.newBuilder("SELECT 1").build(), new Options.QueryOption[0]).next();
        }

        private void markUsed() {
            this.lastUseTime = SessionPool.this.clock.instant();
        }
    }

    private static class AutoClosingReadTransaction
    extends AutoClosingReadContext
    implements ReadOnlyTransaction {
        private final ReadOnlyTransaction txn;

        AutoClosingReadTransaction(ReadOnlyTransaction txn, PooledSession session, boolean isSingleUse) {
            super(txn, session, isSingleUse);
            this.txn = txn;
        }

        @Override
        public Timestamp getReadTimestamp() {
            return this.txn.getReadTimestamp();
        }
    }

    private static class AutoClosingReadContext
    implements ReadContext {
        private final ReadContext delegate;
        private final PooledSession session;
        private final boolean isSingleUse;
        private boolean closed;

        private AutoClosingReadContext(ReadContext delegate, PooledSession session, boolean isSingleUse) {
            this.delegate = delegate;
            this.session = session;
            this.isSingleUse = isSingleUse;
        }

        private ResultSet wrap(ResultSet resultSet) {
            this.session.markUsed();
            if (!this.isSingleUse) {
                return resultSet;
            }
            return new ForwardingResultSet(resultSet){

                @Override
                public boolean next() throws SpannerException {
                    try {
                        boolean ret = super.next();
                        if (!ret) {
                            this.close();
                        }
                        return ret;
                    }
                    catch (SpannerException e) {
                        if (!AutoClosingReadContext.this.closed) {
                            AutoClosingReadContext.this.session.lastException = e;
                            AutoClosingReadContext.this.close();
                        }
                        throw e;
                    }
                }

                @Override
                public void close() {
                    super.close();
                    AutoClosingReadContext.this.close();
                }
            };
        }

        @Override
        public ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap(this.delegate.read(table, keys, columns, options));
        }

        @Override
        public ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap(this.delegate.readUsingIndex(table, index, keys, columns, options));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Struct readRow(String table, Key key, Iterable<String> columns) {
            try {
                this.session.markUsed();
                Struct struct = this.delegate.readRow(table, key, columns);
                return struct;
            }
            finally {
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            try {
                this.session.markUsed();
                Struct struct = this.delegate.readRowUsingIndex(table, index, key, columns);
                return struct;
            }
            finally {
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        @Override
        public ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
            return this.wrap(this.delegate.executeQuery(statement, options));
        }

        @Override
        public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryMode) {
            return this.wrap(this.delegate.analyzeQuery(statement, queryMode));
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.delegate.close();
            this.session.close();
        }
    }

    static class Clock {
        Clock() {
        }

        Instant instant() {
            return Instant.now();
        }
    }
}

