/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.database.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStub;
import com.google.cloud.spanner.admin.database.v1.stub.GrpcDatabaseAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DatabaseAdminStubSettings
extends StubSettings<DatabaseAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/spanner.admin").build();
    private final PagedCallSettings<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings;
    private final UnaryCallSettings<CreateDatabaseRequest, Operation> createDatabaseSettings;
    private final OperationCallSettings<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings;
    private final UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings;
    private final UnaryCallSettings<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings;
    private final OperationCallSettings<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings;
    private final UnaryCallSettings<DropDatabaseRequest, Empty> dropDatabaseSettings;
    private final UnaryCallSettings<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDatabasesRequest, ListDatabasesResponse, Database> LIST_DATABASES_PAGE_STR_DESC = new PagedListDescriptor<ListDatabasesRequest, ListDatabasesResponse, Database>(){

        public String emptyToken() {
            return "";
        }

        public ListDatabasesRequest injectToken(ListDatabasesRequest payload, String token) {
            return ListDatabasesRequest.newBuilder((ListDatabasesRequest)payload).setPageToken(token).build();
        }

        public ListDatabasesRequest injectPageSize(ListDatabasesRequest payload, int pageSize) {
            return ListDatabasesRequest.newBuilder((ListDatabasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatabasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatabasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Database> extractResources(ListDatabasesResponse payload) {
            return payload.getDatabasesList();
        }
    };
    private static final PagedListResponseFactory<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> LIST_DATABASES_PAGE_STR_FACT = new PagedListResponseFactory<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse>(){

        public ApiFuture<DatabaseAdminClient.ListDatabasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> callable, ListDatabasesRequest request, ApiCallContext context, ApiFuture<ListDatabasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATABASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatabaseAdminClient.ListDatabasesPagedResponse.createAsync((PageContext<ListDatabasesRequest, ListDatabasesResponse, Database>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings() {
        return this.listDatabasesSettings;
    }

    public UnaryCallSettings<CreateDatabaseRequest, Operation> createDatabaseSettings() {
        return this.createDatabaseSettings;
    }

    public OperationCallSettings<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings() {
        return this.createDatabaseOperationSettings;
    }

    public UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings() {
        return this.getDatabaseSettings;
    }

    public UnaryCallSettings<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings() {
        return this.updateDatabaseDdlSettings;
    }

    public OperationCallSettings<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings() {
        return this.updateDatabaseDdlOperationSettings;
    }

    public UnaryCallSettings<DropDatabaseRequest, Empty> dropDatabaseSettings() {
        return this.dropDatabaseSettings;
    }

    public UnaryCallSettings<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings() {
        return this.getDatabaseDdlSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DatabaseAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDatabaseAdminStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "spanner.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DatabaseAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatabaseAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DatabaseAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDatabasesSettings = settingsBuilder.listDatabasesSettings().build();
        this.createDatabaseSettings = settingsBuilder.createDatabaseSettings().build();
        this.createDatabaseOperationSettings = settingsBuilder.createDatabaseOperationSettings().build();
        this.getDatabaseSettings = settingsBuilder.getDatabaseSettings().build();
        this.updateDatabaseDdlSettings = settingsBuilder.updateDatabaseDdlSettings().build();
        this.updateDatabaseDdlOperationSettings = settingsBuilder.updateDatabaseDdlOperationSettings().build();
        this.dropDatabaseSettings = settingsBuilder.dropDatabaseSettings().build();
        this.getDatabaseDdlSettings = settingsBuilder.getDatabaseDdlSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DatabaseAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings;
        private final UnaryCallSettings.Builder<CreateDatabaseRequest, Operation> createDatabaseSettings;
        private final OperationCallSettings.Builder<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings;
        private final UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings;
        private final UnaryCallSettings.Builder<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings;
        private final OperationCallSettings.Builder<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings;
        private final UnaryCallSettings.Builder<DropDatabaseRequest, Empty> dropDatabaseSettings;
        private final UnaryCallSettings.Builder<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDatabasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATABASES_PAGE_STR_FACT);
            this.createDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.getDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatabaseDdlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatabaseDdlOperationSettings = OperationCallSettings.newBuilder();
            this.dropDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDatabaseDdlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDatabasesSettings, this.createDatabaseSettings, this.getDatabaseSettings, this.updateDatabaseDdlSettings, this.dropDatabaseSettings, this.getDatabaseDdlSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DatabaseAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DatabaseAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatabaseAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DatabaseAdminStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDatabasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateDatabaseDdlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.dropDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getDatabaseDdlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Database.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatabaseMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            builder.updateDatabaseDdlOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateDatabaseDdlMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        protected Builder(DatabaseAdminStubSettings settings) {
            super((StubSettings)settings);
            this.listDatabasesSettings = settings.listDatabasesSettings.toBuilder();
            this.createDatabaseSettings = settings.createDatabaseSettings.toBuilder();
            this.createDatabaseOperationSettings = settings.createDatabaseOperationSettings.toBuilder();
            this.getDatabaseSettings = settings.getDatabaseSettings.toBuilder();
            this.updateDatabaseDdlSettings = settings.updateDatabaseDdlSettings.toBuilder();
            this.updateDatabaseDdlOperationSettings = settings.updateDatabaseDdlOperationSettings.toBuilder();
            this.dropDatabaseSettings = settings.dropDatabaseSettings.toBuilder();
            this.getDatabaseDdlSettings = settings.getDatabaseDdlSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDatabasesSettings, this.createDatabaseSettings, this.getDatabaseSettings, this.updateDatabaseDdlSettings, this.dropDatabaseSettings, this.getDatabaseDdlSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse, DatabaseAdminClient.ListDatabasesPagedResponse> listDatabasesSettings() {
            return this.listDatabasesSettings;
        }

        public UnaryCallSettings.Builder<CreateDatabaseRequest, Operation> createDatabaseSettings() {
            return this.createDatabaseSettings;
        }

        public OperationCallSettings.Builder<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationSettings() {
            return this.createDatabaseOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings() {
            return this.getDatabaseSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlSettings() {
            return this.updateDatabaseDdlSettings;
        }

        public OperationCallSettings.Builder<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationSettings() {
            return this.updateDatabaseDdlOperationSettings;
        }

        public UnaryCallSettings.Builder<DropDatabaseRequest, Empty> dropDatabaseSettings() {
            return this.dropDatabaseSettings;
        }

        public UnaryCallSettings.Builder<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlSettings() {
            return this.getDatabaseDdlSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DatabaseAdminStubSettings build() throws IOException {
            return new DatabaseAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

