/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.util.Timestamps;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Chronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Timestamp
implements Comparable<Timestamp> {
    public static final Timestamp MIN_VALUE = new Timestamp(-62135596800L, 0);
    public static final Timestamp MAX_VALUE = new Timestamp(253402300799L, (int)TimeUnit.SECONDS.toNanos(1L) - 1);
    private static final Pattern FORMAT_REGEXP = Pattern.compile("([^\\.]*)(\\.\\d{0,9})?Z");
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final DateTimeFormatter format = ISODateTimeFormat.dateHourMinuteSecond().withChronology((Chronology)GregorianChronology.getInstanceUTC());
    private final long seconds;
    private final int nanos;

    private Timestamp(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public static Timestamp ofTimeSecondsAndNanos(long seconds, int nanos) {
        Preconditions.checkArgument((boolean)Timestamps.isValid((long)seconds, (long)nanos), (String)"timestamp out of range: %s, %s", (Object[])new Object[]{seconds, nanos});
        return new Timestamp(seconds, nanos);
    }

    public static Timestamp of(java.sql.Timestamp timestamp) {
        return Timestamp.ofTimeSecondsAndNanos(timestamp.getTime() / 1000L, timestamp.getNanos());
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public java.sql.Timestamp toSqlTimestamp() {
        java.sql.Timestamp ts = new java.sql.Timestamp(this.seconds * 1000L);
        ts.setNanos(this.nanos);
        return ts;
    }

    @Override
    public int compareTo(Timestamp other) {
        int r = Long.compare(this.seconds, other.seconds);
        if (r == 0) {
            r = Integer.compare(this.nanos, other.nanos);
        }
        return r;
    }

    static Timestamp fromProto(com.google.protobuf.Timestamp proto) {
        return new Timestamp(proto.getSeconds(), proto.getNanos());
    }

    com.google.protobuf.Timestamp toProto() {
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(this.seconds).setNanos(this.nanos).build();
    }

    public static Timestamp parseTimestamp(String timestamp) {
        String padded;
        Matcher matcher = FORMAT_REGEXP.matcher(timestamp);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Cannot parse input: " + timestamp);
        }
        String secondsPart = matcher.group(1);
        String nanosPart = matcher.group(2);
        long seconds = format.parseMillis(secondsPart) / 1000L;
        int nanos = 0;
        if (nanosPart != null && (long)(nanos = Integer.parseInt(padded = Strings.padEnd((String)nanosPart.substring(1), (int)9, (char)'0'))) >= TimeUnit.SECONDS.toNanos(1L)) {
            throw new IllegalArgumentException("Cannot parse input: " + timestamp + " (nanos out of range)");
        }
        return Timestamp.ofTimeSecondsAndNanos(seconds, nanos);
    }

    StringBuilder toString(StringBuilder b) {
        format.printTo(b, this.seconds * 1000L);
        if (this.nanos != 0) {
            b.append(String.format(".%09d", this.nanos));
        }
        b.append('Z');
        return b;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp that = (Timestamp)o;
        return this.seconds == that.seconds && this.nanos == that.nanos;
    }

    public int hashCode() {
        return Objects.hash(this.seconds, this.nanos);
    }
}

