/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.ByteArrays;
import com.google.cloud.spanner.Date;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Timestamp;
import com.google.cloud.spanner.Type;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Value {
    private static final int MAX_DEBUG_STRING_LENGTH = 32;
    private static final String ELLIPSIS = "...";
    private static final String NULL_STRING = "NULL";
    private static final char LIST_SEPERATOR = ',';
    private static final char LIST_OPEN = '[';
    private static final char LIST_CLOSE = ']';
    private static final PrimitiveArrayValueFactory<long[], Long> int64ArrayFactory = new PrimitiveArrayValueFactory<long[], Long>(){

        @Override
        long[] newArray(int size) {
            return new long[size];
        }

        @Override
        void set(long[] arr, int i, Long value) {
            arr[i] = value;
        }

        @Override
        Value newValue(boolean isNull, BitSet nulls, long[] values) {
            return new Int64ArrayImpl(isNull, nulls, values);
        }
    };
    private static final PrimitiveArrayValueFactory<double[], Double> float64ArrayFactory = new PrimitiveArrayValueFactory<double[], Double>(){

        @Override
        double[] newArray(int size) {
            return new double[size];
        }

        @Override
        void set(double[] arr, int i, Double value) {
            arr[i] = value;
        }

        @Override
        Value newValue(boolean isNull, BitSet nulls, double[] values) {
            return new Float64ArrayImpl(isNull, nulls, values);
        }
    };
    private static final PrimitiveArrayValueFactory<boolean[], Boolean> boolArrayFactory = new PrimitiveArrayValueFactory<boolean[], Boolean>(){

        @Override
        boolean[] newArray(int size) {
            return new boolean[size];
        }

        @Override
        void set(boolean[] arr, int i, Boolean value) {
            arr[i] = value;
        }

        @Override
        Value newValue(boolean isNull, BitSet nulls, boolean[] values) {
            return new BoolArrayImpl(isNull, nulls, values);
        }
    };

    public static Value bool(@Nullable Boolean v) {
        return new BoolImpl(v == null, v == null ? false : v);
    }

    public static Value bool(boolean v) {
        return new BoolImpl(false, v);
    }

    public static Value int64(@Nullable Long v) {
        return new Int64Impl(v == null, v == null ? 0L : v);
    }

    public static Value int64(long v) {
        return new Int64Impl(false, v);
    }

    public static Value float64(@Nullable Double v) {
        return new Float64Impl(v == null, v == null ? 0.0 : v);
    }

    public static Value float64(double v) {
        return new Float64Impl(false, v);
    }

    public static Value string(@Nullable String v) {
        return new StringImpl(v == null, v);
    }

    public static Value bytes(@Nullable ByteArray v) {
        return new BytesImpl(v == null, v);
    }

    public static Value timestamp(@Nullable Timestamp v) {
        return new TimestampImpl(v == null, v);
    }

    public static Value date(@Nullable Date v) {
        return new DateImpl(v == null, v);
    }

    public static Value boolArray(@Nullable boolean[] v) {
        return Value.boolArray(v, 0, v == null ? 0 : v.length);
    }

    public static Value boolArray(@Nullable boolean[] v, int pos, int length) {
        return boolArrayFactory.create(v, pos, length);
    }

    public static Value boolArray(@Nullable Iterable<Boolean> v) {
        return boolArrayFactory.create(v);
    }

    public static Value int64Array(@Nullable long[] v) {
        return Value.int64Array(v, 0, v == null ? 0 : v.length);
    }

    public static Value int64Array(@Nullable long[] v, int pos, int length) {
        return int64ArrayFactory.create(v, pos, length);
    }

    public static Value int64Array(@Nullable Iterable<Long> v) {
        return int64ArrayFactory.create(v);
    }

    public static Value float64Array(@Nullable double[] v) {
        return Value.float64Array(v, 0, v == null ? 0 : v.length);
    }

    public static Value float64Array(@Nullable double[] v, int pos, int length) {
        return float64ArrayFactory.create(v, pos, length);
    }

    public static Value float64Array(@Nullable Iterable<Double> v) {
        return float64ArrayFactory.create(v);
    }

    public static Value stringArray(@Nullable Iterable<String> v) {
        return new StringArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value bytesArray(@Nullable Iterable<ByteArray> v) {
        return new BytesArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value timestampArray(@Nullable Iterable<Timestamp> v) {
        return new TimestampArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    public static Value dateArray(@Nullable Iterable<Date> v) {
        return new DateArrayImpl(v == null, v == null ? null : Value.immutableCopyOf(v));
    }

    private Value() {
    }

    public abstract Type getType();

    public abstract boolean isNull();

    public abstract boolean getBool();

    public abstract long getInt64();

    public abstract double getFloat64();

    public abstract String getString();

    public abstract ByteArray getBytes();

    public abstract Timestamp getTimestamp();

    public abstract Date getDate();

    public abstract List<Boolean> getBoolArray();

    public abstract List<Long> getInt64Array();

    public abstract List<Double> getFloat64Array();

    public abstract List<String> getStringArray();

    public abstract List<ByteArray> getBytesArray();

    public abstract List<Timestamp> getTimestampArray();

    public abstract List<Date> getDateArray();

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    static Value structArray(Iterable<Type.StructField> fieldTypes, @Nullable Iterable<Struct> v) {
        Type elementType = Type.struct(fieldTypes);
        if (v == null) {
            return new StructArrayImpl(elementType, null);
        }
        List<Struct> values = Value.immutableCopyOf(v);
        for (Struct value : values) {
            if (value == null || value.getType().equals(elementType)) continue;
            throw new IllegalArgumentException("Members of v must have type " + elementType + " (found " + value.getType() + ")");
        }
        return new StructArrayImpl(elementType, values);
    }

    abstract List<Struct> getStructArray();

    abstract void toString(StringBuilder var1);

    abstract com.google.protobuf.Value toProto();

    private static <T> List<T> immutableCopyOf(Iterable<T> v) {
        ArrayList copy = new ArrayList();
        Iterables.addAll(copy, v);
        return Collections.unmodifiableList(copy);
    }

    private static class StructArrayImpl
    extends AbstractValue {
        private static final Joiner joiner = Joiner.on((char)',').useForNull("NULL");
        private final List<Struct> values;

        private StructArrayImpl(Type elementType, @Nullable List<Struct> values) {
            super(values == null, Type.array(elementType));
            this.values = values;
        }

        @Override
        public List<Struct> getStructArray() {
            this.checkType(this.getType());
            this.checkNotNull();
            return this.values;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            throw new UnsupportedOperationException("ARRAY<STRUCT<...>> cannot be serialized to proto");
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append('[');
            joiner.appendTo(b, this.values);
            b.append(']');
        }

        @Override
        boolean valueEquals(Value v) {
            return ((StructArrayImpl)v).values.equals(this.values);
        }

        @Override
        int valueHash() {
            return this.values.hashCode();
        }
    }

    private static class DateArrayImpl
    extends AbstractArrayValue<Date> {
        private DateArrayImpl(boolean isNull, @Nullable List<Date> values) {
            super(isNull, Type.date(), values);
        }

        @Override
        public List<Date> getDateArray() {
            this.checkType(this.getType());
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        void appendElement(StringBuilder b, Date element) {
            element.toString(b);
        }
    }

    private static class TimestampArrayImpl
    extends AbstractArrayValue<Timestamp> {
        private TimestampArrayImpl(boolean isNull, @Nullable List<Timestamp> values) {
            super(isNull, Type.timestamp(), values);
        }

        @Override
        public List<Timestamp> getTimestampArray() {
            this.checkType(this.getType());
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        void appendElement(StringBuilder b, Timestamp element) {
            element.toString(b);
        }
    }

    private static class BytesArrayImpl
    extends AbstractArrayValue<ByteArray> {
        private BytesArrayImpl(boolean isNull, @Nullable List<ByteArray> values) {
            super(isNull, Type.bytes(), values);
        }

        @Override
        public List<ByteArray> getBytesArray() {
            this.checkType(this.getType());
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        String elementToString(ByteArray element) {
            return ByteArrays.toBase64(element);
        }

        @Override
        void appendElement(StringBuilder b, ByteArray element) {
            ByteArrays.appendToString(element, b, 32);
        }
    }

    private static class StringArrayImpl
    extends AbstractArrayValue<String> {
        private StringArrayImpl(boolean isNull, @Nullable List<String> values) {
            super(isNull, Type.string(), values);
        }

        @Override
        public List<String> getStringArray() {
            this.checkType(this.getType());
            this.checkNotNull();
            return (List)this.value;
        }

        @Override
        void appendElement(StringBuilder b, String element) {
            b.append(element);
        }
    }

    static abstract class AbstractArrayValue<T>
    extends AbstractObjectValue<List<T>> {
        private AbstractArrayValue(boolean isNull, Type elementType, @Nullable List<T> values) {
            super(isNull, Type.array(elementType), values);
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            ListValue.Builder list = ListValue.newBuilder();
            for (Object element : (List)this.value) {
                if (element == null) {
                    list.addValues(NULL_PROTO);
                    continue;
                }
                list.addValuesBuilder().setStringValue(this.elementToString(element));
            }
            return com.google.protobuf.Value.newBuilder().setListValue(list).build();
        }

        String elementToString(T element) {
            return element.toString();
        }

        abstract void appendElement(StringBuilder var1, T var2);

        @Override
        void valueToString(StringBuilder b) {
            b.append('[');
            for (int i = 0; i < ((List)this.value).size(); ++i) {
                Object v;
                if (i > 0) {
                    b.append(',');
                }
                if ((v = ((List)this.value).get(i)) == null) {
                    b.append(Value.NULL_STRING);
                    continue;
                }
                this.appendElement(b, v);
            }
            b.append(']');
        }
    }

    private static class Float64ArrayImpl
    extends PrimitiveArrayImpl<Double> {
        private final double[] values;

        private Float64ArrayImpl(boolean isNull, BitSet nulls, double[] values) {
            super(isNull, Type.float64(), nulls);
            this.values = values;
        }

        @Override
        public List<Double> getFloat64Array() {
            return this.getArray();
        }

        @Override
        boolean valueEquals(Value v) {
            Float64ArrayImpl that = (Float64ArrayImpl)v;
            return Arrays.equals(this.values, that.values);
        }

        @Override
        int size() {
            return this.values.length;
        }

        @Override
        Double getValue(int i) {
            return this.values[i];
        }

        @Override
        com.google.protobuf.Value getValueAsProto(int i) {
            return com.google.protobuf.Value.newBuilder().setNumberValue(this.values[i]).build();
        }

        @Override
        int arrayHash() {
            return Arrays.hashCode(this.values);
        }
    }

    private static class Int64ArrayImpl
    extends PrimitiveArrayImpl<Long> {
        private final long[] values;

        private Int64ArrayImpl(boolean isNull, BitSet nulls, long[] values) {
            super(isNull, Type.int64(), nulls);
            this.values = values;
        }

        @Override
        public List<Long> getInt64Array() {
            return this.getArray();
        }

        @Override
        boolean valueEquals(Value v) {
            Int64ArrayImpl that = (Int64ArrayImpl)v;
            return Arrays.equals(this.values, that.values);
        }

        @Override
        int size() {
            return this.values.length;
        }

        @Override
        Long getValue(int i) {
            return this.values[i];
        }

        @Override
        com.google.protobuf.Value getValueAsProto(int i) {
            return com.google.protobuf.Value.newBuilder().setStringValue(Long.toString(this.values[i])).build();
        }

        @Override
        int arrayHash() {
            return Arrays.hashCode(this.values);
        }
    }

    private static class BoolArrayImpl
    extends PrimitiveArrayImpl<Boolean> {
        private final boolean[] values;

        private BoolArrayImpl(boolean isNull, BitSet nulls, boolean[] values) {
            super(isNull, Type.bool(), nulls);
            this.values = values;
        }

        @Override
        public List<Boolean> getBoolArray() {
            return this.getArray();
        }

        @Override
        boolean valueEquals(Value v) {
            BoolArrayImpl that = (BoolArrayImpl)v;
            return Arrays.equals(this.values, that.values);
        }

        @Override
        int size() {
            return this.values.length;
        }

        @Override
        Boolean getValue(int i) {
            return this.values[i];
        }

        @Override
        com.google.protobuf.Value getValueAsProto(int i) {
            return com.google.protobuf.Value.newBuilder().setBoolValue(this.values[i]).build();
        }

        @Override
        int arrayHash() {
            return Arrays.hashCode(this.values);
        }
    }

    private static abstract class PrimitiveArrayImpl<T>
    extends AbstractValue {
        private final BitSet nulls;

        private PrimitiveArrayImpl(boolean isNull, Type elementType, BitSet nulls) {
            super(isNull, Type.array(elementType));
            this.nulls = nulls;
        }

        boolean isElementNull(int i) {
            return this.nulls != null && this.nulls.get(i);
        }

        List<T> getArray() {
            this.checkType(this.getType());
            this.checkNotNull();
            ArrayList<Object> r = new ArrayList<Object>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                r.add(this.isElementNull(i) ? null : (Object)this.getValue(i));
            }
            return r;
        }

        abstract int size();

        abstract T getValue(int var1);

        abstract com.google.protobuf.Value getValueAsProto(int var1);

        @Override
        void valueToString(StringBuilder b) {
            b.append('[');
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                }
                if (this.nulls != null && this.nulls.get(i)) {
                    b.append(Value.NULL_STRING);
                    continue;
                }
                b.append(this.getValue(i));
            }
            b.append(']');
        }

        @Override
        int valueHash() {
            return 31 * Objects.hashCode(this.nulls) + this.arrayHash();
        }

        abstract int arrayHash();

        @Override
        com.google.protobuf.Value valueToProto() {
            ListValue.Builder list = ListValue.newBuilder();
            for (int i = 0; i < this.size(); ++i) {
                if (this.isElementNull(i)) {
                    list.addValues(NULL_PROTO);
                    continue;
                }
                list.addValues(this.getValueAsProto(i));
            }
            return com.google.protobuf.Value.newBuilder().setListValue(list).build();
        }
    }

    private static class DateImpl
    extends AbstractObjectValue<Date> {
        private DateImpl(boolean isNull, Date value) {
            super(isNull, Type.date(), value);
        }

        @Override
        public Date getDate() {
            this.checkType(Type.date());
            this.checkNotNull();
            return (Date)this.value;
        }

        @Override
        void valueToString(StringBuilder b) {
            ((Date)this.value).toString(b);
        }
    }

    private static class TimestampImpl
    extends AbstractObjectValue<Timestamp> {
        private TimestampImpl(boolean isNull, Timestamp value) {
            super(isNull, Type.timestamp(), value);
        }

        @Override
        public Timestamp getTimestamp() {
            this.checkType(Type.timestamp());
            this.checkNotNull();
            return (Timestamp)this.value;
        }

        @Override
        void valueToString(StringBuilder b) {
            ((Timestamp)this.value).toString(b);
        }
    }

    private static class BytesImpl
    extends AbstractObjectValue<ByteArray> {
        private BytesImpl(boolean isNull, ByteArray value) {
            super(isNull, Type.bytes(), value);
        }

        @Override
        public ByteArray getBytes() {
            this.checkType(Type.bytes());
            this.checkNotNull();
            return (ByteArray)this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setStringValue(ByteArrays.toBase64((ByteArray)this.value)).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            ByteArrays.appendToString((ByteArray)this.value, b, 32);
        }
    }

    private static class StringImpl
    extends AbstractObjectValue<String> {
        private StringImpl(boolean isNull, @Nullable String value) {
            super(isNull, Type.string(), value);
        }

        @Override
        public String getString() {
            this.checkType(Type.string());
            this.checkNotNull();
            return (String)this.value;
        }

        @Override
        void valueToString(StringBuilder b) {
            if (((String)this.value).length() > 32) {
                b.append((CharSequence)this.value, 0, 32 - Value.ELLIPSIS.length()).append(Value.ELLIPSIS);
            } else {
                b.append((String)this.value);
            }
        }
    }

    static abstract class AbstractObjectValue<T>
    extends AbstractValue {
        final T value;

        private AbstractObjectValue(boolean isNull, Type type, T value) {
            super(isNull, type);
            this.value = value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setStringValue(this.value.toString()).build();
        }

        @Override
        boolean valueEquals(Value v) {
            return ((AbstractObjectValue)v).value.equals(this.value);
        }

        @Override
        int valueHash() {
            return this.value.hashCode();
        }
    }

    private static class Float64Impl
    extends AbstractValue {
        private final double value;

        private Float64Impl(boolean isNull, double value) {
            super(isNull, Type.float64());
            this.value = value;
        }

        @Override
        public double getFloat64() {
            this.checkType(Type.float64());
            this.checkNotNull();
            return this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setNumberValue(this.value).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        boolean valueEquals(Value v) {
            return ((Float64Impl)v).value == this.value;
        }

        @Override
        int valueHash() {
            return Double.valueOf(this.value).hashCode();
        }
    }

    private static class Int64Impl
    extends AbstractValue {
        private final long value;

        private Int64Impl(boolean isNull, long value) {
            super(isNull, Type.int64());
            this.value = value;
        }

        @Override
        public long getInt64() {
            this.checkType(Type.int64());
            this.checkNotNull();
            return this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setStringValue(Long.toString(this.value)).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        boolean valueEquals(Value v) {
            return ((Int64Impl)v).value == this.value;
        }

        @Override
        int valueHash() {
            return Long.valueOf(this.value).hashCode();
        }
    }

    private static class BoolImpl
    extends AbstractValue {
        private final boolean value;

        private BoolImpl(boolean isNull, boolean value) {
            super(isNull, Type.bool());
            this.value = value;
        }

        @Override
        public boolean getBool() {
            this.checkType(Type.bool());
            this.checkNotNull();
            return this.value;
        }

        @Override
        com.google.protobuf.Value valueToProto() {
            return com.google.protobuf.Value.newBuilder().setBoolValue(this.value).build();
        }

        @Override
        void valueToString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        boolean valueEquals(Value v) {
            return ((BoolImpl)v).value == this.value;
        }

        @Override
        int valueHash() {
            return Boolean.valueOf(this.value).hashCode();
        }
    }

    private static abstract class AbstractValue
    extends Value {
        static final com.google.protobuf.Value NULL_PROTO = com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        private final boolean isNull;
        private final Type type;

        private AbstractValue(boolean isNull, Type type) {
            this.isNull = isNull;
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public final boolean isNull() {
            return this.isNull;
        }

        @Override
        public boolean getBool() {
            throw this.defaultGetter(Type.bool());
        }

        @Override
        public long getInt64() {
            throw this.defaultGetter(Type.int64());
        }

        @Override
        public double getFloat64() {
            throw this.defaultGetter(Type.float64());
        }

        @Override
        public String getString() {
            throw this.defaultGetter(Type.string());
        }

        @Override
        public ByteArray getBytes() {
            throw this.defaultGetter(Type.bytes());
        }

        @Override
        public Timestamp getTimestamp() {
            throw this.defaultGetter(Type.timestamp());
        }

        @Override
        public Date getDate() {
            throw this.defaultGetter(Type.date());
        }

        @Override
        public List<Boolean> getBoolArray() {
            throw this.defaultGetter(Type.array(Type.bool()));
        }

        @Override
        public List<Long> getInt64Array() {
            throw this.defaultGetter(Type.array(Type.int64()));
        }

        @Override
        public List<Double> getFloat64Array() {
            throw this.defaultGetter(Type.array(Type.float64()));
        }

        @Override
        public List<String> getStringArray() {
            throw this.defaultGetter(Type.array(Type.string()));
        }

        @Override
        public List<ByteArray> getBytesArray() {
            throw this.defaultGetter(Type.array(Type.bytes()));
        }

        @Override
        public List<Timestamp> getTimestampArray() {
            throw this.defaultGetter(Type.array(Type.timestamp()));
        }

        @Override
        public List<Date> getDateArray() {
            throw this.defaultGetter(Type.array(Type.date()));
        }

        @Override
        List<Struct> getStructArray() {
            if (this.getType().getCode() != Type.Code.ARRAY || this.getType().getArrayElementType().getCode() != Type.Code.STRUCT) {
                throw new IllegalStateException("Illegal call to getter of incorrect type.  Expected: ARRAY<STRUCT<...>> actual: " + this.getType());
            }
            throw new AssertionError((Object)"Should have been overridden");
        }

        @Override
        final void toString(StringBuilder b) {
            if (this.isNull()) {
                b.append(Value.NULL_STRING);
            } else {
                this.valueToString(b);
            }
        }

        abstract void valueToString(StringBuilder var1);

        @Override
        final com.google.protobuf.Value toProto() {
            return this.isNull() ? NULL_PROTO : this.valueToProto();
        }

        abstract com.google.protobuf.Value valueToProto();

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractValue that = (AbstractValue)o;
            if (!this.getType().equals(that.getType()) || this.isNull != that.isNull) {
                return false;
            }
            return this.isNull || this.valueEquals(that);
        }

        abstract boolean valueEquals(Value var1);

        public final int hashCode() {
            int result = Objects.hash(this.getType(), this.isNull);
            if (!this.isNull) {
                result = 31 * result + this.valueHash();
            }
            return result;
        }

        abstract int valueHash();

        private AssertionError defaultGetter(Type expectedType) {
            this.checkType(expectedType);
            throw new AssertionError((Object)"Should have been overridden");
        }

        final void checkType(Type expected) {
            if (!this.getType().equals(expected)) {
                throw new IllegalStateException("Illegal call to getter of incorrect type.  Expected: " + expected + " actual: " + this.getType());
            }
        }

        final void checkNotNull() {
            Preconditions.checkState((!this.isNull() ? 1 : 0) != 0, (Object)"Illegal call to getter of null value.");
        }
    }

    private static abstract class PrimitiveArrayValueFactory<A, T> {
        private PrimitiveArrayValueFactory() {
        }

        Value create(A v, int pos, int length) {
            if (v == null) {
                return this.newValue(true, null, null);
            }
            A copy = this.newArray(length);
            System.arraycopy(v, pos, copy, 0, length);
            return this.newValue(false, null, copy);
        }

        Value create(@Nullable Iterable<T> v) {
            if (v == null) {
                return this.newValue(true, null, null);
            }
            Collection values = v instanceof Collection ? (Collection)v : Lists.newArrayList(v);
            BitSet nulls = null;
            A arr = this.newArray(values.size());
            int i = 0;
            for (Object element : values) {
                if (element == null) {
                    if (nulls == null) {
                        nulls = new BitSet();
                    }
                    nulls.set(i);
                } else {
                    this.set(arr, i, element);
                }
                ++i;
            }
            return this.newValue(false, nulls, arr);
        }

        abstract A newArray(int var1);

        abstract void set(A var1, int var2, T var3);

        abstract Value newValue(boolean var1, BitSet var2, A var3);
    }
}

