/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.testing;

import com.google.cloud.WaitForOption;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.Operation;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteSpannerHelper {
    private static final Logger logger = Logger.getLogger(RemoteSpannerHelper.class.getName());
    private final SpannerOptions options;
    private final Spanner client;
    private final InstanceId instanceId;
    private static int dbSeq;
    private final List<Database> dbs = new ArrayList<Database>();

    private RemoteSpannerHelper(SpannerOptions options, InstanceId instanceId, Spanner client) {
        this.options = options;
        this.instanceId = instanceId;
        this.client = client;
    }

    public SpannerOptions getOptions() {
        return this.options;
    }

    public Spanner getClient() {
        return this.client;
    }

    public DatabaseClient getDatabaseClient(Database db) {
        return this.getClient().getDatabaseClient(db.getId());
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public Database createTestDatabase(String ... statements) throws SpannerException {
        return this.createTestDatabase(Arrays.asList(statements));
    }

    public String getUniqueDatabaseId() {
        return String.format("testdb_%04d", dbSeq++);
    }

    public Database createTestDatabase(Iterable<String> statements) throws SpannerException {
        String dbId = String.format("testdb_%04d", dbSeq++);
        Operation<Database, CreateDatabaseMetadata> op = this.client.getDatabaseAdminClient().createDatabase(this.instanceId.getInstance(), dbId, statements);
        op = op.waitFor(new WaitForOption[0]);
        Database db = op.getResult();
        logger.log(Level.FINE, "Created test database {0}", db.getId());
        this.dbs.add(db);
        return db;
    }

    public void cleanUp() {
        int numDropped = 0;
        for (Database db : this.dbs) {
            try {
                logger.log(Level.FINE, "Dropping test database {0}", db.getId());
                db.drop();
                ++numDropped;
            }
            catch (SpannerException e) {
                logger.log(Level.SEVERE, "Failed to drop test database " + db.getId(), (Throwable)((Object)e));
            }
        }
        logger.log(Level.INFO, "Dropped {0} test database(s)", numDropped);
        this.client.closeAsync();
    }

    public static RemoteSpannerHelper create(InstanceId instanceId) throws Throwable {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(instanceId.getProject())).build();
        Spanner client = (Spanner)options.getService();
        return new RemoteSpannerHelper(options, instanceId, client);
    }

    public static RemoteSpannerHelper create(SpannerOptions options, InstanceId instanceId) throws Throwable {
        Spanner client = (Spanner)options.getService();
        return new RemoteSpannerHelper(options, instanceId, client);
    }
}

