/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.threeten.bp.Instant;

abstract class BaseSessionPoolTest {
    ScheduledExecutorService mockExecutor;
    int sessionIndex;

    BaseSessionPoolTest() {
    }

    Session mockSession() {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)("projects/dummy/instances/dummy/database/dummy/sessions/session" + this.sessionIndex));
        ++this.sessionIndex;
        return session;
    }

    void runMaintainanceLoop(FakeClock clock, SessionPool pool, long numCycles) {
        int i = 0;
        while ((long)i < numCycles) {
            pool.poolMaintainer.maintainPool();
            clock.currentTimeMillis += 10000L;
            ++i;
        }
    }

    static class FakeClock
    extends SessionPool.Clock {
        volatile long currentTimeMillis;

        FakeClock() {
        }

        public Instant instant() {
            return Instant.ofEpochMilli((long)this.currentTimeMillis);
        }
    }

    final class TestExecutorFactory
    implements GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> {
        TestExecutorFactory() {
        }

        public ScheduledExecutorService get() {
            ScheduledThreadPoolExecutor realExecutor = new ScheduledThreadPoolExecutor(2);
            BaseSessionPoolTest.this.mockExecutor = (ScheduledExecutorService)Mockito.spy((Object)realExecutor);
            ScheduledFuture mockFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
            ((ScheduledExecutorService)Mockito.doReturn((Object)mockFuture).when((Object)BaseSessionPoolTest.this.mockExecutor)).scheduleAtFixedRate((Runnable)Mockito.any(Runnable.class), (Long)Mockito.any(Long.class), (Long)Mockito.any(Long.class), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
            return BaseSessionPoolTest.this.mockExecutor;
        }

        public void release(ScheduledExecutorService executor) {
        }
    }
}

