/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.OperationFutureUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class InstanceAdminClientImplTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String INSTANCE_NAME = "projects/my-project/instances/my-instance";
    private static final String INSTANCE_NAME2 = "projects/my-project/instances/my-instance2";
    private static final String CONFIG_ID = "my-config";
    private static final String CONFIG_NAME = "projects/my-project/instanceConfigs/my-config";
    private static final String CONFIG_NAME2 = "projects/my-project/instanceConfigs/my-config2";
    @Mock
    SpannerRpc rpc;
    @Mock
    DatabaseAdminClient dbClient;
    SpannerImpl.InstanceAdminClientImpl client;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.client = new SpannerImpl.InstanceAdminClientImpl(PROJECT_ID, this.rpc, this.dbClient);
    }

    @Test
    public void getInstanceConfig() {
        Mockito.when((Object)this.rpc.getInstanceConfig(CONFIG_NAME)).thenReturn((Object)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(CONFIG_NAME).build());
        Truth.assertThat((String)this.client.getInstanceConfig(CONFIG_ID).getId().getName()).isEqualTo((Object)CONFIG_NAME);
    }

    @Test
    public void listInstanceConfigs() {
        String nextToken = "token";
        Mockito.when((Object)this.rpc.listInstanceConfigs(1, null)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(CONFIG_NAME).build()), nextToken));
        Mockito.when((Object)this.rpc.listInstanceConfigs(1, nextToken)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(CONFIG_NAME2).build()), ""));
        ArrayList configs = Lists.newArrayList((Iterable)this.client.listInstanceConfigs(new Options.ListOption[]{Options.pageSize((int)1)}).iterateAll());
        Truth.assertThat((String)((InstanceConfig)configs.get(0)).getId().getName()).isEqualTo((Object)CONFIG_NAME);
        Truth.assertThat((String)((InstanceConfig)configs.get(1)).getId().getName()).isEqualTo((Object)CONFIG_NAME2);
        Truth.assertThat((Integer)configs.size()).isEqualTo((Object)2);
    }

    private com.google.spanner.admin.instance.v1.Instance getInstanceProto() {
        return com.google.spanner.admin.instance.v1.Instance.newBuilder().setConfig(CONFIG_NAME).setName(INSTANCE_NAME).setNodeCount(1).build();
    }

    private com.google.spanner.admin.instance.v1.Instance getAnotherInstanceProto() {
        return com.google.spanner.admin.instance.v1.Instance.newBuilder().setConfig(CONFIG_NAME).setName(INSTANCE_NAME2).setNodeCount(1).build();
    }

    @Test
    public void createInstance() throws Exception {
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, CreateInstanceMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createInstance", this.getInstanceProto(), CreateInstanceMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.createInstance("projects/my-project", INSTANCE_ID, this.getInstanceProto())).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).setInstanceConfigId(InstanceConfigId.of((String)PROJECT_ID, (String)CONFIG_ID)).setNodeCount(1).build());
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Instance)op.get()).getId().getName()).isEqualTo((Object)INSTANCE_NAME);
    }

    @Test
    public void getInstance() {
        Mockito.when((Object)this.rpc.getInstance(INSTANCE_NAME)).thenReturn((Object)this.getInstanceProto());
        Truth.assertThat((String)this.client.getInstance(INSTANCE_ID).getId().getName()).isEqualTo((Object)INSTANCE_NAME);
    }

    @Test
    public void dropInstance() {
        this.client.deleteInstance(INSTANCE_ID);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).deleteInstance(INSTANCE_NAME);
    }

    @Test
    public void updateInstanceMetadata() throws Exception {
        com.google.spanner.admin.instance.v1.Instance instance = com.google.spanner.admin.instance.v1.Instance.newBuilder().setName(INSTANCE_NAME).setConfig(CONFIG_NAME).setNodeCount(2).build();
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, UpdateInstanceMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("updateInstance", this.getInstanceProto(), UpdateInstanceMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.updateInstance(instance, FieldMask.newBuilder().addPaths("node_count").build())).thenReturn(rawOperationFuture);
        InstanceInfo instanceInfo = InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)INSTANCE_NAME)).setInstanceConfigId(InstanceConfigId.of((String)CONFIG_NAME)).setNodeCount(2).build();
        OperationFuture op = this.client.updateInstance(instanceInfo, new InstanceInfo.InstanceField[]{InstanceInfo.InstanceField.NODE_COUNT});
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Instance)op.get()).getId().getName()).isEqualTo((Object)INSTANCE_NAME);
    }

    @Test
    public void listInstances() {
        String nextToken = "token";
        String filter = "env:dev";
        Mockito.when((Object)this.rpc.listInstances(1, null, filter)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getInstanceProto()), nextToken));
        Mockito.when((Object)this.rpc.listInstances(1, nextToken, filter)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getAnotherInstanceProto()), ""));
        ArrayList instances = Lists.newArrayList((Iterable)this.client.listInstances(new Options.ListOption[]{Options.pageSize((int)1), Options.filter((String)filter)}).iterateAll());
        Truth.assertThat((String)((Instance)instances.get(0)).getId().getName()).isEqualTo((Object)INSTANCE_NAME);
        Truth.assertThat((String)((Instance)instances.get(1)).getId().getName()).isEqualTo((Object)INSTANCE_NAME2);
        Truth.assertThat((Integer)instances.size()).isEqualTo((Object)2);
    }
}

