/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class OperationFutureUtil {
    private OperationFutureUtil() {
    }

    public static final <ResponseT extends Message, MetadataT extends Message> OperationSnapshot completedSnapshot(final String name, final ResponseT response, final MetadataT metadata) {
        return new OperationSnapshot(){

            public String getName() {
                return name;
            }

            public Object getMetadata() {
                return Any.pack((Message)metadata);
            }

            public Object getResponse() {
                return Any.pack((Message)response);
            }

            public boolean isDone() {
                return true;
            }

            public StatusCode getErrorCode() {
                return FakeStatusCode.of(StatusCode.Code.OK);
            }

            public String getErrorMessage() {
                return null;
            }
        };
    }

    public static final <ResponseT> RetryingFuture<ResponseT> immediateRetryingFuture(ResponseT response) {
        return new ImmediateRetryingFuture<ResponseT>(response);
    }

    public static final <ResponseT extends Message, MetadataT extends Message> OperationFuture<ResponseT, MetadataT> immediateOperationFuture(String name, ResponseT response, MetadataT metadata) {
        return OperationFutureUtil.immediateOperationFuture(OperationFutureUtil.completedSnapshot(name, response, metadata));
    }

    public static final <ResponseT, MetadataT> OperationFuture<ResponseT, MetadataT> immediateOperationFuture(final OperationSnapshot completedSnapshot) {
        Preconditions.checkArgument((boolean)completedSnapshot.isDone(), (Object)"given snapshot must already be completed");
        final ApiFuture metadataFuture = ApiFutures.immediateFuture((Object)completedSnapshot.getMetadata());
        final ApiFuture initialFuture = ApiFutures.immediateFuture((Object)completedSnapshot);
        final RetryingFuture<OperationSnapshot> pollingFuture = OperationFutureUtil.immediateRetryingFuture(completedSnapshot);
        return new OperationFuture<ResponseT, MetadataT>(){

            public String getName() {
                return completedSnapshot.getName();
            }

            public ApiFuture<MetadataT> getMetadata() {
                return metadataFuture;
            }

            public ApiFuture<MetadataT> peekMetadata() {
                return metadataFuture;
            }

            public ApiFuture<OperationSnapshot> getInitialFuture() {
                return initialFuture;
            }

            public RetryingFuture<OperationSnapshot> getPollingFuture() {
                return pollingFuture;
            }

            public void addListener(Runnable runnable, Executor executor) {
                pollingFuture.addListener(runnable, executor);
            }

            public ResponseT get(long time, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
                return this.get();
            }

            public ResponseT get() throws ExecutionException, InterruptedException {
                return ((OperationSnapshot)pollingFuture.get()).getResponse();
            }

            public boolean isDone() {
                return true;
            }

            public boolean isCancelled() {
                return false;
            }

            public boolean cancel(boolean b) {
                return false;
            }
        };
    }

    public static final class ImmediateRetryingFuture<V>
    implements RetryingFuture<V> {
        private final ApiFuture<V> immediateFuture;
        private ApiFuture<V> attemptFuture;

        ImmediateRetryingFuture(V response) {
            this.immediateFuture = ApiFutures.immediateFuture(response);
        }

        public void addListener(Runnable runnable, Executor executor) {
            this.immediateFuture.addListener(runnable, executor);
        }

        public V get(long time, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return this.get();
        }

        public V get() throws ExecutionException, InterruptedException {
            return (V)this.immediateFuture.get();
        }

        public boolean isDone() {
            return true;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean cancel(boolean b) {
            return false;
        }

        public void setAttemptFuture(ApiFuture<V> attemptFuture) {
            this.attemptFuture = attemptFuture;
        }

        public ApiFuture<V> getAttemptResult() {
            return this.attemptFuture;
        }

        public TimedAttemptSettings getAttemptSettings() {
            throw new UnsupportedOperationException("Not implemented: getAttemptSettings()");
        }

        public Callable<V> getCallable() {
            throw new UnsupportedOperationException("Not implemented: getCallable()");
        }

        public ApiFuture<V> peekAttemptResult() {
            return this.attemptFuture;
        }
    }

    public static class FakeStatusCode
    implements StatusCode {
        private final StatusCode.Code code;

        public FakeStatusCode(StatusCode.Code code) {
            this.code = code;
        }

        public StatusCode.Code getCode() {
            return this.code;
        }

        public StatusCode.Code getTransportCode() {
            return this.getCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FakeStatusCode that = (FakeStatusCode)o;
            return this.code == that.code;
        }

        public int hashCode() {
            return this.code != null ? this.code.hashCode() : 0;
        }

        public static FakeStatusCode of(StatusCode.Code code) {
            return new FakeStatusCode(code);
        }
    }
}

