/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.protobuf.util.Timestamps;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.Mutation;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.Transaction;
import java.text.ParseException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class SessionImplTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SpannerOptions spannerOptions;
    private Session session;
    @Captor
    private ArgumentCaptor<Map<SpannerRpc.Option, Object>> optionsCaptor;
    private Map<SpannerRpc.Option, Object> options;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        SpannerImpl spanner = new SpannerImpl(this.rpc, 1, this.spannerOptions);
        String dbName = "projects/p1/instances/i1/databases/d1";
        String sessionName = dbName + "/sessions/s1";
        DatabaseId db = DatabaseId.of((String)dbName);
        com.google.spanner.v1.Session sessionProto = com.google.spanner.v1.Session.newBuilder().setName(sessionName).build();
        Mockito.when((Object)this.rpc.createSession((String)Mockito.eq((Object)dbName), Mockito.anyMapOf(String.class, String.class), (Map)this.optionsCaptor.capture())).thenReturn((Object)sessionProto);
        this.session = spanner.createSession(db);
        this.options = (Map)this.optionsCaptor.getValue();
        Mockito.reset((Object[])new SpannerRpc[]{this.rpc});
    }

    @Test
    public void writeAtLeastOnce() throws ParseException {
        String timestampString = "2015-10-01T10:54:20.021Z";
        ArgumentCaptor commit = ArgumentCaptor.forClass(CommitRequest.class);
        CommitResponse response = CommitResponse.newBuilder().setCommitTimestamp(Timestamps.parse((String)timestampString)).build();
        Mockito.when((Object)this.rpc.commit((CommitRequest)commit.capture(), (Map)Mockito.eq(this.options))).thenReturn((Object)response);
        Timestamp timestamp = this.session.writeAtLeastOnce(Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C").to("x")).build()));
        Truth.assertThat((Long)timestamp.getSeconds()).isEqualTo((Object)SessionImplTest.utcTimeSeconds(2015, 9, 1, 10, 54, 20));
        Truth.assertThat((Integer)timestamp.getNanos()).isEqualTo((Object)TimeUnit.MILLISECONDS.toNanos(21L));
        CommitRequest request = (CommitRequest)commit.getValue();
        Truth.assertThat((Object)request.getSingleUseTransaction()).isNotNull();
        Truth.assertThat((Object)request.getSingleUseTransaction().getReadWrite()).isNotNull();
        com.google.spanner.v1.Mutation mutation = com.google.spanner.v1.Mutation.newBuilder().setInsert(Mutation.Write.newBuilder().setTable("T").addColumns("C").addValues(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("x")))).build();
        Truth.assertThat((Iterable)request.getMutationsList()).containsExactly(new Object[]{mutation});
    }

    private static long utcTimeSeconds(int year, int month, int day, int hour, int min, int secs) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(year, month, day, hour, min, secs);
        return calendar.getTimeInMillis() / 1000L;
    }

    @Test
    public void newSingleUseContextClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.singleUse(TimestampBound.strong());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    @Test
    public void newSingleUseContextClosesOldSingleUseReadOnlyTransactionContext() {
        ReadOnlyTransaction ctx = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        this.session.singleUse(TimestampBound.strong());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    @Test
    public void newSingleUseContextClosesOldMultiUseReadOnlyTransactionContext() {
        ReadOnlyTransaction ctx = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        this.session.singleUse(TimestampBound.strong());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    @Test
    public void newSingleUseReadOnlyTransactionContextClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    @Test
    public void newMultiUseReadOnlyTransactionContextClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.readOnlyTransaction(TimestampBound.strong());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    @Test
    public void writeClosesOldSingleUseContext() throws ParseException {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        Mockito.when((Object)this.rpc.commit((CommitRequest)Mockito.any(), (Map)Mockito.eq(this.options))).thenReturn((Object)CommitResponse.newBuilder().setCommitTimestamp(Timestamps.parse((String)"2015-10-01T10:54:20.021Z")).build());
        this.session.writeAtLeastOnce(Arrays.asList(new Mutation[0]));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    @Test
    public void transactionClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.readWriteTransaction();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    @Test
    public void singleUseContextClosesTransaction() {
        TransactionRunner runner = this.session.readWriteTransaction();
        this.session.singleUse(TimestampBound.strong());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            @Nullable
            public Void run(TransactionContext transaction) throws SpannerException {
                Assert.fail((String)"Unexpected call to transaction body");
                return null;
            }
        });
    }

    @Test
    public void prepareClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)Mockito.eq(this.options))).thenReturn((Object)Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"t1")).build());
        this.session.prepareReadWriteTransaction();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("invalidated");
        ctx.read("Dummy", KeySet.all(), Arrays.asList("C"), new Options.ReadOption[0]);
    }

    private static ResultSetMetadata newMetadata(Type type) {
        return ResultSetMetadata.newBuilder().setRowType(type.toProto().getStructType()).build();
    }

    @Test
    public void singleUseReadOnlyTransactionDoesntReturnTransactionMetadata() {
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        Truth.assertThat((Object)txn.readRow("Dummy", Key.of((Object[])new Object[0]), Arrays.asList("C"))).isNull();
        this.expectedException.expect(IllegalStateException.class);
        txn.getReadTimestamp();
    }

    @Test
    public void singleUseReadOnlyTransactionReturnsEmptyTransactionMetadata() {
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())})).toBuilder().setTransaction(Transaction.getDefaultInstance())).build();
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        txn.readRow("Dummy", Key.of((Object[])new Object[0]), Arrays.asList("C"));
    }

    private void mockRead(final PartialResultSet myResultSet) {
        final ArgumentCaptor consumer = ArgumentCaptor.forClass(SpannerRpc.ResultStreamConsumer.class);
        Mockito.when((Object)this.rpc.read((ReadRequest)Mockito.any(), (SpannerRpc.ResultStreamConsumer)consumer.capture(), (Map)Mockito.eq(this.options))).then((Answer)new Answer<SpannerRpc.StreamingCall>(){

            public SpannerRpc.StreamingCall answer(InvocationOnMock invocation) throws Throwable {
                ((SpannerRpc.ResultStreamConsumer)consumer.getValue()).onPartialResultSet(myResultSet);
                ((SpannerRpc.ResultStreamConsumer)consumer.getValue()).onCompleted();
                return new NoOpStreamingCall();
            }
        });
    }

    @Test
    public void multiUseReadOnlyTransactionReturnsEmptyTransactionMetadata() {
        Transaction txnMetadata = Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"x")).build();
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)Mockito.eq(this.options))).thenReturn((Object)txnMetadata);
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.readOnlyTransaction(TimestampBound.strong());
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        txn.readRow("Dummy", Key.of((Object[])new Object[0]), Arrays.asList("C"));
    }

    @Test
    public void multiUseReadOnlyTransactionReturnsMissingTimestamp() {
        Transaction txnMetadata = Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"x")).build();
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)Mockito.eq(this.options))).thenReturn((Object)txnMetadata);
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.readOnlyTransaction(TimestampBound.strong());
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        txn.readRow("Dummy", Key.of((Object[])new Object[0]), Arrays.asList("C"));
    }

    @Test
    public void multiUseReadOnlyTransactionReturnsMissingTransactionId() throws ParseException {
        com.google.protobuf.Timestamp t = Timestamps.parse((String)"2015-10-01T10:54:20.021Z");
        Transaction txnMetadata = Transaction.newBuilder().setReadTimestamp(t).build();
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)Mockito.eq(this.options))).thenReturn((Object)txnMetadata);
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.readOnlyTransaction(TimestampBound.strong());
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        txn.readRow("Dummy", Key.of((Object[])new Object[0]), Arrays.asList("C"));
    }

    private static class NoOpStreamingCall
    implements SpannerRpc.StreamingCall {
        private NoOpStreamingCall() {
        }

        public void cancel(@Nullable String message) {
        }

        public void request(int numMessages) {
        }
    }
}

