/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class SessionPoolTest
extends BaseSessionPoolTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter
    public int minSessions;
    @Mock
    SpannerImpl client;
    DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    SessionPool pool;
    SessionPoolOptions options;

    @Parameterized.Parameters(name="min sessions = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {1});
    }

    private SessionPool createPool() {
        return SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(), (DatabaseId)this.db, (SpannerImpl)this.client);
    }

    private SessionPool createPool(SessionPool.Clock clock) {
        return SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(), (DatabaseId)this.db, (SpannerImpl)this.client, (SessionPool.Clock)clock);
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(2).setBlockIfPoolExhausted().build();
    }

    private void setupMockSessionCreation() {
        Mockito.when((Object)this.client.createSession(this.db)).thenAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                return SessionPoolTest.this.mockSession();
            }
        });
    }

    @Test
    public void sessionCreation() {
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        try (Session session = this.pool.getReadSession();){
            Truth.assertThat((Object)session).isNotNull();
        }
    }

    @Test
    public void poolClosure() throws Exception {
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        this.pool.closeAsync().get();
    }

    @Test
    public void poolClosureClosesLeakedSessions() throws Exception {
        Session mockSession1 = this.mockSession();
        Session mockSession2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.pool = this.createPool();
        Session session1 = this.pool.getReadSession();
        this.pool.getReadSession();
        session1.close();
        this.pool.closeAsync().get();
        ((Session)Mockito.verify((Object)mockSession1)).close();
        ((Session)Mockito.verify((Object)mockSession2)).close();
    }

    @Test
    public void poolClosesWhenMaintenanceLoopIsRunning() throws Exception {
        this.setupMockSessionCreation();
        final BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        this.pool = this.createPool(clock);
        final AtomicBoolean stop = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stop.get()) {
                    SessionPoolTest.this.runMaintainanceLoop(clock, SessionPoolTest.this.pool, 1L);
                }
            }
        }).start();
        this.pool.closeAsync().get();
        stop.set(true);
    }

    @Test
    public void poolClosureFailsPendingReadWaiters() throws Exception {
        final CountDownLatch insideCreation = new CountDownLatch(1);
        final CountDownLatch releaseCreation = new CountDownLatch(1);
        Session session1 = this.mockSession();
        final Session session2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session1).thenAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insideCreation.countDown();
                releaseCreation.await();
                return session2;
            }
        });
        this.pool = this.createPool();
        this.pool.getReadSession();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getSessionAsync(latch, failed);
        insideCreation.await();
        this.pool.closeAsync();
        releaseCreation.countDown();
        latch.await();
        Truth.assertThat((Boolean)failed.get()).isTrue();
    }

    @Test
    public void poolClosureFailsPendingWriteWaiters() throws Exception {
        final CountDownLatch insideCreation = new CountDownLatch(1);
        final CountDownLatch releaseCreation = new CountDownLatch(1);
        Session session1 = this.mockSession();
        final Session session2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session1).thenAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insideCreation.countDown();
                releaseCreation.await();
                return session2;
            }
        });
        this.pool = this.createPool();
        this.pool.getReadSession();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getReadWriteSessionAsync(latch, failed);
        insideCreation.await();
        this.pool.closeAsync();
        releaseCreation.countDown();
        latch.await();
        Truth.assertThat((Boolean)failed.get()).isTrue();
    }

    @Test
    public void poolClosesEvenIfCreationFails() throws Exception {
        final CountDownLatch insideCreation = new CountDownLatch(1);
        final CountDownLatch releaseCreation = new CountDownLatch(1);
        Mockito.when((Object)this.client.createSession(this.db)).thenAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insideCreation.countDown();
                releaseCreation.await();
                throw SpannerExceptionFactory.newSpannerException((Throwable)new RuntimeException());
            }
        });
        this.pool = this.createPool();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getSessionAsync(latch, failed);
        insideCreation.await();
        ListenableFuture f = this.pool.closeAsync();
        releaseCreation.countDown();
        f.get();
        Truth.assertThat((Boolean)f.isDone()).isTrue();
    }

    @Test
    public void poolClosesEvenIfPreparationFails() throws Exception {
        Session session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        final CountDownLatch insidePrepare = new CountDownLatch(1);
        final CountDownLatch releasePrepare = new CountDownLatch(1);
        ((Session)Mockito.doAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insidePrepare.countDown();
                releasePrepare.await();
                throw SpannerExceptionFactory.newSpannerException((Throwable)new RuntimeException());
            }
        }).when((Object)session)).prepareReadWriteTransaction();
        this.pool = this.createPool();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getReadWriteSessionAsync(latch, failed);
        insidePrepare.await();
        ListenableFuture f = this.pool.closeAsync();
        releasePrepare.countDown();
        f.get();
        Truth.assertThat((Boolean)f.isDone()).isTrue();
    }

    @Test
    public void poolClosureFailsNewRequests() throws Exception {
        Session session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        this.pool = this.createPool();
        this.pool.getReadSession();
        this.pool.closeAsync();
        this.expectedException.expect(IllegalStateException.class);
        this.pool.getReadSession();
    }

    @Test
    public void atMostMaxSessionsCreated() {
        this.setupMockSessionCreation();
        AtomicBoolean failed = new AtomicBoolean(false);
        this.pool = this.createPool();
        int numSessions = 10;
        CountDownLatch latch = new CountDownLatch(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            this.getSessionAsync(latch, failed);
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        ((SpannerImpl)Mockito.verify((Object)this.client, (VerificationMode)Mockito.atMost((int)this.options.getMaxSessions()))).createSession(this.db);
        Truth.assertThat((Boolean)failed.get()).isFalse();
    }

    @Test
    public void creationExceptionPropagatesToReadSession() {
        Mockito.when((Object)this.client.createSession(this.db)).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)"")});
        this.pool = this.createPool();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        this.pool.getReadSession();
    }

    @Test
    public void creationExceptionPropagatesToReadWriteSession() {
        Mockito.when((Object)this.client.createSession(this.db)).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)"")});
        this.pool = this.createPool();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        this.pool.getReadWriteSession();
    }

    @Test
    public void prepareExceptionPropagatesToReadWriteSession() {
        Session session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        ((Session)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)"")).when((Object)session)).prepareReadWriteTransaction();
        this.pool = this.createPool();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        this.pool.getReadWriteSession();
    }

    @Test
    public void getReadWriteSession() {
        Session mockSession = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession);
        this.pool = this.createPool();
        try (Session session = this.pool.getReadWriteSession();){
            Truth.assertThat((Object)session).isNotNull();
            ((Session)Mockito.verify((Object)mockSession)).prepareReadWriteTransaction();
        }
    }

    @Test
    public void getMultipleReadWriteSessions() {
        Session mockSession1 = this.mockSession();
        Session mockSession2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.pool = this.createPool();
        Session session1 = this.pool.getReadWriteSession();
        Session session2 = this.pool.getReadWriteSession();
        ((Session)Mockito.verify((Object)mockSession1)).prepareReadWriteTransaction();
        ((Session)Mockito.verify((Object)mockSession2)).prepareReadWriteTransaction();
        session1.close();
        session2.close();
    }

    @Test
    public void getMultipleConcurrentReadWriteSessions() {
        AtomicBoolean failed = new AtomicBoolean(false);
        Session session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        this.pool = this.createPool();
        int numSessions = 5;
        CountDownLatch latch = new CountDownLatch(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            this.getReadWriteSessionAsync(latch, failed);
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
    }

    @Test
    public void sessionIsPrePrepared() {
        Session mockSession1 = this.mockSession();
        Session mockSession2 = this.mockSession();
        final CountDownLatch prepareLatch = new CountDownLatch(1);
        ((Session)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock arg0) throws Throwable {
                prepareLatch.countDown();
                return null;
            }
        }).when((Object)mockSession1)).prepareReadWriteTransaction();
        ((Session)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock arg0) throws Throwable {
                prepareLatch.countDown();
                return null;
            }
        }).when((Object)mockSession2)).prepareReadWriteTransaction();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.options = SessionPoolOptions.newBuilder().setMinSessions(2).setMaxSessions(2).setWriteSessionsFraction(0.5f).build();
        this.pool = this.createPool();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)prepareLatch);
        SessionPool.PooledSession readSession = (SessionPool.PooledSession)this.pool.getReadSession();
        SessionPool.PooledSession writeSession = (SessionPool.PooledSession)this.pool.getReadWriteSession();
        ((Session)Mockito.verify((Object)writeSession.delegate, (VerificationMode)Mockito.times((int)1))).prepareReadWriteTransaction();
        ((Session)Mockito.verify((Object)readSession.delegate, (VerificationMode)Mockito.never())).prepareReadWriteTransaction();
        readSession.close();
        writeSession.close();
    }

    @Test
    public void getReadSessionFallsBackToWritePreparedSession() throws Exception {
        Session mockSession1 = this.mockSession();
        final CountDownLatch prepareLatch = new CountDownLatch(2);
        ((Session)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock arg0) throws Throwable {
                prepareLatch.countDown();
                return null;
            }
        }).when((Object)mockSession1)).prepareReadWriteTransaction();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1);
        this.options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(1).setWriteSessionsFraction(1.0f).build();
        this.pool = this.createPool();
        this.pool.getReadWriteSession().close();
        prepareLatch.await();
        SessionPool.PooledSession readSession = (SessionPool.PooledSession)this.pool.getReadSession();
        ((Session)Mockito.verify((Object)readSession.delegate, (VerificationMode)Mockito.times((int)2))).prepareReadWriteTransaction();
    }

    @Test
    public void failOnPoolExhaustion() {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setFailIfPoolExhausted().build();
        Session mockSession = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession);
        this.pool = this.createPool();
        Session session1 = this.pool.getReadSession();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.RESOURCE_EXHAUSTED));
        this.pool.getReadSession();
        session1.close();
        session1 = this.pool.getReadSession();
        Truth.assertThat((Object)session1).isNotNull();
        session1.close();
    }

    @Test
    public void poolWorksWhenSessionNotFound() {
        Session mockSession1 = this.mockSession();
        Session mockSession2 = this.mockSession();
        ((Session)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found")).when((Object)mockSession1)).prepareReadWriteTransaction();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.pool = this.createPool();
        Truth.assertThat((Object)((SessionPool.PooledSession)this.pool.getReadWriteSession()).delegate).isEqualTo((Object)mockSession2);
    }

    @Test
    public void idleSessionCleanup() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(3).setMaxIdleSessions(0).build();
        Session session1 = this.mockSession();
        Session session2 = this.mockSession();
        Session session3 = this.mockSession();
        final AtomicInteger numSessionClosed = new AtomicInteger();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session1).thenReturn((Object)session2).thenReturn((Object)session3);
        for (Session session : new Session[]{session1, session2, session3}) {
            ((Session)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    numSessionClosed.incrementAndGet();
                    return null;
                }
            }).when((Object)session)).close();
        }
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        this.pool.getReadSession().close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Integer)numSessionClosed.get()).isEqualTo((Object)0);
        Session readSession1 = this.pool.getReadSession();
        Session readSession2 = this.pool.getReadSession();
        Session readSession3 = this.pool.getReadSession();
        readSession1.close();
        readSession2.close();
        readSession3.close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Integer)numSessionClosed.get()).isEqualTo((Object)0);
        this.pool.getReadSession().close();
        this.pool.getReadSession().close();
        this.pool.getReadSession().close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Integer)numSessionClosed.get()).isEqualTo((Object)2);
        this.pool.closeAsync().get();
    }

    @Test
    public void keepAlive() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(2).setMaxSessions(3).build();
        Session session = this.mockSession();
        this.mockKeepAlive(session);
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        Session session1 = this.pool.getReadSession();
        Session session2 = this.pool.getReadSession();
        session1.close();
        session2.close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).singleUse((TimestampBound)Matchers.any(TimestampBound.class));
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)2))).singleUse((TimestampBound)Matchers.any(TimestampBound.class));
        clock.currentTimeMillis += clock.currentTimeMillis + 0x200B20L;
        session1 = this.pool.getReadSession();
        session1.writeAtLeastOnce(new ArrayList());
        session1.close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)3))).singleUse((TimestampBound)Matchers.any(TimestampBound.class));
        this.pool.closeAsync().get();
    }

    private void mockKeepAlive(Session session) {
        ReadContext context = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)session.singleUse((TimestampBound)Matchers.any(TimestampBound.class))).thenReturn((Object)context);
        Mockito.when((Object)context.executeQuery((Statement)Matchers.any(Statement.class), new Options.QueryOption[0])).thenReturn((Object)resultSet);
    }

    private void getSessionAsync(final CountDownLatch latch, final AtomicBoolean failed) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (Session session = SessionPoolTest.this.pool.getReadSession();){
                    failed.compareAndSet(false, session == null);
                    Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                catch (SpannerException e) {
                    failed.compareAndSet(false, true);
                }
                finally {
                    latch.countDown();
                }
            }
        }).start();
    }

    private void getReadWriteSessionAsync(final CountDownLatch latch, final AtomicBoolean failed) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (Session session = SessionPoolTest.this.pool.getReadWriteSession();){
                    failed.compareAndSet(false, session == null);
                    Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                catch (SpannerException e) {
                    failed.compareAndSet(false, true);
                }
                finally {
                    latch.countDown();
                }
            }
        }).start();
    }
}

