/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Type;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.spanner.v1.TypeCode;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypeTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void bool() {
        new ScalarTypeTester(Type.Code.BOOL, TypeCode.BOOL){

            @Override
            Type newType() {
                return Type.bool();
            }
        }.test();
    }

    @Test
    public void int64() {
        new ScalarTypeTester(Type.Code.INT64, TypeCode.INT64){

            @Override
            Type newType() {
                return Type.int64();
            }
        }.test();
    }

    @Test
    public void float64() {
        new ScalarTypeTester(Type.Code.FLOAT64, TypeCode.FLOAT64){

            @Override
            Type newType() {
                return Type.float64();
            }
        }.test();
    }

    @Test
    public void string() {
        new ScalarTypeTester(Type.Code.STRING, TypeCode.STRING){

            @Override
            Type newType() {
                return Type.string();
            }
        }.test();
    }

    @Test
    public void bytes() {
        new ScalarTypeTester(Type.Code.BYTES, TypeCode.BYTES){

            @Override
            Type newType() {
                return Type.bytes();
            }
        }.test();
    }

    @Test
    public void timestamp() {
        new ScalarTypeTester(Type.Code.TIMESTAMP, TypeCode.TIMESTAMP){

            @Override
            Type newType() {
                return Type.timestamp();
            }
        }.test();
    }

    @Test
    public void date() {
        new ScalarTypeTester(Type.Code.DATE, TypeCode.DATE){

            @Override
            Type newType() {
                return Type.date();
            }
        }.test();
    }

    @Test
    public void boolArray() {
        new ArrayTypeTester(Type.Code.BOOL, TypeCode.BOOL, true){

            @Override
            Type newElementType() {
                return Type.bool();
            }
        }.test();
    }

    @Test
    public void int64Array() {
        new ArrayTypeTester(Type.Code.INT64, TypeCode.INT64, true){

            @Override
            Type newElementType() {
                return Type.int64();
            }
        }.test();
    }

    @Test
    public void float64Array() {
        new ArrayTypeTester(Type.Code.FLOAT64, TypeCode.FLOAT64, true){

            @Override
            Type newElementType() {
                return Type.float64();
            }
        }.test();
    }

    @Test
    public void stringArray() {
        new ArrayTypeTester(Type.Code.STRING, TypeCode.STRING, true){

            @Override
            Type newElementType() {
                return Type.string();
            }
        }.test();
    }

    @Test
    public void bytesArray() {
        new ArrayTypeTester(Type.Code.BYTES, TypeCode.BYTES, true){

            @Override
            Type newElementType() {
                return Type.bytes();
            }
        }.test();
    }

    @Test
    public void timestampArray() {
        new ArrayTypeTester(Type.Code.TIMESTAMP, TypeCode.TIMESTAMP, true){

            @Override
            Type newElementType() {
                return Type.timestamp();
            }
        }.test();
    }

    @Test
    public void dateArray() {
        new ArrayTypeTester(Type.Code.DATE, TypeCode.DATE, true){

            @Override
            Type newElementType() {
                return Type.date();
            }
        }.test();
    }

    @Test
    public void arrayOfArray() {
        new ArrayTypeTester(Type.Code.ARRAY, TypeCode.ARRAY, false){

            @Override
            Type newElementType() {
                return Type.array((Type)Type.int64());
            }
        }.test();
    }

    @Test
    public void struct() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64()), Type.StructField.of((String)"f2", (Type)Type.string())});
        Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)Type.Code.STRUCT);
        Truth.assertThat((Iterable)t.getStructFields()).containsExactly(new Object[]{Type.StructField.of((String)"f1", (Type)Type.int64()), Type.StructField.of((String)"f2", (Type)Type.string())}).inOrder();
        Truth.assertThat((String)((Type.StructField)t.getStructFields().get(0)).getName()).isEqualTo((Object)"f1");
        Truth.assertThat((Object)((Type.StructField)t.getStructFields().get(0)).getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((String)((Type.StructField)t.getStructFields().get(1)).getName()).isEqualTo((Object)"f2");
        Truth.assertThat((Object)((Type.StructField)t.getStructFields().get(1)).getType()).isEqualTo((Object)Type.string());
        Truth.assertThat((String)t.toString()).isEqualTo((Object)"STRUCT<f1 INT64, f2 STRING>");
        Truth.assertThat((Integer)t.getFieldIndex("f1")).isEqualTo((Object)0);
        Truth.assertThat((Integer)t.getFieldIndex("f2")).isEqualTo((Object)1);
        TypeTest.assertProtoEquals(t.toProto(), "code: STRUCT struct_type { fields { name: 'f1' type { code: INT64 } } fields { name: 'f2' type { code: STRING } } }");
    }

    @Test
    public void emptyStruct() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[0]);
        Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)Type.Code.STRUCT);
        Truth.assertThat((Iterable)t.getStructFields()).isEmpty();
        Truth.assertThat((String)t.toString()).isEqualTo((Object)"STRUCT<>");
        TypeTest.assertProtoEquals(t.toProto(), "code: STRUCT struct_type {}");
    }

    @Test
    public void structFieldIndexNotFound() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64())});
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Field not found: f2");
        t.getFieldIndex("f2");
    }

    @Test
    public void structFieldIndexAmbiguous() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64()), Type.StructField.of((String)"f1", (Type)Type.string())});
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Ambiguous field name: f1");
        t.getFieldIndex("f1");
    }

    @Test
    public void parseErrorMissingTypeCode() {
        com.google.spanner.v1.Type proto = com.google.spanner.v1.Type.newBuilder().build();
        this.expectedException.expect(IllegalArgumentException.class);
        Type.fromProto((com.google.spanner.v1.Type)proto);
    }

    @Test
    public void parseErrorMissingArrayElementTypeProto() {
        com.google.spanner.v1.Type proto = com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.ARRAY).build();
        this.expectedException.expect(IllegalArgumentException.class);
        Type.fromProto((com.google.spanner.v1.Type)proto);
    }

    private static void assertProtoEquals(com.google.spanner.v1.Type proto, String expected) {
        MatcherAssert.assertThat((Object)proto, SpannerMatchers.matchesProto(com.google.spanner.v1.Type.class, expected));
    }

    static abstract class ArrayTypeTester {
        final Type.Code expectedElementCode;
        final TypeCode expectedElementProtoCode;
        final boolean expectInterned;

        protected ArrayTypeTester(Type.Code expectedElementCode, TypeCode expectedElementProtoCode, boolean expectInterned) {
            this.expectedElementCode = expectedElementCode;
            this.expectedElementProtoCode = expectedElementProtoCode;
            this.expectInterned = expectInterned;
        }

        abstract Type newElementType();

        void test() {
            Type elementType = this.newElementType();
            Type t = Type.array((Type)elementType);
            Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)Type.Code.ARRAY);
            Truth.assertThat((Object)t.getArrayElementType()).isEqualTo((Object)elementType);
            if (this.expectInterned) {
                Truth.assertThat((Object)Type.array((Type)this.newElementType())).isSameAs((Object)t);
            }
            Truth.assertThat((String)t.toString()).isEqualTo((Object)("ARRAY<" + elementType.toString() + ">"));
            com.google.spanner.v1.Type proto = t.toProto();
            Truth.assertThat((Comparable)proto.getCode()).isEqualTo((Object)TypeCode.ARRAY);
            Truth.assertThat((Object)proto.getArrayElementType()).isEqualTo((Object)elementType.toProto());
            Truth.assertThat((Boolean)proto.hasStructType()).isFalse();
            Type fromProto = Type.fromProto((com.google.spanner.v1.Type)proto);
            Truth.assertThat((Object)fromProto).isEqualTo((Object)t);
            if (this.expectInterned) {
                Truth.assertThat((Object)fromProto).isSameAs((Object)t);
            }
            SerializableTester.reserializeAndAssert((Object)t);
        }
    }

    private static abstract class ScalarTypeTester {
        final Type.Code expectedCode;
        final TypeCode expectedProtoCode;

        ScalarTypeTester(Type.Code expectedCode, TypeCode expectedProtoCode) {
            this.expectedCode = expectedCode;
            this.expectedProtoCode = expectedProtoCode;
        }

        abstract Type newType();

        void test() {
            Type t = this.newType();
            Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)this.expectedCode);
            Truth.assertThat((Object)this.newType()).isSameAs((Object)t);
            Truth.assertThat((String)t.toString()).isEqualTo((Object)this.expectedProtoCode.toString());
            com.google.spanner.v1.Type proto = t.toProto();
            Truth.assertThat((Comparable)proto.getCode()).isEqualTo((Object)this.expectedProtoCode);
            Truth.assertThat((Boolean)proto.hasArrayElementType()).isFalse();
            Truth.assertThat((Boolean)proto.hasStructType()).isFalse();
            Type fromProto = Type.fromProto((com.google.spanner.v1.Type)proto);
            Truth.assertThat((Object)fromProto).isEqualTo((Object)t);
            Truth.assertThat((Object)fromProto).isSameAs((Object)t);
            SerializableTester.reserializeAndAssert((Object)t);
        }
    }
}

