/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.instance.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminClient;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminSettings;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdmin;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.ProjectName;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstanceAdminClientTest {
    private static MockInstanceAdmin mockInstanceAdmin;
    private static MockServiceHelper serviceHelper;
    private InstanceAdminClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockInstanceAdmin = new MockInstanceAdmin();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockInstanceAdmin));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        InstanceAdminSettings settings = ((InstanceAdminSettings.Builder)((InstanceAdminSettings.Builder)InstanceAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = InstanceAdminClient.create((InstanceAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listInstanceConfigsTest() {
        String nextPageToken = "";
        InstanceConfig instanceConfigsElement = InstanceConfig.newBuilder().build();
        List<InstanceConfig> instanceConfigs = Arrays.asList(instanceConfigsElement);
        ListInstanceConfigsResponse expectedResponse = ListInstanceConfigsResponse.newBuilder().setNextPageToken(nextPageToken).addAllInstanceConfigs(instanceConfigs).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstanceConfigsPagedResponse pagedListResponse = this.client.listInstanceConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstanceConfigsList().get(0), resources.get(0));
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstanceConfigsRequest actualRequest = (ListInstanceConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstanceConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstanceConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceConfigTest() {
        InstanceConfigName name2 = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        String displayName = "displayName1615086568";
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(name2.toString()).setDisplayName(displayName).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        InstanceConfig actualResponse = this.client.getInstanceConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceConfigRequest actualRequest = (GetInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)InstanceConfigName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
            this.client.getInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest() {
        String nextPageToken = "";
        Instance instancesElement = Instance.newBuilder().build();
        List<Instance> instances = Arrays.asList(instancesElement);
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken(nextPageToken).addAllInstances(instances).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() {
        InstanceName name2 = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceConfigName config = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        Instance expectedResponse = Instance.newBuilder().setName(name2.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)InstanceName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest() throws Exception {
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceConfigName config = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        Instance expectedResponse = Instance.newBuilder().setName(name.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceName instanceId = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Instance instance = Instance.newBuilder().build();
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instanceId, instance).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)instanceId, (Object)InstanceName.parse((String)actualRequest.getInstanceId()));
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            InstanceName instanceId = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            Instance instance = Instance.newBuilder().build();
            this.client.createInstanceAsync(parent, instanceId, instance).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateInstanceTest() throws Exception {
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceConfigName config = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        Instance expectedResponse = Instance.newBuilder().setName(name.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)resultOperation);
        Instance instance = Instance.newBuilder().build();
        FieldMask fieldMask = FieldMask.newBuilder().build();
        Instance actualResponse = (Instance)this.client.updateInstanceAsync(instance, fieldMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateInstanceRequest actualRequest = (UpdateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals((Object)fieldMask, (Object)actualRequest.getFieldMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            Instance instance = Instance.newBuilder().build();
            FieldMask fieldMask = FieldMask.newBuilder().build();
            this.client.updateInstanceAsync(instance, fieldMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstanceTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        this.client.deleteInstance(name);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)InstanceName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        String formattedResource = InstanceName.format((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(formattedResource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String formattedResource = InstanceName.format((String)"[PROJECT]", (String)"[INSTANCE]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(formattedResource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        String formattedResource = InstanceName.format((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy actualResponse = this.client.getIamPolicy(formattedResource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String formattedResource = InstanceName.format((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.getIamPolicy(formattedResource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().build();
        mockInstanceAdmin.addResponse((GeneratedMessageV3)expectedResponse);
        String formattedResource = InstanceName.format((String)"[PROJECT]", (String)"[INSTANCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(formattedResource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String formattedResource = InstanceName.format((String)"[PROJECT]", (String)"[INSTANCE]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(formattedResource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

