/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDatabaseAdminTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DatabaseAdminClient dbAdminClient;
    private RemoteSpannerHelper testHelper;
    private List<Database> dbs = new ArrayList<Database>();

    @Before
    public void setUp() throws Exception {
        this.testHelper = env.getTestHelper();
        this.dbAdminClient = this.testHelper.getClient().getDatabaseAdminClient();
    }

    @After
    public void tearDown() throws Exception {
        for (Database db : this.dbs) {
            db.drop();
        }
        this.dbs.clear();
    }

    @Test
    public void databaseOperations() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get();
        this.dbs.add(db);
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        db = this.dbAdminClient.getDatabase(instanceId, dbId);
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        boolean foundDb = false;
        for (Database dbInList : (Database[])Iterators.toArray(this.dbAdminClient.listDatabases(instanceId, new Options.ListOption[0]).iterateAll().iterator(), Database.class)) {
            if (!dbInList.getId().getDatabase().equals(dbId)) continue;
            foundDb = true;
            break;
        }
        Truth.assertThat((Boolean)foundDb).isTrue();
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op2 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), null);
        op2.get();
        List statementsInDb = this.dbAdminClient.getDatabaseDdl(instanceId, dbId);
        Truth.assertThat((Iterable)statementsInDb).containsExactly(new Object[]{statement1, statement2});
        this.dbAdminClient.dropDatabase(instanceId, dbId);
        this.dbs.clear();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        db = this.dbAdminClient.getDatabase(this.testHelper.getInstanceId().getInstance(), dbId);
    }

    @Test
    public void updateDdlRetry() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get();
        this.dbs.add(db);
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op1 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), "myop");
        OperationFuture op2 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), "myop");
        op1.get();
        op2.get();
        Truth.assertThat((Object)op1.getMetadata().get()).isEqualTo(op2.getMetadata().get());
    }

    @Test
    public void databaseOperationsViaEntity() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get();
        this.dbs.add(db);
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        db = db.reload();
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op2 = db.updateDdl((Iterable)ImmutableList.of((Object)statement2), null);
        op2.get();
        Iterable statementsInDb = db.getDdl();
        Truth.assertThat((Iterable)statementsInDb).containsExactly(new Object[]{statement1, statement2});
        db.drop();
        this.dbs.clear();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        db.reload();
    }

    @Test
    public void listPagination() throws Exception {
        ImmutableList dbIds = ImmutableList.of((Object)this.testHelper.getUniqueDatabaseId(), (Object)this.testHelper.getUniqueDatabaseId(), (Object)this.testHelper.getUniqueDatabaseId());
        String instanceId = this.testHelper.getInstanceId().getInstance();
        for (String dbId : dbIds) {
            this.dbs.add((Database)this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of()).get());
        }
        ArrayList<String> dbIdsGot = new ArrayList<String>();
        for (Page page = this.dbAdminClient.listDatabases(instanceId, new Options.ListOption[]{Options.pageSize((int)1)}); page != null; page = page.getNextPage()) {
            Database db = (Database)Iterables.getOnlyElement((Iterable)page.getValues());
            dbIdsGot.add(db.getId().getDatabase());
        }
        Truth.assertThat(dbIdsGot).containsAllIn((Iterable)dbIds);
    }
}

