/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITReadOnlyTxnTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME = "TestTable";
    private static DatabaseClient sharedClient;
    private static List<History> sharedHistory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private List<History> history;
    private DatabaseClient client;

    @BeforeClass
    public static void setUpSharedDatabase() {
        ImmutableList.Builder historyBuilder = ImmutableList.builder();
        sharedClient = ITReadOnlyTxnTest.newTestDatabase((ImmutableList.Builder<History>)historyBuilder);
        sharedHistory = historyBuilder.build();
    }

    private static DatabaseClient newTestDatabase(ImmutableList.Builder<History> historyBuilder) {
        Database newDb = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable ( StringValue STRING(MAX) ) PRIMARY KEY ()"});
        DatabaseClient newClient = env.getTestHelper().getDatabaseClient(newDb);
        for (int i = 0; i < 5; ++i) {
            ITReadOnlyTxnTest.writeNewValue(newClient, i, historyBuilder);
        }
        return newClient;
    }

    private static void writeNewValue(DatabaseClient client, int i, @Nullable ImmutableList.Builder<History> historyBuilder) {
        String value = "v" + i;
        Mutation m = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("StringValue").to(value)).build();
        long minCommitNanoTime = System.nanoTime();
        Timestamp timestamp = client.writeAtLeastOnce(Arrays.asList(m));
        if (historyBuilder != null) {
            historyBuilder.add((Object)new History(timestamp, value, minCommitNanoTime));
        }
    }

    @Before
    public void setUp() {
        this.history = sharedHistory;
        this.client = sharedClient;
    }

    private static Struct readRow(ReadContext ctx) {
        return ctx.readRow(TABLE_NAME, Key.of((Object[])new Object[0]), Arrays.asList("StringValue"));
    }

    private static Struct queryRow(ReadContext ctx) {
        ResultSet resultSet = Statement.of((String)"SELECT StringValue FROM TestTable").executeQuery(ctx, new Options.QueryOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Struct row = resultSet.getCurrentRowAsStruct();
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        return row;
    }

    @Test
    public void singleStrong() {
        History expected = this.history.get(this.history.size() - 1);
        ReadOnlyTransaction readContext = this.client.singleUseReadOnlyTransaction();
        Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
        Truth.assertThat((Comparable)readContext.getReadTimestamp()).isAtLeast((Comparable)expected.timestamp);
        row = ITReadOnlyTxnTest.readRow(this.client.singleUse());
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
    }

    @Test
    public void singleReadTimestamp() {
        History expected = this.history.get(2);
        TimestampBound bound = TimestampBound.ofReadTimestamp((Timestamp)expected.timestamp);
        ReadOnlyTransaction readContext = this.client.singleUseReadOnlyTransaction(bound);
        Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
        Truth.assertThat((Comparable)readContext.getReadTimestamp()).isEqualTo((Object)expected.timestamp);
        row = ITReadOnlyTxnTest.readRow(this.client.singleUse(bound));
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
    }

    @Test
    public void query() {
        History expected = this.history.get(2);
        TimestampBound bound = TimestampBound.ofReadTimestamp((Timestamp)expected.timestamp);
        ReadOnlyTransaction readContext = this.client.singleUseReadOnlyTransaction(bound);
        Struct row = ITReadOnlyTxnTest.queryRow((ReadContext)readContext);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
        Truth.assertThat((Comparable)readContext.getReadTimestamp()).isEqualTo((Object)expected.timestamp);
        readContext = this.client.readOnlyTransaction(bound);
        row = ITReadOnlyTxnTest.queryRow((ReadContext)readContext);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
        Truth.assertThat((Comparable)readContext.getReadTimestamp()).isEqualTo((Object)expected.timestamp);
        readContext.close();
        row = ITReadOnlyTxnTest.queryRow(this.client.singleUse(bound));
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
    }

    @Test
    public void singleMinReadTimestamp() {
        int minimumIndex = 2;
        History minimum = this.history.get(minimumIndex);
        TreeMap<Timestamp, String> possibleValues = new TreeMap<Timestamp, String>();
        for (History item : this.history.subList(minimumIndex, this.history.size())) {
            possibleValues.put(item.timestamp, item.value);
        }
        TimestampBound bound = TimestampBound.ofMinReadTimestamp((Timestamp)minimum.timestamp);
        ReadOnlyTransaction readContext = this.client.singleUseReadOnlyTransaction(bound);
        Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((Comparable)readContext.getReadTimestamp()).isAtLeast((Comparable)minimum.timestamp);
        Truth.assertThat((String)row.getString(0)).isEqualTo(possibleValues.floorEntry(readContext.getReadTimestamp()).getValue());
        row = ITReadOnlyTxnTest.readRow(this.client.singleUse(bound));
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isIn(possibleValues.values());
    }

    @Test
    public void singleExactStaleness() {
        long deadlineNanoTime = System.nanoTime() + TimeUnit.MINUTES.toNanos(1L);
        long stalenessNanos = 1L + deadlineNanoTime - this.history.get(0).minCommitNanoTime;
        TimestampBound bound = TimestampBound.ofExactStaleness((long)stalenessNanos, (TimeUnit)TimeUnit.NANOSECONDS);
        ReadOnlyTransaction readContext = this.client.singleUseReadOnlyTransaction(bound);
        Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
        Truth.assertThat((Object)row).isNull();
        Truth.assertThat((Comparable)readContext.getReadTimestamp().toSqlTimestamp()).isLessThan((Comparable)this.history.get(0).timestamp.toSqlTimestamp());
        row = ITReadOnlyTxnTest.readRow(this.client.singleUse(bound));
        Truth.assertThat((Object)row).isNull();
    }

    @Test
    public void singleMaxStaleness() {
        History minimum = this.history.get(2);
        TreeMap<Timestamp, String> possibleValues = new TreeMap<Timestamp, String>();
        for (History item : this.history.subList(2, this.history.size())) {
            possibleValues.put(item.timestamp, item.value);
        }
        long stalenessNanos = System.nanoTime() - this.history.get(3).minCommitNanoTime;
        TimestampBound bound = TimestampBound.ofMaxStaleness((long)stalenessNanos, (TimeUnit)TimeUnit.NANOSECONDS);
        ReadOnlyTransaction readContext = this.client.singleUseReadOnlyTransaction(bound);
        Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((Comparable)readContext.getReadTimestamp()).isAtLeast((Comparable)minimum.timestamp);
        Truth.assertThat((String)row.getString(0)).isEqualTo(possibleValues.floorEntry(readContext.getReadTimestamp()).getValue());
        row = ITReadOnlyTxnTest.readRow(this.client.singleUse(bound));
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isIn(possibleValues.values());
    }

    private void setUpPrivateDatabase() {
        ImmutableList.Builder historyBuilder = ImmutableList.builder();
        this.client = ITReadOnlyTxnTest.newTestDatabase((ImmutableList.Builder<History>)historyBuilder);
        this.history = historyBuilder.build();
    }

    private void insertAndReadAgain(ReadOnlyTransaction readContext, Timestamp expectedTimestamp, @Nullable String expectedValue) {
        ITReadOnlyTxnTest.writeNewValue(this.client, this.history.size(), null);
        Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
        if (expectedValue == null) {
            Truth.assertThat((Object)row).isNull();
        } else {
            Truth.assertThat((Object)row).isNotNull();
            Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expectedValue);
        }
        Truth.assertThat((Comparable)readContext.getReadTimestamp()).isEqualTo((Object)expectedTimestamp);
    }

    @Test
    public void multiStrong() {
        this.setUpPrivateDatabase();
        History expected = this.history.get(this.history.size() - 1);
        try (ReadOnlyTransaction readContext = this.client.readOnlyTransaction();){
            Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
            Truth.assertThat((Object)row).isNotNull();
            Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
            Truth.assertThat((Comparable)readContext.getReadTimestamp()).isAtLeast((Comparable)expected.timestamp);
            this.insertAndReadAgain(readContext, readContext.getReadTimestamp(), expected.value);
        }
    }

    @Test
    public void multiReadTimestamp() {
        this.setUpPrivateDatabase();
        History expected = this.history.get(2);
        try (ReadOnlyTransaction readContext = this.client.readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)expected.timestamp));){
            Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
            Truth.assertThat((Object)row).isNotNull();
            Truth.assertThat((String)row.getString(0)).isEqualTo((Object)expected.value);
            Truth.assertThat((Comparable)readContext.getReadTimestamp()).isEqualTo((Object)expected.timestamp);
            this.insertAndReadAgain(readContext, readContext.getReadTimestamp(), expected.value);
        }
    }

    @Test
    public void multiMinReadTimestamp() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.client.readOnlyTransaction(TimestampBound.ofMinReadTimestamp((Timestamp)this.history.get(2).timestamp));
    }

    @Test
    public void multiExactStaleness() {
        this.setUpPrivateDatabase();
        long deadlineNanoTime = System.nanoTime() + TimeUnit.MINUTES.toNanos(1L);
        long stalenessNanos = 1L + deadlineNanoTime - this.history.get(0).minCommitNanoTime;
        try (ReadOnlyTransaction readContext = this.client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)stalenessNanos, (TimeUnit)TimeUnit.NANOSECONDS));){
            Struct row = ITReadOnlyTxnTest.readRow((ReadContext)readContext);
            Truth.assertThat((Object)row).isNull();
            Truth.assertThat((Comparable)readContext.getReadTimestamp().toSqlTimestamp()).isLessThan((Comparable)this.history.get(0).timestamp.toSqlTimestamp());
            this.insertAndReadAgain(readContext, readContext.getReadTimestamp(), null);
        }
    }

    @Test
    public void multiMaxStaleness() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.client.readOnlyTransaction(TimestampBound.ofMaxStaleness((long)1L, (TimeUnit)TimeUnit.SECONDS));
    }

    private static class History {
        private final Timestamp timestamp;
        private final String value;
        private final long minCommitNanoTime;

        private History(Timestamp timestamp, String value, long minCommitNanoTime) {
            this.timestamp = timestamp;
            this.value = value;
            this.minCommitNanoTime = minCommitNanoTime;
        }
    }
}

