/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DatabaseClientImplTest {
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static Spanner spanner;
    private static final Statement UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).directExecutor()).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() {
        server.shutdown();
    }

    @Before
    public void setUp() throws IOException {
        mockSpanner.reset();
        spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
    }

    @After
    public void tearDown() throws Exception {
        spanner.close();
    }

    @Test
    public void testExecutePartitionedDml() {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT);
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    }
}

