/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;

public class IntegrationTestWithClosedSessionsEnv
extends IntegrationTestEnv {
    @Override
    RemoteSpannerHelper createTestHelper(SpannerOptions options, InstanceId instanceId) throws Throwable {
        SpannerWithClosedSessionsImpl spanner = new SpannerWithClosedSessionsImpl(options);
        return new RemoteSpannerHelperWithClosedSessions(options, instanceId, (Spanner)spanner);
    }

    public static class DatabaseClientWithClosedSessionImpl
    extends DatabaseClientImpl {
        private boolean invalidateNextSession = false;
        private boolean allowReplacing = true;

        DatabaseClientWithClosedSessionImpl(SessionPool pool) {
            super(pool);
        }

        public void invalidateNextSession() {
            this.invalidateNextSession = true;
        }

        public void setAllowSessionReplacing(boolean allow) {
            this.allowReplacing = allow;
        }

        SessionPool.PooledSession getReadSession() {
            SessionPool.PooledSession session = super.getReadSession();
            if (this.invalidateNextSession) {
                session.delegate.close();
                session.setAllowReplacing(false);
                this.awaitDeleted((Session)session.delegate);
                session.setAllowReplacing(this.allowReplacing);
                this.invalidateNextSession = false;
            }
            session.setAllowReplacing(this.allowReplacing);
            return session;
        }

        SessionPool.PooledSession getReadWriteSession() {
            SessionPool.PooledSession session = super.getReadWriteSession();
            if (this.invalidateNextSession) {
                session.delegate.close();
                session.setAllowReplacing(false);
                this.awaitDeleted((Session)session.delegate);
                session.setAllowReplacing(this.allowReplacing);
                this.invalidateNextSession = false;
            }
            session.setAllowReplacing(this.allowReplacing);
            return session;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void awaitDeleted(Session session) {
            try {
                while (true) {
                    ResultSet rs;
                    block14: {
                        rs = session.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                        Throwable throwable = null;
                        try {
                            while (rs.next()) {
                            }
                            Thread.sleep(500L);
                            if (rs == null) continue;
                            if (throwable == null) break block14;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs == null) throw throwable3;
                                if (throwable == null) {
                                    rs.close();
                                    throw throwable3;
                                }
                                try {
                                    rs.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (SpannerException e) {
                if (e.getErrorCode() != ErrorCode.NOT_FOUND) throw e;
                if (!e.getMessage().contains("Session not found")) throw e;
                return;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static class SpannerWithClosedSessionsImpl
    extends SpannerImpl {
        SpannerWithClosedSessionsImpl(SpannerOptions options) {
            super(options);
        }

        DatabaseClientImpl createDatabaseClient(SessionPool pool) {
            return new DatabaseClientWithClosedSessionImpl(pool);
        }
    }

    private static class RemoteSpannerHelperWithClosedSessions
    extends RemoteSpannerHelper {
        private RemoteSpannerHelperWithClosedSessions(SpannerOptions options, InstanceId instanceId, Spanner client) {
            super(options, instanceId, client);
        }
    }
}

