/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.PartitionOptions;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PartitionOptionsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void builder() {
        long desiredBytesPerBatch = 0x40000000L;
        long maxPartitionCount = 100L;
        PartitionOptions parameters = PartitionOptions.newBuilder().setPartitionSizeBytes(desiredBytesPerBatch).setMaxPartitions(maxPartitionCount).build();
        Truth.assertThat((Long)parameters.getPartitionSizeBytes()).isEqualTo((Object)desiredBytesPerBatch);
        Truth.assertThat((Long)parameters.getMaxPartitions()).isEqualTo((Object)maxPartitionCount);
        SerializableTester.reserializeAndAssert((Object)parameters);
    }

    @Test
    public void emptyBuilder() {
        PartitionOptions parameters = PartitionOptions.newBuilder().build();
        Truth.assertThat((Long)parameters.getPartitionSizeBytes()).isEqualTo((Object)0);
        Truth.assertThat((Long)parameters.getMaxPartitions()).isEqualTo((Object)0);
        SerializableTester.reserializeAndAssert((Object)parameters);
    }

    @Test
    public void defaultBuilder() {
        PartitionOptions parameters = PartitionOptions.getDefaultInstance();
        Truth.assertThat((Long)parameters.getPartitionSizeBytes()).isEqualTo((Object)0);
        Truth.assertThat((Long)parameters.getMaxPartitions()).isEqualTo((Object)0);
        SerializableTester.reserializeAndAssert((Object)parameters);
    }

    @Test
    public void equalAndHashCode() {
        new EqualsTester().addEqualityGroup(new Object[]{PartitionOptions.newBuilder().setPartitionSizeBytes(0x40000000L).setMaxPartitions(100L).build(), PartitionOptions.newBuilder().setPartitionSizeBytes(0x40000000L).setMaxPartitions(100L).build()}).addEqualityGroup(new Object[]{PartitionOptions.newBuilder().build(), PartitionOptions.getDefaultInstance()}).testEquals();
    }

    @Test
    public void invalidDesiredBytesPerBatch() {
        this.expectedException.expect(IllegalArgumentException.class);
        PartitionOptions.newBuilder().setPartitionSizeBytes(-1L).build();
    }

    @Test
    public void invalidMaxPartitionCount() {
        this.expectedException.expect(IllegalArgumentException.class);
        PartitionOptions.newBuilder().setMaxPartitions(-1L).build();
    }
}

