/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResultSetsTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void resultSetIteration() {
        double doubleVal = 1.2;
        String stringVal = "stringVal";
        String byteVal = "101";
        long usecs = 32343L;
        int year = 2018;
        int month = 5;
        int day = 26;
        boolean[] boolArray = new boolean[]{true, false, true, true, false};
        long[] longArray = new long[]{Long.MAX_VALUE, Long.MIN_VALUE, 0L, 1L, -1L};
        double[] doubleArray = new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 0.0, 1.0, -1.0, 1.2341};
        ByteArray[] byteArray = new ByteArray[]{ByteArray.copyFrom((String)"123"), ByteArray.copyFrom((String)"456"), ByteArray.copyFrom((String)"789")};
        Timestamp[] timestampArray = new Timestamp[]{Timestamp.ofTimeMicroseconds((long)101L), Timestamp.ofTimeMicroseconds((long)202L), Timestamp.ofTimeMicroseconds((long)303L)};
        Date[] dateArray = new Date[]{Date.fromYearMonthDay((int)1, (int)2, (int)3), Date.fromYearMonthDay((int)4, (int)5, (int)6), Date.fromYearMonthDay((int)7, (int)8, (int)9)};
        String[] stringArray = new String[]{"abc", "def", "ghi"};
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.int64()), Type.StructField.of((String)"f3", (Type)Type.bool()), Type.StructField.of((String)"doubleVal", (Type)Type.float64()), Type.StructField.of((String)"stringVal", (Type)Type.string()), Type.StructField.of((String)"byteVal", (Type)Type.bytes()), Type.StructField.of((String)"timestamp", (Type)Type.timestamp()), Type.StructField.of((String)"date", (Type)Type.date()), Type.StructField.of((String)"boolArray", (Type)Type.array((Type)Type.bool())), Type.StructField.of((String)"longArray", (Type)Type.array((Type)Type.int64())), Type.StructField.of((String)"doubleArray", (Type)Type.array((Type)Type.float64())), Type.StructField.of((String)"byteArray", (Type)Type.array((Type)Type.bytes())), Type.StructField.of((String)"timestampArray", (Type)Type.array((Type)Type.timestamp())), Type.StructField.of((String)"dateArray", (Type)Type.array((Type)Type.date())), Type.StructField.of((String)"stringArray", (Type)Type.array((Type)Type.string()))});
        Struct struct1 = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").to(2L)).set("f3").to(Value.bool((boolean)true))).set("doubleVal").to(Value.float64((double)doubleVal))).set("stringVal").to(stringVal)).set("byteVal").to(Value.bytes((ByteArray)ByteArray.copyFrom((String)byteVal)))).set("timestamp").to(Timestamp.ofTimeMicroseconds((long)usecs))).set("date").to(Date.fromYearMonthDay((int)year, (int)month, (int)day))).set("boolArray").to(Value.boolArray((boolean[])boolArray))).set("longArray").to(Value.int64Array((long[])longArray))).set("doubleArray").to(Value.float64Array((double[])doubleArray))).set("byteArray").to(Value.bytesArray(Arrays.asList(byteArray)))).set("timestampArray").to(Value.timestampArray(Arrays.asList(timestampArray)))).set("dateArray").to(Value.dateArray(Arrays.asList(dateArray)))).set("stringArray").to(Value.stringArray(Arrays.asList(stringArray)))).build();
        Struct struct2 = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("y")).set("f2").to(3L)).set("f3").to(Value.bool(null))).set("doubleVal").to(Value.float64((double)doubleVal))).set("stringVal").to(stringVal)).set("byteVal").to(Value.bytes((ByteArray)ByteArray.copyFrom((String)byteVal)))).set("timestamp").to(Timestamp.ofTimeMicroseconds((long)usecs))).set("date").to(Date.fromYearMonthDay((int)year, (int)month, (int)day))).set("boolArray").to(Value.boolArray((boolean[])boolArray))).set("longArray").to(Value.int64Array((long[])longArray))).set("doubleArray").to(Value.float64Array((double[])doubleArray))).set("byteArray").to(Value.bytesArray(Arrays.asList(byteArray)))).set("timestampArray").to(Value.timestampArray(Arrays.asList(timestampArray)))).set("dateArray").to(Value.dateArray(Arrays.asList(dateArray)))).set("stringArray").to(Value.stringArray(Arrays.asList(stringArray)))).build();
        ResultSet rs = ResultSets.forRows((Type)type, Arrays.asList(struct1, struct2));
        try {
            rs.getType();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Must be preceded by a next() call");
        }
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getType()).isEqualTo((Object)type);
        Truth.assertThat((Integer)rs.getColumnCount()).isEqualTo((Object)type.getStructFields().size());
        Truth.assertThat((Integer)rs.getColumnIndex("f1")).isEqualTo((Object)0);
        Truth.assertThat((Object)rs.getColumnType("nonexistent")).isNull();
        Truth.assertThat((Object)rs.getColumnType("f1")).isEqualTo((Object)Type.string());
        Truth.assertThat((Object)rs.getColumnType(0)).isEqualTo((Object)Type.string());
        Truth.assertThat((Integer)rs.getColumnIndex("f2")).isEqualTo((Object)1);
        Truth.assertThat((Object)rs.getColumnType("f2")).isEqualTo((Object)Type.int64());
        Truth.assertThat((Object)rs.getColumnType(1)).isEqualTo((Object)Type.int64());
        Truth.assertThat((Integer)rs.getColumnIndex("f3")).isEqualTo((Object)2);
        Truth.assertThat((Object)rs.getColumnType("f3")).isEqualTo((Object)Type.bool());
        Truth.assertThat((Object)rs.getColumnType(2)).isEqualTo((Object)Type.bool());
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct1);
        Truth.assertThat((String)rs.getString(0)).isEqualTo((Object)"x");
        Truth.assertThat((Long)rs.getLong(1)).isEqualTo((Object)2L);
        Truth.assertThat((Boolean)rs.getBoolean(2)).isTrue();
        Truth.assertThat((Boolean)rs.getBoolean("f3")).isTrue();
        Truth.assertThat((Double)rs.getDouble("doubleVal")).isWithin(0.0).of(doubleVal);
        Truth.assertThat((Double)rs.getDouble(3)).isWithin(0.0).of(doubleVal);
        Truth.assertThat((String)rs.getString(4)).isEqualTo((Object)stringVal);
        Truth.assertThat((String)rs.getString("stringVal")).isEqualTo((Object)stringVal);
        Truth.assertThat((Iterable)rs.getBytes(5)).isEqualTo((Object)ByteArray.copyFrom((String)byteVal));
        Truth.assertThat((Iterable)rs.getBytes("byteVal")).isEqualTo((Object)ByteArray.copyFrom((String)byteVal));
        Truth.assertThat((Comparable)rs.getTimestamp(6)).isEqualTo((Object)Timestamp.ofTimeMicroseconds((long)usecs));
        Truth.assertThat((Comparable)rs.getTimestamp("timestamp")).isEqualTo((Object)Timestamp.ofTimeMicroseconds((long)usecs));
        Truth.assertThat((Comparable)rs.getDate(7)).isEqualTo((Object)Date.fromYearMonthDay((int)year, (int)month, (int)day));
        Truth.assertThat((Comparable)rs.getDate("date")).isEqualTo((Object)Date.fromYearMonthDay((int)year, (int)month, (int)day));
        Truth.assertThat((boolean[])rs.getBooleanArray(8)).isEqualTo((Object)boolArray);
        Truth.assertThat((boolean[])rs.getBooleanArray("boolArray")).isEqualTo((Object)boolArray);
        Truth.assertThat((Iterable)rs.getBooleanList(8)).isEqualTo((Object)Booleans.asList((boolean[])boolArray));
        Truth.assertThat((Iterable)rs.getBooleanList("boolArray")).isEqualTo((Object)Booleans.asList((boolean[])boolArray));
        Truth.assertThat((long[])rs.getLongArray(9)).isEqualTo((Object)longArray);
        Truth.assertThat((long[])rs.getLongArray("longArray")).isEqualTo((Object)longArray);
        Truth.assertThat((Iterable)rs.getLongList(9)).isEqualTo((Object)Longs.asList((long[])longArray));
        Truth.assertThat((Iterable)rs.getLongList("longArray")).isEqualTo((Object)Longs.asList((long[])longArray));
        Truth.assertThat((double[])rs.getDoubleArray(10)).usingTolerance(0.0).containsAllOf(doubleArray);
        Truth.assertThat((double[])rs.getDoubleArray("doubleArray")).usingTolerance(0.0).containsExactly(doubleArray).inOrder();
        Truth.assertThat((Iterable)rs.getDoubleList(10)).isEqualTo((Object)Doubles.asList((double[])doubleArray));
        Truth.assertThat((Iterable)rs.getDoubleList("doubleArray")).isEqualTo((Object)Doubles.asList((double[])doubleArray));
        Truth.assertThat((Iterable)rs.getBytesList(11)).isEqualTo(Arrays.asList(byteArray));
        Truth.assertThat((Iterable)rs.getBytesList("byteArray")).isEqualTo(Arrays.asList(byteArray));
        Truth.assertThat((Iterable)rs.getTimestampList(12)).isEqualTo(Arrays.asList(timestampArray));
        Truth.assertThat((Iterable)rs.getTimestampList("timestampArray")).isEqualTo(Arrays.asList(timestampArray));
        Truth.assertThat((Iterable)rs.getDateList(13)).isEqualTo(Arrays.asList(dateArray));
        Truth.assertThat((Iterable)rs.getDateList("dateArray")).isEqualTo(Arrays.asList(dateArray));
        Truth.assertThat((Iterable)rs.getStringList(14)).isEqualTo(Arrays.asList(stringArray));
        Truth.assertThat((Iterable)rs.getStringList("stringArray")).isEqualTo(Arrays.asList(stringArray));
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct2);
        Truth.assertThat((String)rs.getString(0)).isEqualTo((Object)"y");
        Truth.assertThat((Long)rs.getLong(1)).isEqualTo((Object)3L);
        Truth.assertThat((Boolean)rs.isNull(2)).isTrue();
        Truth.assertThat((Boolean)rs.next()).isFalse();
        try {
            rs.getStats();
            Assert.fail((String)"Exception expected");
        }
        catch (UnsupportedOperationException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"ResultSetStats are available only for results returned from analyzeQuery");
        }
    }

    @Test
    public void resultSetIterationWithStructColumns() {
        Type nestedStructType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"g1", (Type)Type.string())});
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)nestedStructType), Type.StructField.of((String)"f2", (Type)Type.int64())});
        Struct value1 = ((Struct.Builder)Struct.newBuilder().set("g1").to("abc")).build();
        Struct struct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(value1)).set("f2").to((Long)null)).build();
        this.expected.expect(UnsupportedOperationException.class);
        this.expected.expectMessage("STRUCT-typed columns are not supported inside ResultSets.");
        ResultSets.forRows((Type)type, Arrays.asList(struct1));
    }

    @Test
    public void resultSetIterationWithArrayStructColumns() {
        Type nestedStructType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"g1", (Type)Type.string())});
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.array((Type)nestedStructType)), Type.StructField.of((String)"f2", (Type)Type.int64())});
        Struct value1 = ((Struct.Builder)Struct.newBuilder().set("g1").to("abc")).build();
        List<Struct> arrayValue = Arrays.asList(value1, null);
        Struct struct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").toStructArray(nestedStructType, arrayValue)).set("f2").to((Long)null)).build();
        Struct struct2 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").toStructArray(nestedStructType, null)).set("f2").to(20L)).build();
        ResultSet rs = ResultSets.forRows((Type)type, Arrays.asList(struct1, struct2));
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getType()).isEqualTo((Object)type);
        Truth.assertThat((Integer)rs.getColumnCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)rs.getColumnIndex("f1")).isEqualTo((Object)0);
        Truth.assertThat((Object)rs.getColumnType("f1")).isEqualTo((Object)Type.array((Type)nestedStructType));
        Truth.assertThat((Object)rs.getColumnType(0)).isEqualTo((Object)Type.array((Type)nestedStructType));
        Truth.assertThat((Integer)rs.getColumnIndex("f2")).isEqualTo((Object)1);
        Truth.assertThat((Object)rs.getColumnType("f2")).isEqualTo((Object)Type.int64());
        Truth.assertThat((Object)rs.getColumnType(1)).isEqualTo((Object)Type.int64());
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct1);
        Truth.assertThat((Iterable)rs.getStructList(0)).isEqualTo(arrayValue);
        Truth.assertThat((Iterable)rs.getStructList("f1")).isEqualTo(arrayValue);
        Truth.assertThat((Boolean)rs.isNull(1)).isTrue();
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((Object)rs.getCurrentRowAsStruct()).isEqualTo((Object)struct2);
        Truth.assertThat((Boolean)rs.isNull(0)).isTrue();
        Truth.assertThat((Boolean)rs.isNull("f1")).isTrue();
        Truth.assertThat((Long)rs.getLong(1)).isEqualTo((Object)20);
        Truth.assertThat((Long)rs.getLong("f2")).isEqualTo((Object)20);
        Truth.assertThat((Boolean)rs.next()).isFalse();
    }

    @Test
    public void closeResultSet() {
        ResultSet rs = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string())}), Arrays.asList(((Struct.Builder)Struct.newBuilder().set("f1").to("x")).build()));
        rs.close();
        this.expected.expect(IllegalStateException.class);
        rs.getCurrentRowAsStruct();
    }

    @Test
    public void exceptionIfNextIsNotCalled() {
        ResultSet rs = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string())}), Arrays.asList(((Struct.Builder)Struct.newBuilder().set("f1").to("x")).build()));
        this.expected.expect(IllegalStateException.class);
        rs.getCurrentRowAsStruct();
    }
}

