/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RetryOnInvalidatedSessionTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public boolean failOnInvalidatedSession;
    private static final ResultSetMetadata READ_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("BAR").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet READ_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(READ_METADATA).build();
    private static final com.google.spanner.v1.ResultSet READ_ROW_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(READ_METADATA).build();
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final long UPDATE_COUNT = 1L;
    private static final int MAX_SESSIONS = 10;
    private static final float WRITE_SESSIONS_FRACTION = 0.5f;
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static SpannerClient spannerClient;
    private static Spanner spanner;
    private static DatabaseClient client;

    @Parameterized.Parameters(name="fail on invalidated session = {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{false});
        params.add(new Object[]{true});
        return params;
    }

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.all(), Arrays.asList("BAR"), READ_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.singleKey((Key)Key.of((Object[])new Object[0])), Arrays.asList("BAR"), READ_ROW_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).directExecutor()).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        spannerClient = SpannerClient.create((SpannerSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        spannerClient.close();
        server.shutdown();
    }

    @Before
    public void setUp() throws IOException {
        mockSpanner.reset();
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder().setMaxSessions(10).setWriteSessionsFraction(0.5f);
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
        client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
    }

    @After
    public void tearDown() throws Exception {
        spanner.close();
    }

    private static void initReadOnlySessionPool() {
        try (ReadContext context = client.singleUse();
             ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    private static void initReadWriteSessionPool() throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            service.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try (ReadContext context = client.singleUse();
                         ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            Thread.sleep(20L);
                        }
                    }
                    return null;
                }
            });
        }
        service.shutdown();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        Stopwatch watch = Stopwatch.createStarted();
        while (((DatabaseClientImpl)RetryOnInvalidatedSessionTest.client).pool.getNumberOfAvailableWritePreparedSessions() == 0) {
            if (watch.elapsed(TimeUnit.MILLISECONDS) > 1000L) {
                Assert.fail((String)"No read/write sessions prepared");
            }
            Thread.sleep(5L);
        }
    }

    private static void invalidateSessionPool() throws InterruptedException {
        SpannerClient.ListSessionsPagedResponse response = spannerClient.listSessions("projects/[PROJECT]/instances/[INSTANCE]/databases/[DATABASE]");
        for (Session session : response.iterateAll()) {
            spannerClient.deleteSession(session.getName());
        }
    }

    @Test
    public void singleUseSelect() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadContext context = client.singleUse();
             ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
                ++count;
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void singleUseRead() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadContext context = client.singleUse();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        }
    }

    @Test
    public void singleUseReadUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadContext context = client.singleUse();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        }
    }

    @Test
    public void singleUseReadRow() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadContext context = client.singleUse();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    @Test
    public void singleUseReadRowUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadContext context = client.singleUse();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    @Test
    public void singleUseReadOnlyTransactionSelect() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();
             ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
                ++count;
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void singleUseReadOnlyTransactionRead() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        }
    }

    @Test
    public void singlUseReadOnlyTransactionReadUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        }
    }

    @Test
    public void singleUseReadOnlyTransactionReadRow() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    @Test
    public void singleUseReadOnlyTransactionReadRowUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    @Test
    public void readOnlyTransactionSelect() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        }
    }

    @Test
    public void readOnlyTransactionRead() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        }
    }

    @Test
    public void readOnlyTransactionReadUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        }
    }

    @Test
    public void readOnlyTransactionReadRow() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    @Test
    public void readOnlyTransactionReadRowUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionSelectNonRecoverable() throws InterruptedException {
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
            var5_7 = null;
            try {
                while (rs.next()) {
                    ++count;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var5_7 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadNonRecoverable() throws InterruptedException {
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            var5_7 = null;
            try {
                while (rs.next()) {
                    ++count;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var5_7 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadUsingIndexNonRecoverable() throws InterruptedException {
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            var5_7 = null;
            try {
                while (rs.next()) {
                    ++count;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var5_7 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadRowNonRecoverable() throws InterruptedException {
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            Struct struct = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadRowUsingIndexNonRecoverable() throws InterruptedException {
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            Struct struct = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
        }
    }

    @Test
    public void readWriteTransactionReadOnlySessionInPool() throws InterruptedException {
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        int count = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){

            public Integer run(TransactionContext transaction) throws Exception {
                int count = 0;
                try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        ++count;
                    }
                }
                return count;
            }
        });
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionSelect() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        int count = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){

            public Integer run(TransactionContext transaction) throws Exception {
                int count = 0;
                try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        ++count;
                    }
                }
                return count;
            }
        });
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionRead() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        int count = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){

            public Integer run(TransactionContext transaction) throws Exception {
                int count = 0;
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                    while (rs.next()) {
                        ++count;
                    }
                }
                return count;
            }
        });
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionReadUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        int count = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){

            public Integer run(TransactionContext transaction) throws Exception {
                int count = 0;
                try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                    while (rs.next()) {
                        ++count;
                    }
                }
                return count;
            }
        });
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionReadRow() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        Struct row = (Struct)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Struct>(){

            public Struct run(TransactionContext transaction) throws Exception {
                return transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            }
        });
        Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void readWriteTransactionReadRowUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        Struct row = (Struct)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Struct>(){

            public Struct run(TransactionContext transaction) throws Exception {
                return transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            }
        });
        Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void readWriteTransactionUpdate() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        long count = (Long)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                return transaction.executeUpdate(UPDATE_STATEMENT);
            }
        });
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void readWriteTransactionBatchUpdate() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        long[] count = (long[])runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<long[]>(){

            public long[] run(TransactionContext transaction) throws Exception {
                return transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT));
            }
        });
        Assert.assertThat((Object)count.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat((Object)count[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void readWriteTransactionBuffer() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        TransactionRunner runner = client.readWriteTransaction();
        runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
                return null;
            }
        });
        Assert.assertThat((Object)runner.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void readWriteTransactionSelectInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        TransactionRunner runner = client.readWriteTransaction();
        int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
            private int attempt = 0;

            public Integer run(TransactionContext transaction) throws Exception {
                ++this.attempt;
                int count = 0;
                try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        ++count;
                    }
                }
                Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                if (this.attempt == 1) {
                    RetryOnInvalidatedSessionTest.invalidateSessionPool();
                }
                rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                var4_4 = null;
                try {
                    while (rs.next()) {
                        ++count;
                    }
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var4_4 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                return this.attempt;
            }
        });
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionReadInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        TransactionRunner runner = client.readWriteTransaction();
        int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
            private int attempt = 0;

            public Integer run(TransactionContext transaction) throws Exception {
                ++this.attempt;
                int count = 0;
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                    while (rs.next()) {
                        ++count;
                    }
                }
                Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                if (this.attempt == 1) {
                    RetryOnInvalidatedSessionTest.invalidateSessionPool();
                }
                rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                var4_4 = null;
                try {
                    while (rs.next()) {
                        ++count;
                    }
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var4_4 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                return this.attempt;
            }
        });
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionReadUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        TransactionRunner runner = client.readWriteTransaction();
        int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
            private int attempt = 0;

            public Integer run(TransactionContext transaction) throws Exception {
                ++this.attempt;
                int count = 0;
                try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                    while (rs.next()) {
                        ++count;
                    }
                }
                Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                if (this.attempt == 1) {
                    RetryOnInvalidatedSessionTest.invalidateSessionPool();
                }
                rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                var4_4 = null;
                try {
                    while (rs.next()) {
                        ++count;
                    }
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var4_4 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                return this.attempt;
            }
        });
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionReadRowInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        TransactionRunner runner = client.readWriteTransaction();
        int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
            private int attempt = 0;

            public Integer run(TransactionContext transaction) throws Exception {
                ++this.attempt;
                Struct row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                if (this.attempt == 1) {
                    RetryOnInvalidatedSessionTest.invalidateSessionPool();
                }
                row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                return this.attempt;
            }
        });
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionReadRowUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        TransactionRunner runner = client.readWriteTransaction();
        int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
            private int attempt = 0;

            public Integer run(TransactionContext transaction) throws Exception {
                ++this.attempt;
                Struct row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                if (this.attempt == 1) {
                    RetryOnInvalidatedSessionTest.invalidateSessionPool();
                }
                row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                return this.attempt;
            }
        });
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerReadOnlySessionInPool() throws InterruptedException {
        RetryOnInvalidatedSessionTest.initReadOnlySessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerSelect() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerRead() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerReadUsingIndex() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerReadRow() throws InterruptedException {
        Struct row;
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void transactionManagerReadRowUsingIndex() throws InterruptedException {
        Struct row;
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void transactionManagerUpdate() throws InterruptedException {
        long count;
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    count = transaction.executeUpdate(UPDATE_STATEMENT);
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void transactionManagerBatchUpdate() throws InterruptedException {
        long[] count;
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    count = transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)count.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat((Object)count[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void transactionManagerBuffer() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
                try {
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Assert.assertThat((Object)manager.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void transactionManagerSelectInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                int count = 0;
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                    var7_10 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_10 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var7_10 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var7_10.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerReadInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                int count = 0;
                try {
                    try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                    var7_10 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_10 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var7_10 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var7_10.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerReadUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                int count = 0;
                try {
                    try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                    var7_10 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_10 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var7_10 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var7_10.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerReadRowInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                try {
                    Struct row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void transactionManagerReadRowUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager();){
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                try {
                    Struct row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    Assert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Assert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void partitionedDml() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        Assert.assertThat((Object)client.executePartitionedUpdate(UPDATE_STATEMENT), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void write() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        Timestamp timestamp = client.write(Arrays.asList(Mutation.delete((String)"FOO", (KeySet)KeySet.all())));
        Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void writeAtLeastOnce() throws InterruptedException {
        if (this.failOnInvalidatedSession) {
            this.expected.expect(SessionNotFoundException.class);
        }
        RetryOnInvalidatedSessionTest.initReadWriteSessionPool();
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        Timestamp timestamp = client.writeAtLeastOnce(Arrays.asList(Mutation.delete((String)"FOO", (KeySet)KeySet.all())));
        Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

