/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.truth.Truth;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerExceptionFactoryTest {
    @Test
    public void http2InternalErrorIsRetryable() {
        Status status = Status.fromCodeValue((int)Status.Code.INTERNAL.value()).withDescription("HTTP/2 error code: INTERNAL_ERROR");
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Boolean)e.isRetryable()).isTrue();
    }

    @Test
    public void connectionClosedIsRetryable() {
        Status status = Status.fromCodeValue((int)Status.Code.INTERNAL.value()).withDescription("Connection closed with unknown cause");
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Boolean)e.isRetryable()).isTrue();
    }

    @Test
    public void resourceExhausted() {
        Status status = Status.fromCodeValue((int)Status.Code.RESOURCE_EXHAUSTED.value()).withDescription("Memory pushback");
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Boolean)e.isRetryable()).isFalse();
    }

    @Test
    public void resourceExhaustedWithBackoff() {
        Status status = Status.fromCodeValue((int)Status.Code.RESOURCE_EXHAUSTED.value()).withDescription("Memory pushback");
        Metadata trailers = new Metadata();
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(1000000).setSeconds(1L)).build();
        trailers.put(key, (Object)retryInfo);
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status, trailers));
        Truth.assertThat((Boolean)e.isRetryable()).isTrue();
        Truth.assertThat((Long)e.getRetryDelayInMillis()).isEqualTo((Object)1001);
    }

    @Test
    public void abortWithRetryInfo() {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(1000000).setSeconds(1L)).build();
        trailers.put(key, (Object)retryInfo);
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status, trailers));
        Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
        Truth.assertThat((Long)((AbortedException)e).getRetryDelayInMillis()).isEqualTo((Object)1001L);
    }

    @Test
    public void abortWithoutRetryInfo() {
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
        Truth.assertThat((Long)((AbortedException)e).getRetryDelayInMillis()).isEqualTo((Object)-1L);
    }

    @Test
    public void abortWithoutDuration() {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)RetryInfo.getDefaultInstance());
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status, trailers));
        Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
        Truth.assertThat((Long)((AbortedException)e).getRetryDelayInMillis()).isEqualTo((Object)-1L);
    }
}

