/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.threeten.bp.Duration;

@RunWith(value=Parameterized.class)
public class SpannerGaxRetryTest {
    private static final ResultSetMetadata READ_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("BAR").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet READ_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(READ_METADATA).build();
    private static final com.google.spanner.v1.ResultSet READ_ROW_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(READ_METADATA).build();
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final long UPDATE_COUNT = 1L;
    private static final MockSpannerServiceImpl.SimulatedExecutionTime ONE_SECOND = MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0);
    private static final StatusRuntimeException UNAVAILABLE = Status.UNAVAILABLE.withDescription("Retryable test exception.").asRuntimeException();
    private static final StatusRuntimeException FAILED_PRECONDITION = Status.FAILED_PRECONDITION.withDescription("Non-retryable test exception.").asRuntimeException();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static SpannerClient spannerClient;
    private static Spanner spanner;
    private static DatabaseClient client;
    @Parameterized.Parameter(value=0)
    public boolean enableGaxRetries;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Parameterized.Parameters(name="enable GAX retries = {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{true});
        params.add(new Object[]{false});
        return params;
    }

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.all(), Arrays.asList("BAR"), READ_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.singleKey((Key)Key.of((Object[])new Object[0])), Arrays.asList("BAR"), READ_ROW_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        spannerClient = SpannerClient.create((SpannerSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        spannerClient.close();
        server.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        final RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)500L)).setMaxRpcTimeout(Duration.ofMillis((long)500L)).setMaxAttempts(3).setTotalTimeout(Duration.ofMillis((long)1500L)).build();
        RetrySettings commitRetrySettings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setMaxAttempts(1).setTotalTimeout(Duration.ofMillis((long)20000L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.getSpannerStubSettingsBuilder().applyToAllUnaryMethods(new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

            public Void apply(UnaryCallSettings.Builder<?, ?> input) {
                input.setRetrySettings(retrySettings);
                return null;
            }
        });
        builder.getSpannerStubSettingsBuilder().commitSettings().setRetrySettings(commitRetrySettings);
        builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetrySettings(retrySettings);
        builder.getSpannerStubSettingsBuilder().streamingReadSettings().setRetrySettings(retrySettings);
        if (!this.enableGaxRetries) {
            builder.getSpannerStubSettingsBuilder().applyToAllUnaryMethods(new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

                public Void apply(UnaryCallSettings.Builder<?, ?> input) {
                    input.setRetryableCodes((Set)ImmutableSet.of());
                    return null;
                }
            });
            builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetryableCodes((Set)ImmutableSet.of());
            builder.getSpannerStubSettingsBuilder().streamingReadSettings().setRetryableCodes((Set)ImmutableSet.of());
        }
        spanner = (Spanner)builder.build().getService();
        client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
    }

    @After
    public void tearDown() throws Exception {
        spanner.close();
    }

    private void warmUpSessionPool() {
        block4: for (int i = 0; i < 10; ++i) {
            int retryCount = 0;
            while (true) {
                try {
                    TransactionRunner runner = client.readWriteTransaction();
                    long updateCount = (Long)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

                        public Long run(TransactionContext transaction) throws Exception {
                            return transaction.executeUpdate(UPDATE_STATEMENT);
                        }
                    });
                    Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    continue block4;
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED && ++retryCount <= 10) continue;
                    throw e;
                }
                break;
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void singleUseTimeout() {
        if (this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        mockSpanner.setCreateSessionExecutionTime(ONE_SECOND);
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseUnavailable() {
        if (!this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.UNAVAILABLE));
        }
        mockSpanner.addException((Exception)((Object)UNAVAILABLE));
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseNonRetryableError() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.FAILED_PRECONDITION));
        mockSpanner.addException((Exception)((Object)FAILED_PRECONDITION));
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseNonRetryableErrorOnNext() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.FAILED_PRECONDITION));
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            mockSpanner.addException((Exception)((Object)FAILED_PRECONDITION));
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseInternal() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        mockSpanner.addException(new IllegalArgumentException());
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseReadOnlyTransactionTimeout() {
        if (this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        mockSpanner.setCreateSessionExecutionTime(ONE_SECOND);
        try (ResultSet rs = client.singleUseReadOnlyTransaction().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseReadOnlyTransactionUnavailable() {
        if (!this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.UNAVAILABLE));
        }
        mockSpanner.addException((Exception)((Object)UNAVAILABLE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseExecuteStreamingSqlTimeout() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(ONE_SECOND);
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseExecuteStreamingSqlUnavailable() {
        try (ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            mockSpanner.addException((Exception)((Object)UNAVAILABLE));
            while (rs.next()) {
            }
        }
    }

    @Test
    public void readWriteTransactionTimeout() {
        this.warmUpSessionPool();
        if (this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        mockSpanner.setBeginTransactionExecutionTime(ONE_SECOND);
        TransactionRunner runner = client.readWriteTransaction();
        long updateCount = (Long)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                return transaction.executeUpdate(UPDATE_STATEMENT);
            }
        });
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void readWriteTransactionUnavailable() {
        this.warmUpSessionPool();
        if (!this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.UNAVAILABLE));
        }
        mockSpanner.addException((Exception)((Object)UNAVAILABLE));
        TransactionRunner runner = client.readWriteTransaction();
        long updateCount = (Long)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                return transaction.executeUpdate(UPDATE_STATEMENT);
            }
        });
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void readWriteTransactionStatementAborted() {
        TransactionRunner runner = client.readWriteTransaction();
        final AtomicInteger attempts = new AtomicInteger();
        long updateCount = (Long)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                if (attempts.getAndIncrement() == 0) {
                    mockSpanner.abortTransaction(transaction);
                }
                return transaction.executeUpdate(UPDATE_STATEMENT);
            }
        });
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        Assert.assertThat((Object)attempts.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionCommitAborted() {
        TransactionRunner runner = client.readWriteTransaction();
        final AtomicInteger attempts = new AtomicInteger();
        long updateCount = (Long)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                long res = transaction.executeUpdate(UPDATE_STATEMENT);
                if (attempts.getAndIncrement() == 0) {
                    mockSpanner.abortTransaction(transaction);
                }
                return res;
            }
        });
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        Assert.assertThat((Object)attempts.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test(expected=Exception.class)
    public void readWriteTransactionCheckedException() {
        TransactionRunner runner = client.readWriteTransaction();
        runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                transaction.executeUpdate(UPDATE_STATEMENT);
                throw new Exception("test");
            }
        });
    }

    @Test(expected=SpannerException.class)
    public void readWriteTransactionUncheckedException() {
        TransactionRunner runner = client.readWriteTransaction();
        runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                transaction.executeUpdate(UPDATE_STATEMENT);
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"test");
            }
        });
    }

    @Test
    public void transactionManagerTimeout() {
        this.warmUpSessionPool();
        if (this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        mockSpanner.setBeginTransactionExecutionTime(ONE_SECOND);
        try (TransactionManager txManager = client.transactionManager();){
            TransactionContext tx = txManager.begin();
            while (true) {
                try {
                    Assert.assertThat((Object)tx.executeUpdate(UPDATE_STATEMENT), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    txManager.commit();
                }
                catch (AbortedException e) {
                    tx = txManager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerUnavailable() {
        this.warmUpSessionPool();
        if (!this.enableGaxRetries) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.UNAVAILABLE));
        }
        mockSpanner.addException((Exception)((Object)UNAVAILABLE));
        try (TransactionManager txManager = client.transactionManager();){
            TransactionContext tx = txManager.begin();
            while (true) {
                try {
                    Assert.assertThat((Object)tx.executeUpdate(UPDATE_STATEMENT), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    txManager.commit();
                }
                catch (AbortedException e) {
                    tx = txManager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }
}

