/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.spanner.v1.Session;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class SpannerImplTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SpannerOptions spannerOptions;
    private SpannerImpl impl;
    @Captor
    ArgumentCaptor<Map<SpannerRpc.Option, Object>> options;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.spannerOptions.getPrefetchChunks()).thenReturn((Object)1);
        Mockito.when((Object)this.spannerOptions.getRetrySettings()).thenReturn((Object)RetrySettings.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getClock()).thenReturn((Object)NanoClock.getDefaultClock());
        this.impl = new SpannerImpl(this.rpc, this.spannerOptions);
    }

    @Test
    public void createAndCloseSession() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(labels);
        String dbName = "projects/p1/instances/i1/databases/d1";
        String sessionName = dbName + "/sessions/s1";
        DatabaseId db = DatabaseId.of((String)dbName);
        Session sessionProto = Session.newBuilder().setName(sessionName).putAllLabels(labels).build();
        Mockito.when((Object)this.rpc.createSession((String)Mockito.eq((Object)dbName), (Map)Mockito.eq(labels), (Map)this.options.capture())).thenReturn((Object)sessionProto);
        SessionImpl session = this.impl.createSession(db);
        Truth.assertThat((String)session.getName()).isEqualTo((Object)sessionName);
        session.close();
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).deleteSession(sessionName, (Map)this.options.getValue());
    }

    @Test
    public void getDbclientAgainGivesSame() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(labels);
        String dbName = "projects/p1/instances/i1/databases/d1";
        DatabaseId db = DatabaseId.of((String)dbName);
        Mockito.when((Object)this.spannerOptions.getTransportOptions()).thenReturn((Object)GrpcTransportOptions.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)SessionPoolOptions.newBuilder().build());
        DatabaseClient databaseClient = this.impl.getDatabaseClient(db);
        DatabaseClient databaseClient1 = this.impl.getDatabaseClient(db);
        Truth.assertThat((Object)databaseClient1).isSameInstanceAs((Object)databaseClient);
    }

    @Test
    public void getDbclientAfterCloseThrows() {
        SpannerImpl imp = new SpannerImpl(this.rpc, this.spannerOptions);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(labels);
        String dbName = "projects/p1/instances/i1/databases/d1";
        DatabaseId db = DatabaseId.of((String)dbName);
        Mockito.when((Object)this.spannerOptions.getTransportOptions()).thenReturn((Object)GrpcTransportOptions.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)SessionPoolOptions.newBuilder().build());
        imp.close();
        try {
            imp.getDatabaseClient(db);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Cloud Spanner client has been closed");
        }
    }
}

