/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.TransportOptions;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class SpannerOptionsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void defaultBuilder() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)"https://spanner.googleapis.com");
        Truth.assertThat((Integer)options.getPrefetchChunks()).isEqualTo((Object)4);
        Truth.assertThat((Map)options.getSessionLabels()).isNull();
    }

    @Test
    public void builder() {
        String host = "http://localhost:8000/";
        String projectId = "test-project";
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setHost(host)).setProjectId(projectId)).setPrefetchChunks(2).setSessionLabels(labels).build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)host);
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((Integer)options.getPrefetchChunks()).isEqualTo((Object)2);
        Truth.assertThat((Map)options.getSessionLabels()).containsExactlyEntriesIn(labels);
    }

    @Test
    public void testSpannerDefaultRetrySettings() {
        RetrySettings defaultRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)1L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofSeconds((long)32L)).setInitialRpcTimeout(Duration.ofSeconds((long)60L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)60L)).setTotalTimeout(Duration.ofSeconds((long)600L)).build();
        RetrySettings streamingRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)1200000L)).build();
        RetrySettings longRunningRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        SpannerStubSettings stubSettings = options.getSpannerStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.beginTransactionSettings(), stubSettings.createSessionSettings(), stubSettings.deleteSessionSettings(), stubSettings.executeBatchDmlSettings(), stubSettings.executeSqlSettings(), stubSettings.getSessionSettings(), stubSettings.listSessionsSettings(), stubSettings.partitionQuerySettings(), stubSettings.partitionReadSettings(), stubSettings.readSettings(), stubSettings.rollbackSettings());
        List<ServerStreamingCallSettings> callsWithStreamingSettings = Arrays.asList(stubSettings.executeStreamingSqlSettings(), stubSettings.streamingReadSettings());
        List<UnaryCallSettings> callsWithLongRunningSettings = Arrays.asList(stubSettings.commitSettings());
        for (UnaryCallSettings unaryCallSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)unaryCallSettings.getRetrySettings()).isEqualTo((Object)defaultRetrySettings);
        }
        for (ServerStreamingCallSettings serverStreamingCallSettings : callsWithStreamingSettings) {
            Truth.assertThat((Object)serverStreamingCallSettings.getRetrySettings()).isEqualTo((Object)streamingRetrySettings);
        }
        for (UnaryCallSettings unaryCallSettings : callsWithLongRunningSettings) {
            Truth.assertThat((Object)unaryCallSettings.getRetrySettings()).isEqualTo((Object)longRunningRetrySettings);
        }
    }

    @Test
    public void testSpannerCustomRetrySettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)9999L)).setRetryDelayMultiplier(9999.99).setMaxRetryDelay(Duration.ofSeconds((long)9999L)).setInitialRpcTimeout(Duration.ofSeconds((long)9999L)).setRpcTimeoutMultiplier(9999.99).setMaxRpcTimeout(Duration.ofSeconds((long)9999L)).setTotalTimeout(Duration.ofSeconds((long)9999L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project");
        SpannerStubSettings.Builder stubSettingsBuilder = builder.getSpannerStubSettingsBuilder();
        List<UnaryCallSettings.Builder> unaryCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.beginTransactionSettings(), stubSettingsBuilder.createSessionSettings(), stubSettingsBuilder.deleteSessionSettings(), stubSettingsBuilder.executeBatchDmlSettings(), stubSettingsBuilder.executeSqlSettings(), stubSettingsBuilder.getSessionSettings(), stubSettingsBuilder.listSessionsSettings(), stubSettingsBuilder.partitionQuerySettings(), stubSettingsBuilder.partitionReadSettings(), stubSettingsBuilder.readSettings(), stubSettingsBuilder.rollbackSettings(), stubSettingsBuilder.commitSettings());
        for (UnaryCallSettings.Builder builder2 : unaryCallSettingsBuilders) {
            builder2.setRetrySettings(retrySettings);
        }
        List<ServerStreamingCallSettings.Builder> streamingCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.executeStreamingSqlSettings(), stubSettingsBuilder.streamingReadSettings());
        for (ServerStreamingCallSettings.Builder callSettingsBuilder : streamingCallSettingsBuilders) {
            callSettingsBuilder.setRetrySettings(retrySettings);
        }
        SpannerOptions spannerOptions = builder.build();
        SpannerStubSettings stubSettings = spannerOptions.getSpannerStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.beginTransactionSettings(), stubSettings.createSessionSettings(), stubSettings.deleteSessionSettings(), stubSettings.executeBatchDmlSettings(), stubSettings.executeSqlSettings(), stubSettings.getSessionSettings(), stubSettings.listSessionsSettings(), stubSettings.partitionQuerySettings(), stubSettings.partitionReadSettings(), stubSettings.readSettings(), stubSettings.rollbackSettings(), stubSettings.commitSettings());
        List<ServerStreamingCallSettings> callsWithStreamingSettings = Arrays.asList(stubSettings.executeStreamingSqlSettings(), stubSettings.streamingReadSettings());
        for (UnaryCallSettings unaryCallSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)unaryCallSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
        for (ServerStreamingCallSettings serverStreamingCallSettings : callsWithStreamingSettings) {
            Truth.assertThat((Object)serverStreamingCallSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
    }

    @Test
    public void testDatabaseAdminDefaultRetrySettings() {
        RetrySettings defaultRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        DatabaseAdminStubSettings stubSettings = options.getDatabaseAdminStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.dropDatabaseSettings(), stubSettings.getDatabaseDdlSettings(), stubSettings.getDatabaseSettings());
        for (UnaryCallSettings callSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)defaultRetrySettings);
        }
    }

    @Test
    public void testDatabaseAdminCustomRetrySettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)9999L)).setRetryDelayMultiplier(9999.99).setMaxRetryDelay(Duration.ofSeconds((long)9999L)).setInitialRpcTimeout(Duration.ofSeconds((long)9999L)).setRpcTimeoutMultiplier(9999.99).setMaxRpcTimeout(Duration.ofSeconds((long)9999L)).setTotalTimeout(Duration.ofSeconds((long)9999L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project");
        DatabaseAdminStubSettings.Builder stubSettingsBuilder = builder.getDatabaseAdminStubSettingsBuilder();
        List<UnaryCallSettings.Builder> unaryCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.dropDatabaseSettings(), stubSettingsBuilder.getDatabaseDdlSettings(), stubSettingsBuilder.getDatabaseSettings());
        for (UnaryCallSettings.Builder callSettingsBuilder : unaryCallSettingsBuilders) {
            callSettingsBuilder.setRetrySettings(retrySettings);
        }
        SpannerOptions options = builder.build();
        DatabaseAdminStubSettings stubSettings = options.getDatabaseAdminStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.dropDatabaseSettings(), stubSettings.getDatabaseDdlSettings(), stubSettings.getDatabaseSettings());
        for (UnaryCallSettings callSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
    }

    @Test
    public void testInstanceAdminDefaultRetrySettings() {
        RetrySettings defaultRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        InstanceAdminStubSettings stubSettings = options.getInstanceAdminStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.getInstanceConfigSettings(), stubSettings.listInstanceConfigsSettings(), stubSettings.deleteInstanceSettings(), stubSettings.getInstanceSettings(), stubSettings.listInstancesSettings());
        for (UnaryCallSettings callSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)defaultRetrySettings);
        }
    }

    @Test
    public void testInstanceAdminCustomRetrySettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)9999L)).setRetryDelayMultiplier(9999.99).setMaxRetryDelay(Duration.ofSeconds((long)9999L)).setInitialRpcTimeout(Duration.ofSeconds((long)9999L)).setRpcTimeoutMultiplier(9999.99).setMaxRpcTimeout(Duration.ofSeconds((long)9999L)).setTotalTimeout(Duration.ofSeconds((long)9999L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project");
        InstanceAdminStubSettings.Builder stubSettingsBuilder = builder.getInstanceAdminStubSettingsBuilder();
        List<UnaryCallSettings.Builder> unaryCallSettingsBuilders = Arrays.asList(stubSettingsBuilder.deleteInstanceSettings(), stubSettingsBuilder.getInstanceConfigSettings(), stubSettingsBuilder.getInstanceSettings(), stubSettingsBuilder.listInstanceConfigsSettings(), stubSettingsBuilder.listInstancesSettings());
        for (UnaryCallSettings.Builder callSettingsBuilder : unaryCallSettingsBuilders) {
            callSettingsBuilder.setRetrySettings(retrySettings);
        }
        SpannerOptions options = builder.build();
        InstanceAdminStubSettings stubSettings = options.getInstanceAdminStubSettings();
        List<UnaryCallSettings> callsWithDefaultSettings = Arrays.asList(stubSettings.getInstanceConfigSettings(), stubSettings.listInstanceConfigsSettings(), stubSettings.deleteInstanceSettings(), stubSettings.getInstanceSettings(), stubSettings.listInstancesSettings());
        for (UnaryCallSettings callSettings : callsWithDefaultSettings) {
            Truth.assertThat((Object)callSettings.getRetrySettings()).isEqualTo((Object)retrySettings);
        }
    }

    @Test
    public void testInvalidTransport() {
        this.thrown.expect(IllegalArgumentException.class);
        SpannerOptions.newBuilder().setTransportOptions((TransportOptions)Mockito.mock(TransportOptions.class));
    }

    @Test
    public void testInvalidSessionLabels() {
        this.thrown.expect(NullPointerException.class);
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("env", null);
        SpannerOptions.newBuilder().setSessionLabels(labels);
    }

    @Test
    public void testNullSessionLabels() {
        this.thrown.expect(NullPointerException.class);
        SpannerOptions.newBuilder().setSessionLabels(null);
    }
}

