/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRetryHelper;
import io.grpc.Context;
import io.grpc.Deadline;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerRetryHelperTest {
    @Test
    public void testCancelledContext() {
        block2: {
            final Context.CancellableContext withCancellation = Context.current().withCancellation();
            final Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test");
                }
            };
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
            service.schedule(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    withCancellation.cancel((Throwable)new InterruptedException());
                    return null;
                }
            }, 30L, TimeUnit.MILLISECONDS);
            try {
                withCancellation.run(new Runnable(){

                    @Override
                    public void run() {
                        Assert.assertThat((Object)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    }
                });
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                if (e.getErrorCode() == ErrorCode.CANCELLED) break block2;
                Assert.fail((String)String.format("unexpected error %s, expected %s", e.getErrorCode().name(), ErrorCode.CANCELLED.name()));
            }
        }
    }

    @Test
    public void testTimedoutContext() {
        block2: {
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
            Context.CancellableContext withDeadline = Context.current().withDeadline(Deadline.after((long)30L, (TimeUnit)TimeUnit.MILLISECONDS), service);
            final Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test");
                }
            };
            try {
                withDeadline.run(new Runnable(){

                    @Override
                    public void run() {
                        Assert.assertThat((Object)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    }
                });
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED) break block2;
                Assert.fail((String)String.format("unexpected error %s, expected %s", e.getErrorCode().name(), ErrorCode.DEADLINE_EXCEEDED.name()));
            }
        }
    }

    @Test
    public void noException() {
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 2;
            }
        };
        Assert.assertThat((Object)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test(expected=IllegalStateException.class)
    public void propagateUncheckedException() {
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                throw new IllegalStateException("test");
            }
        };
        SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable);
    }

    @Test
    public void retryOnAborted() {
        final AtomicInteger attempts = new AtomicInteger();
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (attempts.getAndIncrement() == 0) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test");
                }
                return 2;
            }
        };
        Assert.assertThat((Object)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void retryMultipleTimesOnAborted() {
        final AtomicInteger attempts = new AtomicInteger();
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (attempts.getAndIncrement() < 2) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test");
                }
                return 2;
            }
        };
        Assert.assertThat((Object)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test(expected=IllegalStateException.class)
    public void retryOnAbortedAndThenPropagateUnchecked() {
        final AtomicInteger attempts = new AtomicInteger();
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (attempts.getAndIncrement() == 0) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test");
                }
                throw new IllegalStateException("test");
            }
        };
        SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable);
    }
}

