/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ValueTest {
    private static final String NULL_STRING = "NULL";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static ByteArray newByteArray(String data) {
        return ByteArray.copyFrom((String)data);
    }

    @SafeVarargs
    private static <T> Iterable<T> plainIterable(T ... values) {
        final ArrayList list = Lists.newArrayList((Object[])values);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return list.iterator();
            }
        };
    }

    @Test
    public void bool() {
        Value v = Value.bool((boolean)true);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bool());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.getBool()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"true");
    }

    @Test
    public void boolWrapper() {
        Value v = Value.bool((Boolean)Boolean.FALSE);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bool());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.getBool()).isFalse();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"false");
    }

    @Test
    public void boolWrapperNull() {
        Value v = Value.bool(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bool());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getBool();
    }

    @Test
    public void int64() {
        Value v = Value.int64((long)123L);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Long)v.getInt64()).isEqualTo((Object)123);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"123");
    }

    @Test
    public void int64TryGetBool() {
        Value value = Value.int64((long)1234L);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: BOOL actual: INT64");
        value.getBool();
    }

    @Test
    public void int64NullTryGetBool() {
        Value value = Value.int64(null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: BOOL actual: INT64");
        value.getBool();
    }

    @Test
    public void int64TryGetInt64Array() {
        Value value = Value.int64((long)1234L);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: ARRAY<INT64> actual: INT64");
        value.getInt64Array();
    }

    @Test
    public void int64Wrapper() {
        Value v = Value.int64((Long)123L);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Long)v.getInt64()).isEqualTo((Object)123);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"123");
    }

    @Test
    public void int64WrapperNull() {
        Value v = Value.int64(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getInt64();
    }

    @Test
    public void float64() {
        Value v = Value.float64((double)1.23);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.float64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Double)v.getFloat64()).isWithin(1.0E-4).of(1.23);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"1.23");
    }

    @Test
    public void float64Wrapper() {
        Value v = Value.float64((Double)1.23);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.float64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Double)v.getFloat64()).isWithin(1.0E-4).of(1.23);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"1.23");
    }

    @Test
    public void float64WrapperNull() {
        Value v = Value.float64(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.float64());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getFloat64();
    }

    @Test
    public void string() {
        Value v = Value.string((String)"abc");
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.string());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((String)v.getString()).isEqualTo((Object)"abc");
    }

    @Test
    public void stringNull() {
        Value v = Value.string(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.string());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getString();
    }

    @Test
    public void stringLong() {
        String str = "aaaaaaaaaabbbbbbbbbbccccccccccdddddddddd";
        Value v = Value.string((String)str);
        Truth.assertThat((String)v.getString()).isEqualTo((Object)str);
        Truth.assertThat((String)v.toString()).hasLength(32);
        Truth.assertThat((String)v.toString()).startsWith(str.substring(0, 29));
        Truth.assertThat((String)v.toString()).endsWith("...");
    }

    @Test
    public void bytes() {
        ByteArray bytes = ValueTest.newByteArray("abc");
        Value v = Value.bytes((ByteArray)bytes);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bytes());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBytes()).isSameInstanceAs((Object)bytes);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)bytes.toString());
    }

    @Test
    public void bytesUnprintable() {
        ByteArray bytes = ByteArray.copyFrom((byte[])new byte[]{97, 0, 15, -1, 101});
        Value v = Value.bytes((ByteArray)bytes);
        Truth.assertThat((Iterable)v.getBytes()).isSameInstanceAs((Object)bytes);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)bytes.toString());
    }

    @Test
    public void bytesNull() {
        Value v = Value.bytes(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bytes());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getBytes();
    }

    @Test
    public void timestamp() {
        String timestamp = "2016-09-15T00:00:00Z";
        Timestamp t = Timestamp.parseTimestamp((String)timestamp);
        Value v = Value.timestamp((Timestamp)t);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.timestamp());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.isCommitTimestamp()).isFalse();
        Truth.assertThat((Comparable)v.getTimestamp()).isSameInstanceAs((Object)t);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)timestamp);
    }

    @Test
    public void timestampNull() {
        Value v = Value.timestamp(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.timestamp());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        Truth.assertThat((Boolean)v.isCommitTimestamp()).isFalse();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getTimestamp();
    }

    @Test
    public void commitTimestamp() {
        Value v = Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.timestamp());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.isCommitTimestamp()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"spanner.commit_timestamp()");
        Truth.assertThat((Object)v.toProto()).isEqualTo((Object)com.google.protobuf.Value.newBuilder().setStringValue("spanner.commit_timestamp()").build());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Commit timestamp value");
        v.getTimestamp();
    }

    @Test
    public void date() {
        String date = "2016-09-15";
        Date t = Date.parseDate((String)date);
        Value v = Value.date((Date)t);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.date());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Comparable)v.getDate()).isSameInstanceAs((Object)t);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)date);
    }

    @Test
    public void dateNull() {
        Value v = Value.date(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.date());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getDate();
    }

    @Test
    public void boolArray() {
        Value v = Value.boolArray((boolean[])new boolean[]{true, false});
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBoolArray()).containsExactly(new Object[]{true, false}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[true,false]");
    }

    @Test
    public void boolArrayRange() {
        Value v = Value.boolArray((boolean[])new boolean[]{true, false, false, true, false}, (int)1, (int)3);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBoolArray()).containsExactly(new Object[]{false, false, true}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[false,false,true]");
    }

    @Test
    public void boolArrayNull() {
        Value v = Value.boolArray((boolean[])null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getBoolArray();
    }

    @Test
    public void boolArrayFromList() {
        Value v = Value.boolArray(Arrays.asList(true, null, false));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBoolArray()).containsExactly(new Object[]{true, null, false}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[true,NULL,false]");
    }

    @Test
    public void boolArrayFromListNull() {
        Value v = Value.boolArray((Iterable)null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getBoolArray();
    }

    @Test
    public void boolArrayFromPlainIterable() {
        for (int i = 0; i < 50; ++i) {
            Boolean[] data = new Boolean[i];
            for (int j = 0; j < data.length; ++j) {
                data[j] = j % 3 == 2 ? null : Boolean.valueOf(j % 3 == 1);
            }
            String name = "boolArray() of length " + i;
            Value v = Value.boolArray(ValueTest.plainIterable(data));
            Truth.assertWithMessage((String)name).that(Boolean.valueOf(v.isNull())).isFalse();
            Truth.assertWithMessage((String)name).that((Iterable)v.getBoolArray()).containsExactly((Object[])data).inOrder();
        }
    }

    @Test
    public void boolArrayTryGetInt64Array() {
        Value value = Value.boolArray(Arrays.asList(true));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: ARRAY<INT64> actual: ARRAY<BOOL>");
        value.getInt64Array();
    }

    @Test
    public void int64Array() {
        Value v = Value.int64Array((long[])new long[]{1L, 2L});
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getInt64Array()).containsExactly(new Object[]{1L, 2L}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[1,2]");
    }

    @Test
    public void int64ArrayRange() {
        Value v = Value.int64Array((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int)1, (int)3);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getInt64Array()).containsExactly(new Object[]{2L, 3L, 4L}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[2,3,4]");
    }

    @Test
    public void int64ArrayNull() {
        Value v = Value.int64Array((long[])null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getInt64Array();
    }

    @Test
    public void int64ArrayWrapper() {
        Value v = Value.int64Array(Arrays.asList(1L, null, 3L));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getInt64Array()).containsExactly(new Object[]{1L, null, 3L}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[1,NULL,3]");
    }

    @Test
    public void int64ArrayWrapperNull() {
        Value v = Value.int64Array((Iterable)null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getInt64Array();
    }

    @Test
    public void int64ArrayTryGetBool() {
        Value value = Value.int64Array(Arrays.asList(1234L));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: BOOL actual: ARRAY<INT64>");
        value.getBool();
    }

    @Test
    public void int64ArrayNullTryGetBool() {
        Value value = Value.int64Array((Iterable)null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: BOOL actual: ARRAY<INT64>");
        value.getBool();
    }

    @Test
    public void float64Array() {
        Value v = Value.float64Array((double[])new double[]{0.1, 0.2});
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getFloat64Array()).containsExactly(new Object[]{0.1, 0.2}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[0.1,0.2]");
    }

    @Test
    public void float64ArrayRange() {
        Value v = Value.float64Array((double[])new double[]{0.1, 0.2, 0.3, 0.4, 0.5}, (int)1, (int)3);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getFloat64Array()).containsExactly(new Object[]{0.2, 0.3, 0.4}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[0.2,0.3,0.4]");
    }

    @Test
    public void float64ArrayNull() {
        Value v = Value.float64Array((double[])null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getFloat64Array();
    }

    @Test
    public void float64ArrayWrapper() {
        Value v = Value.float64Array(Arrays.asList(0.1, null, 0.3));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getFloat64Array()).containsExactly(new Object[]{0.1, null, 0.3}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[0.1,NULL,0.3]");
    }

    @Test
    public void float64ArrayWrapperNull() {
        Value v = Value.float64Array((Iterable)null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getFloat64Array();
    }

    @Test
    public void float64ArrayTryGetInt64Array() {
        Value value = Value.float64Array(Arrays.asList(0.1));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: ARRAY<INT64> actual: ARRAY<FLOAT64>");
        value.getInt64Array();
    }

    @Test
    public void stringArray() {
        Value v = Value.stringArray(Arrays.asList("a", null, "c"));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getStringArray()).containsExactly(new Object[]{"a", null, "c"}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[a,NULL,c]");
    }

    @Test
    public void stringArrayNull() {
        Value v = Value.stringArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getStringArray();
    }

    @Test
    public void stringArrayTryGetBytesArray() {
        Value value = Value.stringArray(Arrays.asList("a"));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: ARRAY<BYTES> actual: ARRAY<STRING>");
        value.getBytesArray();
    }

    @Test
    public void bytesArray() {
        ByteArray a = ValueTest.newByteArray("a");
        ByteArray c = ValueTest.newByteArray("c");
        Value v = Value.bytesArray(Arrays.asList(a, null, c));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBytesArray()).containsExactly(new Object[]{a, null, c}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)String.format("[%s,NULL,%s]", a, c));
    }

    @Test
    public void bytesArrayNull() {
        Value v = Value.bytesArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getBytesArray();
    }

    @Test
    public void bytesArrayTryGetStringArray() {
        Value value = Value.bytesArray(Arrays.asList(ValueTest.newByteArray("a")));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Expected: ARRAY<STRING> actual: ARRAY<BYTES>");
        value.getStringArray();
    }

    @Test
    public void timestampArray() {
        String t1 = "2015-09-15T00:00:00Z";
        String t2 = "2015-09-14T00:00:00Z";
        Value v = Value.timestampArray(Arrays.asList(Timestamp.parseTimestamp((String)t1), null, Timestamp.parseTimestamp((String)t2)));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getTimestampArray()).containsExactly(new Object[]{Timestamp.parseTimestamp((String)t1), null, Timestamp.parseTimestamp((String)t2)}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)("[" + t1 + ",NULL," + t2 + "]"));
    }

    @Test
    public void timestampArrayNull() {
        Value v = Value.timestampArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getTimestampArray();
    }

    @Test
    public void dateArray() {
        String d1 = "2016-09-15";
        String d2 = "2016-09-14";
        Value v = Value.dateArray(Arrays.asList(Date.parseDate((String)d1), null, Date.parseDate((String)d2)));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getDateArray()).containsExactly(new Object[]{Date.parseDate((String)d1), null, Date.parseDate((String)d2)}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)("[" + d1 + ",NULL," + d2 + "]"));
    }

    @Test
    public void dateArrayNull() {
        Value v = Value.dateArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("null value");
        v.getDateArray();
    }

    @Test
    public void struct() {
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("v1")).set("f2").to(30L)).build();
        Value v1 = Value.struct((Struct)struct);
        Truth.assertThat((Object)v1.getType()).isEqualTo((Object)struct.getType());
        Truth.assertThat((Boolean)v1.isNull()).isFalse();
        Truth.assertThat((Object)v1.getStruct()).isEqualTo((Object)struct);
        Truth.assertThat((String)v1.toString()).isEqualTo((Object)"[v1, 30]");
        Value v2 = Value.struct((Type)struct.getType(), (Struct)struct);
        Truth.assertThat((Object)v2).isEqualTo((Object)v1);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Mismatch between struct value and type.");
        Value.struct((Type)Type.struct(Arrays.asList(Type.StructField.of((String)"f3", (Type)Type.string()))), (Struct)struct);
    }

    @Test
    public void nullStruct() {
        List<Type.StructField> fieldTypes = Arrays.asList(Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.int64()));
        Value v = Value.struct((Type)Type.struct(fieldTypes), null);
        Truth.assertThat((Iterable)v.getType().getStructFields()).isEqualTo(fieldTypes);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("Illegal call to create a NULL struct value.");
        Value.struct(null);
    }

    @Test
    public void nullStructGetter() {
        List<Type.StructField> fieldTypes = Arrays.asList(Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.int64()));
        Value v = Value.struct((Type)Type.struct(fieldTypes), null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Illegal call to getter of null value.");
        v.getStruct();
    }

    @Test
    public void structArrayField() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        List<Struct> arrayElements = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v1")).set("ff2").to(1L)).build(), null, ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v3")).set("ff2").to(3L)).build());
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").toStructArray(elementType, arrayElements)).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.array((Type)elementType))}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isFalse();
        Truth.assertThat((String)struct.getString(0)).isEqualTo((Object)"x");
        Truth.assertThat((Iterable)struct.getStructList(1)).isEqualTo(arrayElements);
    }

    @Test
    public void structArrayFieldNull() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").toStructArray(elementType, null)).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.array((Type)elementType))}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isTrue();
    }

    @Test
    public void structArray() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        List<Struct> arrayElements = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v1")).set("ff2").to(1L)).build(), null, null, ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v3")).set("ff2").to(3L)).build());
        Value v = Value.structArray((Type)elementType, arrayElements);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Object)v.getType().getArrayElementType()).isEqualTo((Object)elementType);
        Truth.assertThat((Iterable)v.getStructArray()).isEqualTo(arrayElements);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[[v1, 1],NULL,NULL,[v3, 3]]");
    }

    @Test
    public void structArrayNull() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        Value v = Value.structArray((Type)elementType, null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((Object)v.getType().getArrayElementType()).isEqualTo((Object)elementType);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Illegal call to getter of null value");
        v.getStructArray();
    }

    @Test
    public void structArrayInvalidType() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        List<Struct> arrayElements = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("1")).set("ff2").to(1L)).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to(2L)).set("ff2").to(3L)).build());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("must have type STRUCT<ff1 STRING, ff2 INT64>");
        Value.structArray((Type)elementType, arrayElements);
    }

    @Test
    public void testEqualsHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{Value.bool((boolean)true), Value.bool((Boolean)Boolean.TRUE)});
        tester.addEqualityGroup(new Object[]{Value.bool((boolean)false)});
        tester.addEqualityGroup(new Object[]{Value.bool(null)});
        tester.addEqualityGroup(new Object[]{Value.int64((long)123L), Value.int64((Long)123L)});
        tester.addEqualityGroup(new Object[]{Value.int64((long)456L)});
        tester.addEqualityGroup(new Object[]{Value.int64(null)});
        tester.addEqualityGroup(new Object[]{Value.float64((double)1.23), Value.float64((Double)1.23)});
        tester.addEqualityGroup(new Object[]{Value.float64((double)4.56)});
        tester.addEqualityGroup(new Object[]{Value.float64(null)});
        tester.addEqualityGroup(new Object[]{Value.string((String)"abc"), Value.string((String)"abc")});
        tester.addEqualityGroup(new Object[]{Value.string((String)"def")});
        tester.addEqualityGroup(new Object[]{Value.string(null)});
        tester.addEqualityGroup(new Object[]{Value.bytes((ByteArray)ValueTest.newByteArray("abc")), Value.bytes((ByteArray)ValueTest.newByteArray("abc"))});
        tester.addEqualityGroup(new Object[]{Value.bytes((ByteArray)ValueTest.newByteArray("def"))});
        tester.addEqualityGroup(new Object[]{Value.bytes(null)});
        tester.addEqualityGroup(new Object[]{Value.timestamp(null), Value.timestamp(null)});
        tester.addEqualityGroup(new Object[]{Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP), Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP)});
        Timestamp now = Timestamp.now();
        tester.addEqualityGroup(new Object[]{Value.timestamp((Timestamp)now), Value.timestamp((Timestamp)now)});
        tester.addEqualityGroup(new Object[]{Value.timestamp((Timestamp)Timestamp.ofTimeMicroseconds((long)0L))});
        tester.addEqualityGroup(new Object[]{Value.date(null), Value.date(null)});
        tester.addEqualityGroup(new Object[]{Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)26)), Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)26))});
        tester.addEqualityGroup(new Object[]{Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)27))});
        Struct structValue1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(20L)).set("f2").to("def")).build();
        Struct structValue2 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(20L)).set("f2").to("def")).build();
        Truth.assertThat((Boolean)Value.struct((Struct)structValue1).equals(Value.struct((Struct)structValue2))).isTrue();
        tester.addEqualityGroup(new Object[]{Value.struct((Struct)structValue1), Value.struct((Struct)structValue2)});
        Type structType1 = structValue1.getType();
        Type structType2 = Type.struct(Arrays.asList(Type.StructField.of((String)"f1", (Type)Type.string())));
        tester.addEqualityGroup(new Object[]{Value.struct((Type)structType1, null), Value.struct((Type)structType1, null)});
        tester.addEqualityGroup(new Object[]{Value.struct((Type)structType2, null), Value.struct((Type)structType2, null)});
        tester.addEqualityGroup(new Object[]{Value.boolArray(Arrays.asList(false, true)), Value.boolArray((boolean[])new boolean[]{false, true}), Value.boolArray((boolean[])new boolean[]{true, false, true, false}, (int)1, (int)2), Value.boolArray(ValueTest.plainIterable(false, true))});
        tester.addEqualityGroup(new Object[]{Value.boolArray(Arrays.asList(false))});
        tester.addEqualityGroup(new Object[]{Value.boolArray((Iterable)null)});
        tester.addEqualityGroup(new Object[]{Value.int64Array(Arrays.asList(1L, 2L)), Value.int64Array((long[])new long[]{1L, 2L}), Value.int64Array((long[])new long[]{0L, 1L, 2L, 3L}, (int)1, (int)2), Value.int64Array(ValueTest.plainIterable(1L, 2L))});
        tester.addEqualityGroup(new Object[]{Value.int64Array(Arrays.asList(3L))});
        tester.addEqualityGroup(new Object[]{Value.int64Array((Iterable)null)});
        tester.addEqualityGroup(new Object[]{Value.float64Array(Arrays.asList(0.1, 0.2)), Value.float64Array((double[])new double[]{0.1, 0.2}), Value.float64Array((double[])new double[]{0.0, 0.1, 0.2, 0.3}, (int)1, (int)2), Value.float64Array(ValueTest.plainIterable(0.1, 0.2))});
        tester.addEqualityGroup(new Object[]{Value.float64Array(Arrays.asList(0.3))});
        tester.addEqualityGroup(new Object[]{Value.float64Array((Iterable)null)});
        tester.addEqualityGroup(new Object[]{Value.stringArray(Arrays.asList("a", "b")), Value.stringArray(Arrays.asList("a", "b"))});
        tester.addEqualityGroup(new Object[]{Value.stringArray(Arrays.asList("c"))});
        tester.addEqualityGroup(new Object[]{Value.stringArray(null)});
        tester.addEqualityGroup(new Object[]{Value.bytesArray(Arrays.asList(ValueTest.newByteArray("a"), ValueTest.newByteArray("b"))), Value.bytesArray(Arrays.asList(ValueTest.newByteArray("a"), ValueTest.newByteArray("b")))});
        tester.addEqualityGroup(new Object[]{Value.bytesArray(Arrays.asList(ValueTest.newByteArray("c")))});
        tester.addEqualityGroup(new Object[]{Value.bytesArray(null)});
        tester.addEqualityGroup(new Object[]{Value.timestampArray(Arrays.asList(null, now)), Value.timestampArray(Arrays.asList(null, now))});
        tester.addEqualityGroup(new Object[]{Value.timestampArray(null)});
        tester.addEqualityGroup(new Object[]{Value.dateArray(Arrays.asList(null, Date.fromYearMonthDay((int)2018, (int)2, (int)26))), Value.dateArray(Arrays.asList(null, Date.fromYearMonthDay((int)2018, (int)2, (int)26)))});
        tester.addEqualityGroup(new Object[]{Value.dateArray(null)});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, Arrays.asList(structValue1, null)), Value.structArray((Type)structType1, Arrays.asList(structValue2, null))});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, Arrays.asList(new Struct[]{null})), Value.structArray((Type)structType1, Arrays.asList(new Struct[]{null}))});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, null), Value.structArray((Type)structType1, null)});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, new ArrayList()), Value.structArray((Type)structType1, new ArrayList())});
        tester.testEquals();
    }

    @Test
    public void serialization() {
        SerializableTester.reserializeAndAssert((Object)Value.bool((boolean)true));
        SerializableTester.reserializeAndAssert((Object)Value.bool((boolean)false));
        SerializableTester.reserializeAndAssert((Object)Value.bool(null));
        SerializableTester.reserializeAndAssert((Object)Value.int64((long)123L));
        SerializableTester.reserializeAndAssert((Object)Value.int64(null));
        SerializableTester.reserializeAndAssert((Object)Value.float64((double)1.23));
        SerializableTester.reserializeAndAssert((Object)Value.float64(null));
        SerializableTester.reserializeAndAssert((Object)Value.string((String)"abc"));
        SerializableTester.reserializeAndAssert((Object)Value.string(null));
        SerializableTester.reserializeAndAssert((Object)Value.bytes((ByteArray)ValueTest.newByteArray("abc")));
        SerializableTester.reserializeAndAssert((Object)Value.bytes(null));
        SerializableTester.reserializeAndAssert((Object)Value.struct((Struct)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f").to(3L)).set("f").to((Date)null)).build()));
        SerializableTester.reserializeAndAssert((Object)Value.struct((Type)Type.struct(Arrays.asList(Type.StructField.of((String)"a", (Type)Type.string()), Type.StructField.of((String)"b", (Type)Type.int64()))), null));
        SerializableTester.reserializeAndAssert((Object)Value.boolArray((boolean[])new boolean[]{false, true}));
        SerializableTester.reserializeAndAssert((Object)Value.boolArray(BrokenSerializationList.of(true, false)));
        SerializableTester.reserializeAndAssert((Object)Value.boolArray((Iterable)null));
        SerializableTester.reserializeAndAssert((Object)Value.int64Array(BrokenSerializationList.of(1L, 2L)));
        SerializableTester.reserializeAndAssert((Object)Value.int64Array((long[])new long[]{1L, 2L}));
        SerializableTester.reserializeAndAssert((Object)Value.int64Array((Iterable)null));
        SerializableTester.reserializeAndAssert((Object)Value.float64Array((double[])new double[]{0.1, 0.2}));
        SerializableTester.reserializeAndAssert((Object)Value.float64Array(BrokenSerializationList.of(0.1, 0.2, 0.3)));
        SerializableTester.reserializeAndAssert((Object)Value.float64Array((Iterable)null));
        SerializableTester.reserializeAndAssert((Object)Value.timestamp(null));
        SerializableTester.reserializeAndAssert((Object)Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP));
        SerializableTester.reserializeAndAssert((Object)Value.timestamp((Timestamp)Timestamp.now()));
        SerializableTester.reserializeAndAssert((Object)Value.timestampArray(Arrays.asList(null, Timestamp.now())));
        SerializableTester.reserializeAndAssert((Object)Value.date(null));
        SerializableTester.reserializeAndAssert((Object)Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)26)));
        SerializableTester.reserializeAndAssert((Object)Value.dateArray(Arrays.asList(null, Date.fromYearMonthDay((int)2018, (int)2, (int)26))));
        BrokenSerializationList<String> of = BrokenSerializationList.of("a", "b");
        SerializableTester.reserializeAndAssert((Object)Value.stringArray(of));
        SerializableTester.reserializeAndAssert((Object)Value.stringArray(null));
        SerializableTester.reserializeAndAssert((Object)Value.bytesArray(BrokenSerializationList.of(ValueTest.newByteArray("a"), ValueTest.newByteArray("b"))));
        SerializableTester.reserializeAndAssert((Object)Value.bytesArray(null));
        Struct s1 = ((Struct.Builder)Struct.newBuilder().set("f1").to(1L)).build();
        Struct s2 = ((Struct.Builder)Struct.newBuilder().set("f1").to(2L)).build();
        SerializableTester.reserializeAndAssert((Object)Value.structArray((Type)s1.getType(), BrokenSerializationList.of(s1, null, s2)));
        SerializableTester.reserializeAndAssert((Object)Value.structArray((Type)s1.getType(), null));
    }

    @Test(expected=IllegalStateException.class)
    public void verifyBrokenSerialization() {
        SerializableTester.reserializeAndAssert(BrokenSerializationList.of(1, 2, 3));
    }

    private static class BrokenSerializationList<T>
    extends ForwardingList<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<T> delegate;

        public static <T> BrokenSerializationList<T> of(T ... values) {
            return new BrokenSerializationList<T>(Arrays.asList(values));
        }

        private BrokenSerializationList(List<T> delegate) {
            this.delegate = delegate;
        }

        protected List<T> delegate() {
            return this.delegate;
        }

        private void readObject(ObjectInputStream unusedStream) throws IOException, ClassNotFoundException {
            throw new IllegalStateException("Serialization disabled");
        }

        private void writeObject(ObjectOutputStream unusedStream) throws IOException {
            throw new IllegalStateException("Serialization disabled");
        }
    }
}

