/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.database.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminSettings;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdmin;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.InstanceName;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatabaseAdminClientTest {
    private static MockDatabaseAdmin mockDatabaseAdmin;
    private static MockServiceHelper serviceHelper;
    private DatabaseAdminClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockDatabaseAdmin = new MockDatabaseAdmin();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockDatabaseAdmin));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        DatabaseAdminSettings settings = ((DatabaseAdminSettings.Builder)((DatabaseAdminSettings.Builder)DatabaseAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = DatabaseAdminClient.create((DatabaseAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listDatabasesTest() {
        String nextPageToken = "";
        Database databasesElement = Database.newBuilder().build();
        List<Database> databases = Arrays.asList(databasesElement);
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken(nextPageToken).addAllDatabases(databases).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListDatabasesPagedResponse pagedListResponse = this.client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatabasesRequest actualRequest = (ListDatabasesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)InstanceName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatabasesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest() throws Exception {
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database expectedResponse = Database.newBuilder().setName(name.toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String createStatement = "createStatement552974828";
        Database actualResponse = (Database)this.client.createDatabaseAsync(parent, createStatement).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatabaseRequest actualRequest = (CreateDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)InstanceName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)createStatement, (Object)actualRequest.getCreateStatement());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String createStatement = "createStatement552974828";
            this.client.createDatabaseAsync(parent, createStatement).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getDatabaseTest() {
        DatabaseName name2 = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database expectedResponse = Database.newBuilder().setName(name2.toString()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database actualResponse = this.client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseRequest actualRequest = (GetDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DatabaseName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatabaseDdlTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateDatabaseDdlTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        ArrayList statements = new ArrayList();
        Empty actualResponse = (Empty)this.client.updateDatabaseDdlAsync(database, statements).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDatabaseDdlRequest actualRequest = (UpdateDatabaseDdlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)DatabaseName.parse((String)actualRequest.getDatabase()));
        Assert.assertEquals(statements, (Object)actualRequest.getStatementsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDatabaseDdlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            ArrayList statements = new ArrayList();
            this.client.updateDatabaseDdlAsync(database, statements).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void dropDatabaseTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        this.client.dropDatabase(database);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DropDatabaseRequest actualRequest = (DropDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)DatabaseName.parse((String)actualRequest.getDatabase()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void dropDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.dropDatabase(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseDdlTest() {
        GetDatabaseDdlResponse expectedResponse = GetDatabaseDdlResponse.newBuilder().build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        GetDatabaseDdlResponse actualResponse = this.client.getDatabaseDdl(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseDdlRequest actualRequest = (GetDatabaseDdlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)DatabaseName.parse((String)actualRequest.getDatabase()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseDdlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.getDatabaseDdl(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String formattedResource = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(formattedResource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            String formattedResource = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(formattedResource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String formattedResource = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Policy actualResponse = this.client.getIamPolicy(formattedResource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            String formattedResource = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.getIamPolicy(formattedResource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String formattedResource = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(formattedResource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)exception);
        try {
            String formattedResource = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(formattedResource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

