/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.truth.Truth;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITVPCNegativeTest {
    private static final String IN_VPCSC_TEST = System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC");
    private static final String OUTSIDE_VPC_PROJECT = System.getenv("GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT");
    private Spanner spanner;
    private InstanceAdminClient instanceAdminClient;
    private DatabaseAdminClient databaseAdminClient;
    private DatabaseClient databaseClient;

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((String)"To run tests, GOOGLE_CLOUD_TESTS_IN_VPCSC environment variable needs to be set to True", (IN_VPCSC_TEST != null && IN_VPCSC_TEST.equalsIgnoreCase("true") ? 1 : 0) != 0);
        Assert.assertTrue((String)"GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT environment variable needs to be set to a GCP project that is outside the VPC perimeter", (OUTSIDE_VPC_PROJECT != null && OUTSIDE_VPC_PROJECT != "" ? 1 : 0) != 0);
    }

    @Before
    public void setUp() {
        InstanceId instanceId = InstanceId.of((String)OUTSIDE_VPC_PROJECT, (String)"nonexistent-instance");
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(instanceId.getProject())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setFailIfPoolExhausted().build()).build();
        this.spanner = (Spanner)options.getService();
        this.instanceAdminClient = this.spanner.getInstanceAdminClient();
        this.databaseAdminClient = this.spanner.getDatabaseAdminClient();
        this.databaseClient = this.spanner.getDatabaseClient(DatabaseId.of((String)OUTSIDE_VPC_PROJECT, (String)"nonexistent-instance", (String)"nonexistent-database"));
    }

    @After
    public void tearDown() {
        this.spanner.close();
    }

    private void checkExceptionForVPCError(SpannerException e) {
        Assert.assertEquals((Object)ErrorCode.PERMISSION_DENIED, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Request is prohibited by organization's policy");
    }

    @Test
    public void deniedListInstanceConfigs() {
        try {
            this.instanceAdminClient.listInstanceConfigs(new Options.ListOption[0]);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetInstanceConfig() {
        try {
            this.instanceAdminClient.getInstanceConfig("nonexistent-configs");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedListInstances() {
        try {
            this.instanceAdminClient.listInstances(new Options.ListOption[0]);
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetInstance() {
        try {
            this.instanceAdminClient.getInstance("non-existent");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedListDatabases() {
        try {
            this.databaseAdminClient.listDatabases("nonexistent-instance", new Options.ListOption[]{Options.pageSize((int)1)});
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedGetDatabase() {
        try {
            this.databaseAdminClient.getDatabase("nonexistent-instance", "nonexistent-database");
            Assert.fail((String)"Expected PERMISSION_DENIED SpannerException");
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }

    @Test
    public void deniedRead() {
        try {
            this.databaseClient.singleUse().read("nonexistent-table", KeySet.all(), Arrays.asList("nonexistent-col"), new Options.ReadOption[0]);
        }
        catch (SpannerException e) {
            this.checkExceptionForVPCError(e);
        }
    }
}

