/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdminImpl;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.ProjectName;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.threeten.bp.Duration;

@RunWith(value=Parameterized.class)
public class InstanceAdminGaxTest {
    private static final String PROJECT = "PROJECT";
    private static final StatusRuntimeException UNAVAILABLE = Status.UNAVAILABLE.withDescription("Retryable test exception.").asRuntimeException();
    private static final StatusRuntimeException FAILED_PRECONDITION = Status.FAILED_PRECONDITION.withDescription("Non-retryable test exception.").asRuntimeException();
    private static MockInstanceAdminImpl mockInstanceAdmin;
    private static Server server;
    private static Spanner spanner;
    private static InstanceAdminClient client;
    private static LocalChannelProvider channelProvider;
    @Parameterized.Parameter(value=0)
    public int exceptionAtCall;
    @Parameterized.Parameter(value=1)
    public ExceptionType exceptionType;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static Exception createDelayedInternal() {
        return new DelayedStatusRuntimeException(Status.INTERNAL.withDescription("Delayed test exception.").asRuntimeException(), 500L);
    }

    @Parameterized.Parameters(name="exception at call = {0}, exception type = {1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int exceptionAtCall : new int[]{0, 1}) {
            for (ExceptionType exceptionType : ExceptionType.values()) {
                params.add(new Object[]{exceptionAtCall, exceptionType});
            }
        }
        return params;
    }

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockInstanceAdmin = new MockInstanceAdminImpl();
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockInstanceAdmin)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() {
        server.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        mockInstanceAdmin.reset();
        final RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)200L)).setMaxRpcTimeout(Duration.ofMillis((long)200L)).setMaxAttempts(3).setTotalTimeout(Duration.ofMillis((long)1500L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.getInstanceAdminStubSettingsBuilder().applyToAllUnaryMethods(new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

            public Void apply(UnaryCallSettings.Builder<?, ?> input) {
                input.setRetrySettings(retrySettings);
                return null;
            }
        });
        builder.getInstanceAdminStubSettingsBuilder().createInstanceOperationSettings().setInitialCallSettings(builder.getInstanceAdminStubSettingsBuilder().createInstanceOperationSettings().getInitialCallSettings().toBuilder().setRetrySettings(retrySettings).build());
        builder.getInstanceAdminStubSettingsBuilder().updateInstanceOperationSettings().setInitialCallSettings(builder.getInstanceAdminStubSettingsBuilder().updateInstanceOperationSettings().getInitialCallSettings().toBuilder().setRetrySettings(retrySettings).build());
        spanner = (Spanner)builder.build().getService();
        client = spanner.getInstanceAdminClient();
    }

    @After
    public void tearDown() throws Exception {
        spanner.close();
    }

    private Exception setupException() {
        if (!this.exceptionType.isRetryable()) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(this.exceptionType.getExpectedErrorCodeWithGax()));
        }
        return this.exceptionType.getException();
    }

    @Test
    public void listInstanceConfigsTest() {
        int i;
        Exception exception = this.setupException();
        String nextPageToken = "token%d";
        ArrayList<com.google.spanner.admin.instance.v1.InstanceConfig> configs = new ArrayList<com.google.spanner.admin.instance.v1.InstanceConfig>(2);
        for (i = 0; i < 2; ++i) {
            configs.add(com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setDisplayName(String.format("TEST%d", i)).setName(String.format("projects/%s/instanceConfigs/test%d", PROJECT, i)).build());
        }
        if (this.exceptionAtCall == 0) {
            mockInstanceAdmin.addException(exception);
        }
        for (i = 0; i < 2; ++i) {
            ListInstanceConfigsResponse.Builder builder = ListInstanceConfigsResponse.newBuilder().addAllInstanceConfigs(Arrays.asList((com.google.spanner.admin.instance.v1.InstanceConfig)configs.get(i)));
            if (i < configs.size() - 1) {
                builder.setNextPageToken(String.format(nextPageToken, i));
            }
            if (this.exceptionAtCall == i + 1) {
                mockInstanceAdmin.addException(exception);
            }
            mockInstanceAdmin.addResponse((AbstractMessage)builder.build());
        }
        ProjectName parent = ProjectName.of((String)PROJECT);
        Page pagedListResponse = client.listInstanceConfigs(new Options.ListOption[0]);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)2L, (long)resources.size());
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
        ListInstanceConfigsRequest actualRequest = (ListInstanceConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
    }

    @Test
    public void getInstanceConfigTest() {
        Exception exception = this.setupException();
        for (int i = 0; i < 2; ++i) {
            InstanceConfigName name2 = InstanceConfigName.of((String)PROJECT, (String)"INSTANCE_CONFIG");
            String displayName = "displayName1615086568";
            com.google.spanner.admin.instance.v1.InstanceConfig expectedResponse = com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(name2.toString()).setDisplayName(displayName).build();
            if (this.exceptionAtCall == 0) {
                mockInstanceAdmin.addException(exception);
            }
            mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
            if (this.exceptionAtCall == 1) {
                mockInstanceAdmin.addException(exception);
            }
            InstanceConfigName name = InstanceConfigName.of((String)PROJECT, (String)"INSTANCE_CONFIG");
            InstanceConfig actualResponse = client.getInstanceConfig(name.toString());
            Assert.assertEquals((Object)displayName, (Object)actualResponse.getDisplayName());
            List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
            Assert.assertEquals((long)(i + 1), (long)actualRequests.size());
        }
    }

    @Test
    public void listInstancesTest() {
        int i;
        Exception exception = this.setupException();
        String nextPageToken = "token%d";
        ArrayList<com.google.spanner.admin.instance.v1.Instance> instances = new ArrayList<com.google.spanner.admin.instance.v1.Instance>(2);
        for (i = 0; i < 2; ++i) {
            instances.add(com.google.spanner.admin.instance.v1.Instance.newBuilder().setDisplayName(String.format("TEST%d", i)).setName(String.format("projects/%s/instances/test%d", PROJECT, i)).setConfig(String.format("projects/%s/instanceConfigs/test%d", PROJECT, i)).build());
        }
        if (this.exceptionAtCall == 0) {
            mockInstanceAdmin.addException(exception);
        }
        for (i = 0; i < 2; ++i) {
            ListInstancesResponse.Builder builder = ListInstancesResponse.newBuilder().addAllInstances(Arrays.asList((com.google.spanner.admin.instance.v1.Instance)instances.get(i)));
            if (i < instances.size() - 1) {
                builder.setNextPageToken(String.format(nextPageToken, i));
            }
            if (this.exceptionAtCall == i + 1) {
                mockInstanceAdmin.addException(exception);
            }
            mockInstanceAdmin.addResponse((AbstractMessage)builder.build());
        }
        ProjectName parent = ProjectName.of((String)PROJECT);
        Page pagedListResponse = client.listInstances(new Options.ListOption[0]);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)2L, (long)resources.size());
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
    }

    @Test
    public void getInstanceTest() {
        Exception exception = this.setupException();
        InstanceName name2 = InstanceName.of((String)PROJECT, (String)"INSTANCE");
        String displayName = "displayName1615086568";
        InstanceConfigName config = InstanceConfigName.of((String)PROJECT, (String)"INSTANCE_CONFIG");
        com.google.spanner.admin.instance.v1.Instance expectedResponse = com.google.spanner.admin.instance.v1.Instance.newBuilder().setName(name2.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(3).build();
        if (this.exceptionAtCall == 0) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        if (this.exceptionAtCall == 1) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)PROJECT, (String)"INSTANCE");
        for (int i = 0; i < 2; ++i) {
            Instance actualResponse = client.getInstance(name.toString());
            Assert.assertEquals((Object)displayName, (Object)actualResponse.getDisplayName());
        }
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
    }

    @Test
    public void createInstanceTest() throws Exception {
        Exception exception = this.setupException();
        InstanceName name = InstanceName.of((String)PROJECT, (String)"INSTANCE");
        InstanceConfigName config = InstanceConfigName.of((String)PROJECT, (String)"INSTANCE_CONFIG");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        com.google.spanner.admin.instance.v1.Instance expectedResponse = com.google.spanner.admin.instance.v1.Instance.newBuilder().setName(name.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        if (this.exceptionAtCall == 0) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        if (this.exceptionAtCall == 1) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        for (int i = 0; i < 2; ++i) {
            OperationFuture actualResponse = client.createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)PROJECT, (String)"INSTANCE")).setDisplayName(displayName).setNodeCount(nodeCount).build());
            try {
                Instance returnedInstance = (Instance)actualResponse.get();
                Assert.assertEquals((Object)displayName, (Object)returnedInstance.getDisplayName());
                continue;
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw e;
            }
        }
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
    }

    @Test
    public void updateInstanceTest() throws Exception {
        Exception exception = this.setupException();
        InstanceName name = InstanceName.of((String)PROJECT, (String)"INSTANCE");
        InstanceConfigName config = InstanceConfigName.of((String)PROJECT, (String)"INSTANCE_CONFIG");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        com.google.spanner.admin.instance.v1.Instance expectedResponse = com.google.spanner.admin.instance.v1.Instance.newBuilder().setName(name.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        if (this.exceptionAtCall == 0) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        if (this.exceptionAtCall == 1) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        for (int i = 0; i < 2; ++i) {
            OperationFuture actualResponse = client.updateInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)PROJECT, (String)"INSTANCE")).setDisplayName(displayName).setNodeCount(nodeCount).build(), new InstanceInfo.InstanceField[0]);
            try {
                Instance returnedInstance = (Instance)actualResponse.get();
                Assert.assertEquals((Object)displayName, (Object)returnedInstance.getDisplayName());
                continue;
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw e;
            }
        }
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
    }

    @Test
    public void deleteInstanceTest() {
        Exception exception = this.setupException();
        Empty expectedResponse = Empty.newBuilder().build();
        if (this.exceptionAtCall == 0) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        if (this.exceptionAtCall == 1) {
            mockInstanceAdmin.addException(exception);
        }
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        for (int i = 0; i < 2; ++i) {
            client.deleteInstance("INSTANCE");
        }
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
    }

    public static enum ExceptionType {
        RETRYABLE{

            @Override
            public Exception getException() {
                return UNAVAILABLE;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithGax() {
                return null;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithoutGax() {
                return ErrorCode.UNAVAILABLE;
            }

            @Override
            public boolean isRetryable() {
                return true;
            }
        }
        ,
        NON_RETRYABLE{

            @Override
            public Exception getException() {
                return FAILED_PRECONDITION;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithGax() {
                return ErrorCode.FAILED_PRECONDITION;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithoutGax() {
                return ErrorCode.FAILED_PRECONDITION;
            }

            @Override
            public boolean isRetryable() {
                return false;
            }
        }
        ,
        DELAYED{

            @Override
            public Exception getException() {
                return InstanceAdminGaxTest.createDelayedInternal();
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithGax() {
                return ErrorCode.DEADLINE_EXCEEDED;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithoutGax() {
                return ErrorCode.INTERNAL;
            }

            @Override
            public boolean isRetryable() {
                return true;
            }
        };


        public abstract Exception getException();

        public abstract ErrorCode getExpectedErrorCodeWithGax();

        public abstract ErrorCode getExpectedErrorCodeWithoutGax();

        public abstract boolean isRetryable();
    }

    public static class DelayedStatusRuntimeException
    extends RuntimeException {
        private final long millis;
        private boolean hasWaited = false;

        public DelayedStatusRuntimeException(StatusRuntimeException cause, long millis) {
            super(cause);
            this.millis = millis;
        }

        @Override
        public synchronized Throwable getCause() {
            if (!this.hasWaited) {
                try {
                    Thread.sleep(this.millis);
                    this.hasWaited = true;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return super.getCause();
        }
    }
}

