/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class InstanceTest {
    @Mock
    InstanceAdminClient instanceClient;
    @Mock
    DatabaseAdminClient dbClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void buildInstance() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId = new InstanceConfigId("test-project", "test-instance-config");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").build();
        Truth.assertThat((Object)instance.getId()).isEqualTo((Object)id);
        Truth.assertThat((Object)instance.getInstanceConfigId()).isEqualTo((Object)configId);
        Truth.assertThat((String)instance.getDisplayName()).isEqualTo((Object)"test instance");
        Truth.assertThat((Integer)instance.getNodeCount()).isEqualTo((Object)1);
        Truth.assertThat((Comparable)instance.getState()).isEqualTo((Object)InstanceInfo.State.READY);
        Truth.assertThat((Map)instance.getLabels()).containsExactly((Object)"env", (Object)"prod", new Object[]{"region", "us"});
        instance = instance.toBuilder().setDisplayName("new test instance").build();
        Truth.assertThat((Object)instance.getId()).isEqualTo((Object)id);
        Truth.assertThat((Object)instance.getInstanceConfigId()).isEqualTo((Object)configId);
        Truth.assertThat((String)instance.getDisplayName()).isEqualTo((Object)"new test instance");
        Truth.assertThat((Integer)instance.getNodeCount()).isEqualTo((Object)1);
        Truth.assertThat((Comparable)instance.getState()).isEqualTo((Object)InstanceInfo.State.READY);
        Truth.assertThat((Map)instance.getLabels()).containsExactly((Object)"env", (Object)"prod", new Object[]{"region", "us"});
    }

    @Test
    public void equality() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId = new InstanceConfigId("test-project", "test-instance-config");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").build();
        Instance instance2 = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setState(InstanceInfo.State.READY).addLabel("region", "us").addLabel("env", "prod").build();
        Instance instance3 = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setState(InstanceInfo.State.READY).addLabel("env", "prod").build();
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{instance, instance2});
        tester.addEqualityGroup(new Object[]{instance3});
        tester.testEquals();
    }
}

