/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.spanner.v1.KeySet;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KeySetTest {
    @Test
    public void singleKey() {
        KeySet set = KeySet.singleKey((Key)Key.of((Object[])new Object[]{"a", "b", "c"}));
        Truth.assertThat((Boolean)set.isAll()).isFalse();
        Truth.assertThat((Iterable)set.getKeys()).containsExactly(new Object[]{Key.of((Object[])new Object[]{"a", "b", "c"})});
        Truth.assertThat((Iterable)set.getRanges()).isEmpty();
    }

    @Test
    public void range() {
        KeySet set = KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"})));
        Truth.assertThat((Boolean)set.isAll()).isFalse();
        Truth.assertThat((Iterable)set.getKeys()).isEmpty();
        Truth.assertThat((Iterable)set.getRanges()).containsExactly(new Object[]{KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"}))});
    }

    @Test
    public void prefixRange() {
        KeySet set = KeySet.prefixRange((Key)Key.of((Object[])new Object[]{"a", "b"}));
        Truth.assertThat((Boolean)set.isAll()).isFalse();
        Truth.assertThat((Iterable)set.getKeys()).isEmpty();
        Truth.assertThat((Iterable)set.getRanges()).containsExactly(new Object[]{KeyRange.prefix((Key)Key.of((Object[])new Object[]{"a", "b"}))});
    }

    @Test
    public void all() {
        KeySet set = KeySet.all();
        Truth.assertThat((Boolean)set.isAll()).isTrue();
        Truth.assertThat((Iterable)set.getKeys()).isEmpty();
        Truth.assertThat((Iterable)set.getRanges()).isEmpty();
    }

    @Test
    public void builder() {
        KeySet set = KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"k1"})).addKey(Key.of((Object[])new Object[]{"k2"})).addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"r1"}), (Key)Key.of((Object[])new Object[]{"rr1"}))).addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"r2"}), (Key)Key.of((Object[])new Object[]{"rr2"}))).build();
        Truth.assertThat((Boolean)set.isAll()).isFalse();
        Truth.assertThat((Iterable)set.getKeys()).containsExactly(new Object[]{Key.of((Object[])new Object[]{"k1"}), Key.of((Object[])new Object[]{"k2"})}).inOrder();
        Truth.assertThat((Iterable)set.getRanges()).containsExactly(new Object[]{KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"r1"}), (Key)Key.of((Object[])new Object[]{"rr1"})), KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"r2"}), (Key)Key.of((Object[])new Object[]{"rr2"}))}).inOrder();
        Truth.assertThat((String)set.toString()).isEqualTo((Object)"{[k1],[k2],[[r1],[rr1]),[[r2],[rr2])}");
    }

    @Test
    public void toBuilder() {
        KeySet set = KeySet.singleKey((Key)Key.of((Object[])new Object[]{1})).toBuilder().addKey(Key.of((Object[])new Object[]{2})).build();
        Truth.assertThat((Boolean)set.isAll()).isFalse();
        Truth.assertThat((Iterable)set.getKeys()).containsExactly(new Object[]{Key.of((Object[])new Object[]{1}), Key.of((Object[])new Object[]{2})}).inOrder();
        Truth.assertThat((Iterable)set.getRanges()).isEmpty();
        set = KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"}))).toBuilder().addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"c"}), (Key)Key.of((Object[])new Object[]{"d"}))).build();
        Truth.assertThat((Boolean)set.isAll()).isFalse();
        Truth.assertThat((Iterable)set.getKeys()).isEmpty();
        Truth.assertThat((Iterable)set.getRanges()).containsExactly(new Object[]{KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"})), KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"c"}), (Key)Key.of((Object[])new Object[]{"d"}))}).inOrder();
        set = KeySet.all().toBuilder().addKey(Key.of((Object[])new Object[]{1})).build();
        Truth.assertThat((Boolean)set.isAll()).isTrue();
        Truth.assertThat((Iterable)set.getKeys()).containsExactly(new Object[]{Key.of((Object[])new Object[]{1})});
        Truth.assertThat((Iterable)set.getRanges()).isEmpty();
    }

    @Test
    public void testToString() {
        Truth.assertThat((String)KeySet.all().toString()).isEqualTo((Object)"{<all>}");
        Truth.assertThat((String)KeySet.singleKey((Key)Key.of((Object[])new Object[]{"x"})).toString()).isEqualTo((Object)"{[x]}");
        Truth.assertThat((String)KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"z"}))).toString()).isEqualTo((Object)"{[[a],[z])}");
    }

    @Test
    public void equalsAndHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{KeySet.newBuilder().build()});
        tester.addEqualityGroup(new Object[]{KeySet.all(), KeySet.newBuilder().setAll().build()});
        tester.addEqualityGroup(new Object[]{KeySet.singleKey((Key)Key.of((Object[])new Object[]{"a"})), KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"a"})).build()});
        tester.addEqualityGroup(new Object[]{KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"}))), KeySet.newBuilder().addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"}))).build()});
        tester.addEqualityGroup(new Object[]{KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{1})).addKey(Key.of((Object[])new Object[]{2})).build()});
        tester.addEqualityGroup(new Object[]{KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{2})).addKey(Key.of((Object[])new Object[]{1})).build()});
        tester.addEqualityGroup(new Object[]{KeySet.newBuilder().setAll().addKey(Key.of((Object[])new Object[]{"a"})).build()});
        tester.addEqualityGroup(new Object[]{KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"a"})).addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"}))).build()});
        tester.testEquals();
    }

    @Test
    public void serializationEmpty() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[0]));
        KeySetTest.checkProto(keySet, "keys {}");
    }

    @Test
    public void serializationSingleKeyBool() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{true}));
        KeySetTest.checkProto(keySet, "keys { values { bool_value: true } }");
    }

    @Test
    public void serializationSingleKeyInt64() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{1234L}));
        KeySetTest.checkProto(keySet, "keys { values { string_value: '1234' } }");
    }

    @Test
    public void serializationSingleKeyFloat64() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{2.0}));
        KeySetTest.checkProto(keySet, "keys { values { number_value: 2.0 } }");
    }

    @Test
    public void serializationSingleKeyString() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{"abc"}));
        KeySetTest.checkProto(keySet, "keys { values { string_value: 'abc' } }");
    }

    @Test
    public void serializationSingleKeyBytes() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{ByteArray.copyFrom((byte[])new byte[]{97})}));
        KeySetTest.checkProto(keySet, "keys { values { string_value: 'YQ==' } }");
    }

    @Test
    public void serializationSingleKeyNull() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{null}));
        KeySetTest.checkProto(keySet, "keys { values { null_value: NULL_VALUE } }");
    }

    @Test
    public void serializationSingleKeyMultiPart() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{"a", false}));
        KeySetTest.checkProto(keySet, "keys { values { string_value: 'a' } values { bool_value: false } }");
    }

    @Test
    public void serializationSingleRangeClosedOpen() {
        KeySet keySet = KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"z"})));
        KeySetTest.checkProto(keySet, "ranges { start_closed { values { string_value: 'a' } }  end_open { values { string_value: 'z' } } }");
    }

    @Test
    public void serializationSingleRangeClosedClosed() {
        KeySet keySet = KeySet.range((KeyRange)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"z"})));
        KeySetTest.checkProto(keySet, "ranges { start_closed { values { string_value: 'a' } } end_closed { values { string_value: 'z' } } }");
    }

    @Test
    public void serializationSingleRangeOpenOpen() {
        KeySet keySet = KeySet.range((KeyRange)KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"z"})));
        KeySetTest.checkProto(keySet, "ranges { start_open { values { string_value: 'a' } } end_open { values { string_value: 'z' } } }");
    }

    @Test
    public void serializationSingleRangeOpenClosed() {
        KeySet keySet = KeySet.range((KeyRange)KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"z"})));
        KeySetTest.checkProto(keySet, "ranges { start_open { values { string_value: 'a' } } end_closed { values { string_value: 'z' } } }");
    }

    @Test
    public void serializationAll() {
        KeySet keySet = KeySet.all();
        KeySetTest.checkProto(keySet, "all: true");
    }

    @Test
    public void serializationMulti() {
        KeySet keySet = KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"d", 1})).addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"m"}), (Key)Key.of((Object[])new Object[]{"p"}))).addKey(Key.of((Object[])new Object[]{"a", 1})).addRange(KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"d"}))).build();
        KeySetTest.checkProto(keySet, "keys { values { string_value: 'd' } values { string_value: '1' } } keys { values { string_value: 'a' } values { string_value:'1' } } ranges { start_closed { values { string_value: 'm' } }          end_open { values { string_value: 'p' } } } ranges { start_closed { values { string_value: 'a' } }          end_closed { values { string_value: 'd' } } }");
    }

    @Test
    public void serializationMultiWithAll() {
        KeySet keySet = KeySet.all().toBuilder().addKey(Key.of((Object[])new Object[]{"a", 1})).addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"m"}), (Key)Key.of((Object[])new Object[]{"p"}))).build();
        KeySetTest.checkProto(keySet, "keys { values { string_value: 'a' } values { string_value: '1' } } ranges { start_closed { values { string_value: 'm' } }          end_open { values { string_value: 'p' } } } all:true");
    }

    @Test
    public void javaSerialization() throws Exception {
        SerializableTester.reserializeAndAssert((Object)KeySet.all().toBuilder().addKey(Key.of((Object[])new Object[]{"a", 1})).addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"m"}), (Key)Key.of((Object[])new Object[]{"p"}))).build());
    }

    private static void checkProto(KeySet keySet, String proto) {
        KeySet.Builder builder = com.google.spanner.v1.KeySet.newBuilder();
        keySet.appendToProto(builder);
        MatcherAssert.assertThat((Object)builder.build(), SpannerMatchers.matchesProto(com.google.spanner.v1.KeySet.class, proto));
    }
}

