/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Value;
import com.google.rpc.RetryInfo;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.Partition;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.Metadata;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.threeten.bp.Instant;

public class MockSpannerServiceImpl
extends SpannerGrpc.SpannerImplBase
implements MockGrpcService {
    public static final SimulatedExecutionTime NO_EXECUTION_TIME = SimulatedExecutionTime.none();
    private final Random random = new Random();
    private double abortProbability = 0.001;
    private final Queue<Exception> exceptions = new ConcurrentLinkedQueue<Exception>();
    private final ConcurrentMap<Statement, StatementResult> statementResults = new ConcurrentHashMap<Statement, StatementResult>();
    private final ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private ConcurrentMap<String, Instant> sessionLastUsed = new ConcurrentHashMap<String, Instant>();
    private final ConcurrentMap<ByteString, Transaction> transactions = new ConcurrentHashMap<ByteString, Transaction>();
    private final ConcurrentMap<ByteString, Boolean> isPartitionedDmlTransaction = new ConcurrentHashMap<ByteString, Boolean>();
    private final ConcurrentMap<ByteString, Boolean> abortedTransactions = new ConcurrentHashMap<ByteString, Boolean>();
    private final AtomicBoolean abortNextTransaction = new AtomicBoolean();
    private final ConcurrentMap<String, AtomicLong> transactionCounters = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, List<ByteString>> partitionTokens = new ConcurrentHashMap<String, List<ByteString>>();
    private ConcurrentMap<ByteString, Instant> transactionLastUsed = new ConcurrentHashMap<ByteString, Instant>();
    private SimulatedExecutionTime beginTransactionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime commitExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime createSessionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime deleteSessionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime executeBatchDmlExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime executeSqlExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime executeStreamingSqlExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime getSessionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime listSessionsExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime partitionQueryExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime partitionReadExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime readExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime rollbackExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime streamingReadExecutionTime = NO_EXECUTION_TIME;

    private String generateSessionName(String database) {
        return String.format("%s/sessions/%s", database, UUID.randomUUID().toString());
    }

    private ByteString generateTransactionName(String session) {
        AtomicLong counter = (AtomicLong)this.transactionCounters.get(session);
        if (counter == null) {
            counter = new AtomicLong();
            this.transactionCounters.put(session, counter);
        }
        return ByteString.copyFromUtf8((String)String.format("%s/transactions/%d", session, counter.incrementAndGet()));
    }

    private ByteString generatePartitionToken(String session, ByteString transactionId) {
        ByteString token = ByteString.copyFromUtf8((String)UUID.randomUUID().toString());
        String key = this.partitionKey(session, transactionId);
        ArrayList<ByteString> tokens = (ArrayList<ByteString>)this.partitionTokens.get(key);
        if (tokens == null) {
            tokens = new ArrayList<ByteString>(5);
            this.partitionTokens.put(key, tokens);
        }
        tokens.add(token);
        return token;
    }

    private String partitionKey(String session, ByteString transactionId) {
        return String.format("%s/transactions/%s", session, transactionId.toStringUtf8());
    }

    private com.google.protobuf.Timestamp getCurrentGoogleTimestamp() {
        long current = System.currentTimeMillis();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(current);
        int nanos = (int)TimeUnit.MILLISECONDS.toNanos(current - TimeUnit.SECONDS.toMillis(seconds));
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    public void putStatementResult(StatementResult result) {
        Preconditions.checkNotNull((Object)result);
        this.statementResults.put(result.statement, result);
    }

    private StatementResult getResult(Statement statement) {
        StatementResult res = (StatementResult)this.statementResults.get(statement);
        if (res == null) {
            throw Status.INTERNAL.withDescription(String.format("There is no result registered for the statement: %s\nCall TestSpannerImpl#addStatementResult(StatementResult) before executing the statement.", statement.toString())).asRuntimeException();
        }
        return res;
    }

    public void setAbortProbability(double probability) {
        Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (Object)"Probability must be >= 0 and <= 1");
        this.abortProbability = probability;
    }

    public void abortTransaction(TransactionContext transactionContext) {
        Preconditions.checkNotNull((Object)transactionContext);
        if (transactionContext instanceof TransactionRunnerImpl.TransactionContextImpl) {
            ByteString id;
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transactionContext;
            ByteString byteString = id = impl.getTransactionSelector() == null ? null : impl.getTransactionSelector().getId();
            if (id != null) {
                this.markAbortedTransaction(id);
            }
        } else {
            throw new IllegalArgumentException("Unsupported TransactionContext type: " + transactionContext.getClass().getName());
        }
    }

    public void abortNextTransaction() {
        this.abortNextTransaction.set(true);
    }

    public void createSession(CreateSessionRequest request, StreamObserver<Session> responseObserver) {
        Preconditions.checkNotNull((Object)request.getDatabase());
        String name = this.generateSessionName(request.getDatabase());
        try {
            this.createSessionExecutionTime.simulateExecutionTime(this.exceptions);
            com.google.protobuf.Timestamp now = this.getCurrentGoogleTimestamp();
            Session session = Session.newBuilder().setCreateTime(now).setName(name).setApproximateLastUseTime(now).build();
            Session prev = this.sessions.putIfAbsent(name, session);
            if (prev == null) {
                this.sessionLastUsed.put(name, Instant.now());
                responseObserver.onNext((Object)session);
                responseObserver.onCompleted();
            } else {
                responseObserver.onError((Throwable)Status.ALREADY_EXISTS.asRuntimeException());
            }
        }
        catch (StatusRuntimeException e) {
            this.sessions.remove(name);
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable e) {
            this.sessions.remove(name);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Create session failed: " + e.getMessage()).asRuntimeException());
        }
    }

    public void getSession(GetSessionRequest request, StreamObserver<Session> responseObserver) {
        Preconditions.checkNotNull((Object)request.getName());
        try {
            this.getSessionExecutionTime.simulateExecutionTime(this.exceptions);
            Session session = (Session)this.sessions.get(request.getName());
            if (session == null) {
                this.setSessionNotFound(request.getName(), responseObserver);
            } else {
                session = session.toBuilder().setApproximateLastUseTime(this.getCurrentGoogleTimestamp()).build();
                responseObserver.onNext((Object)session);
                responseObserver.onCompleted();
            }
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private <T> void setSessionNotFound(String name, StreamObserver<T> responseObserver) {
        responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(String.format("Session not found: Session with id %s not found", name)).asRuntimeException());
    }

    public void listSessions(ListSessionsRequest request, StreamObserver<ListSessionsResponse> responseObserver) {
        try {
            this.listSessionsExecutionTime.simulateExecutionTime(this.exceptions);
            ArrayList<Session> res = new ArrayList<Session>();
            for (Session session : this.sessions.values()) {
                if (!session.getName().startsWith(request.getDatabase())) continue;
                res.add(session.toBuilder().setApproximateLastUseTime(this.getCurrentGoogleTimestamp()).build());
            }
            Collections.sort(res, new Comparator<Session>(){

                @Override
                public int compare(Session o1, Session o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            responseObserver.onNext((Object)ListSessionsResponse.newBuilder().addAllSessions(res).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void deleteSession(DeleteSessionRequest request, StreamObserver<Empty> responseObserver) {
        Preconditions.checkNotNull((Object)request.getName());
        try {
            this.deleteSessionExecutionTime.simulateExecutionTime(this.exceptions);
            Session session = (Session)this.sessions.get(request.getName());
            if (session != null) {
                try {
                    this.doDeleteSession(session);
                }
                catch (Throwable e) {
                    responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
                    return;
                }
            }
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    void doDeleteSession(Session session) {
        this.sessions.remove(session.getName());
        this.transactionCounters.remove(session.getName());
        this.sessionLastUsed.remove(session.getName());
    }

    public void executeSql(ExecuteSqlRequest request, StreamObserver<ResultSet> responseObserver) {
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.executeSqlExecutionTime.simulateExecutionTime(this.exceptions);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            this.simulateAbort(session, transactionId);
            Statement statement = this.buildStatement(request.getSql(), request.getParamTypesMap(), request.getParams());
            StatementResult result = this.getResult(statement);
            switch (result.getType()) {
                case EXCEPTION: {
                    throw result.getException();
                }
                case RESULT_SET: {
                    this.returnResultSet(result.getResultSet(), request.getTransaction(), responseObserver);
                    break;
                }
                case UPDATE_COUNT: {
                    if (this.isPartitionedDmlTransaction(transactionId)) {
                        this.commitTransaction(transactionId);
                        responseObserver.onNext((Object)ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountLowerBound(result.getUpdateCount().longValue()).build()).build());
                        break;
                    }
                    responseObserver.onNext((Object)ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(result.getUpdateCount().longValue()).build()).build());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown result type: " + (Object)((Object)result.getType()));
                }
            }
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void returnResultSet(ResultSet resultSet, TransactionSelector transactionSelector, StreamObserver<ResultSet> responseObserver) {
        Transaction transaction = this.getTemporaryTransactionOrNull(transactionSelector);
        ResultSetMetadata metadata = resultSet.getMetadata();
        metadata = metadata.toBuilder().setTransaction(transaction).build();
        resultSet = resultSet.toBuilder().setMetadata(metadata).build();
        responseObserver.onNext((Object)resultSet);
    }

    public void executeBatchDml(ExecuteBatchDmlRequest request, StreamObserver<ExecuteBatchDmlResponse> responseObserver) {
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.executeBatchDmlExecutionTime.simulateExecutionTime(this.exceptions);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            if (this.isPartitionedDmlTransaction(transactionId)) {
                throw Status.FAILED_PRECONDITION.withDescription("This transaction is a partitioned DML transaction and cannot be used for batch DML updates.").asRuntimeException();
            }
            this.simulateAbort(session, transactionId);
            ArrayList<StatementResult> results = new ArrayList<StatementResult>();
            com.google.rpc.Status status = com.google.rpc.Status.newBuilder().setCode(0).build();
            for (ExecuteBatchDmlRequest.Statement statement : request.getStatementsList()) {
                try {
                    Statement spannerStatement = this.buildStatement(statement.getSql(), statement.getParamTypesMap(), statement.getParams());
                    StatementResult res = this.getResult(spannerStatement);
                    switch (res.getType()) {
                        case EXCEPTION: {
                            throw res.getException();
                        }
                        case RESULT_SET: {
                            throw Status.INVALID_ARGUMENT.withDescription("Not a DML statement: " + statement.getSql()).asRuntimeException();
                        }
                        case UPDATE_COUNT: {
                            results.add(res);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown result type: " + (Object)((Object)res.getType()));
                        }
                    }
                }
                catch (StatusRuntimeException e) {
                    status = com.google.rpc.Status.newBuilder().setCode(e.getStatus().getCode().value()).setMessage(e.getMessage()).build();
                    break;
                }
                catch (Exception e) {
                    status = com.google.rpc.Status.newBuilder().setCode(2).setMessage(e.getMessage()).build();
                    break;
                }
            }
            ExecuteBatchDmlResponse.Builder builder = ExecuteBatchDmlResponse.newBuilder();
            for (StatementResult res : results) {
                builder.addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(res.getUpdateCount().longValue()).build()).build());
            }
            builder.setStatus(status);
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void executeStreamingSql(ExecuteSqlRequest request, StreamObserver<PartialResultSet> responseObserver) {
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            List tokens;
            this.executeStreamingSqlExecutionTime.simulateExecutionTime(this.exceptions);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            if (!(request.getPartitionToken().isEmpty() || (tokens = (List)this.partitionTokens.get(this.partitionKey(session.getName(), transactionId))) != null && tokens.contains(request.getPartitionToken()))) {
                throw Status.INVALID_ARGUMENT.withDescription(String.format("Partition token %s is not a valid token for this transaction", new Object[0])).asRuntimeException();
            }
            this.simulateAbort(session, transactionId);
            Statement statement = this.buildStatement(request.getSql(), request.getParamTypesMap(), request.getParams());
            StatementResult res = this.getResult(statement);
            switch (res.getType()) {
                case EXCEPTION: {
                    throw res.getException();
                }
                case RESULT_SET: {
                    this.returnPartialResultSet(res.getResultSet(), request.getTransaction(), responseObserver);
                    break;
                }
                case UPDATE_COUNT: {
                    boolean isPartitioned = this.isPartitionedDmlTransaction(transactionId);
                    if (isPartitioned) {
                        this.commitTransaction(transactionId);
                    }
                    this.returnPartialResultSet(session, res.getUpdateCount(), !isPartitioned, responseObserver, request.getTransaction());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown result type: " + (Object)((Object)res.getType()));
                }
            }
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause(t).asRuntimeException());
        }
    }

    private Statement buildStatement(String sql, Map<String, Type> paramTypes, com.google.protobuf.Struct params) {
        Statement.Builder builder = Statement.newBuilder((String)sql);
        block22: for (Map.Entry<String, Type> entry : paramTypes.entrySet()) {
            Value value = params.getFieldsOrThrow(entry.getKey());
            if (value.getKindCase() == Value.KindCase.NULL_VALUE) {
                switch (entry.getValue().getCode()) {
                    case ARRAY: {
                        throw new IllegalArgumentException("Array parameters not (yet) supported");
                    }
                    case BOOL: {
                        builder.bind(entry.getKey()).to((Boolean)null);
                        continue block22;
                    }
                    case BYTES: {
                        builder.bind(entry.getKey()).to((ByteArray)null);
                        continue block22;
                    }
                    case DATE: {
                        builder.bind(entry.getKey()).to((Date)null);
                        continue block22;
                    }
                    case FLOAT64: {
                        builder.bind(entry.getKey()).to((Double)null);
                        continue block22;
                    }
                    case INT64: {
                        builder.bind(entry.getKey()).to((Long)null);
                        continue block22;
                    }
                    case STRING: {
                        builder.bind(entry.getKey()).to((String)null);
                        continue block22;
                    }
                    case STRUCT: {
                        builder.bind(entry.getKey()).to((Struct)null);
                        continue block22;
                    }
                    case TIMESTAMP: {
                        builder.bind(entry.getKey()).to((Timestamp)null);
                        continue block22;
                    }
                }
                throw new IllegalArgumentException("Unknown parameter type: " + entry.getValue().getCode());
            }
            switch (entry.getValue().getCode()) {
                case ARRAY: {
                    throw new IllegalArgumentException("Array parameters not (yet) supported");
                }
                case BOOL: {
                    builder.bind(entry.getKey()).to(value.getBoolValue());
                    continue block22;
                }
                case BYTES: {
                    builder.bind(entry.getKey()).to(ByteArray.fromBase64((String)value.getStringValue()));
                    continue block22;
                }
                case DATE: {
                    builder.bind(entry.getKey()).to(Date.parseDate((String)value.getStringValue()));
                    continue block22;
                }
                case FLOAT64: {
                    builder.bind(entry.getKey()).to(value.getNumberValue());
                    continue block22;
                }
                case INT64: {
                    builder.bind(entry.getKey()).to(Long.valueOf(value.getStringValue()));
                    continue block22;
                }
                case STRING: {
                    builder.bind(entry.getKey()).to(value.getStringValue());
                    continue block22;
                }
                case STRUCT: {
                    throw new IllegalArgumentException("Struct parameters not (yet) supported");
                }
                case TIMESTAMP: {
                    continue block22;
                }
            }
            throw new IllegalArgumentException("Unknown parameter type: " + entry.getValue().getCode());
        }
        return builder.build();
    }

    private <T> void setTransactionNotFound(ByteString transactionId, StreamObserver<T> responseObserver) {
        responseObserver.onError((Throwable)Status.ABORTED.withDescription(String.format("Transaction with id %s not found and has probably been aborted", transactionId.toStringUtf8())).asRuntimeException());
    }

    private <T> void throwTransactionNotFound(ByteString transactionId) {
        throw Status.ABORTED.withDescription(String.format("Transaction with id %s not found and has probably been aborted", transactionId.toStringUtf8())).asRuntimeException();
    }

    private <T> void throwTransactionAborted(ByteString transactionId) {
        throw Status.ABORTED.withDescription(String.format("Transaction with id %s has been aborted", transactionId.toStringUtf8())).asRuntimeException();
    }

    public void read(final ReadRequest request, StreamObserver<ResultSet> responseObserver) {
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.readExecutionTime.simulateExecutionTime(this.exceptions);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            this.simulateAbort(session, transactionId);
            Iterable<String> cols = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return request.getColumnsList().iterator();
                }
            };
            StatementResult res = (StatementResult)this.statementResults.get(StatementResult.createReadStatement(request.getTable(), request.getKeySet().getAll() ? KeySet.all() : KeySet.singleKey((Key)Key.of((Object[])new Object[0])), cols));
            this.returnResultSet(res.getResultSet(), request.getTransaction(), responseObserver);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void streamingRead(final ReadRequest request, StreamObserver<PartialResultSet> responseObserver) {
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            List tokens;
            this.streamingReadExecutionTime.simulateExecutionTime(this.exceptions);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            if (!(request.getPartitionToken().isEmpty() || (tokens = (List)this.partitionTokens.get(this.partitionKey(session.getName(), transactionId))) != null && tokens.contains(request.getPartitionToken()))) {
                throw Status.INVALID_ARGUMENT.withDescription(String.format("Partition token %s is not a valid token for this transaction", new Object[0])).asRuntimeException();
            }
            this.simulateAbort(session, transactionId);
            Iterable<String> cols = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return request.getColumnsList().iterator();
                }
            };
            StatementResult res = (StatementResult)this.statementResults.get(StatementResult.createReadStatement(request.getTable(), request.getKeySet().getAll() ? KeySet.all() : KeySet.singleKey((Key)Key.of((Object[])new Object[0])), cols));
            this.returnPartialResultSet(res.getResultSet(), request.getTransaction(), responseObserver);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void returnPartialResultSet(ResultSet resultSet, TransactionSelector transactionSelector, StreamObserver<PartialResultSet> responseObserver) {
        Transaction transaction = this.getTemporaryTransactionOrNull(transactionSelector);
        ResultSetMetadata metadata = resultSet.getMetadata();
        metadata = metadata.toBuilder().setTransaction(transaction).build();
        resultSet = resultSet.toBuilder().setMetadata(metadata).build();
        PartialResultSetsIterator iterator = new PartialResultSetsIterator(resultSet);
        while (iterator.hasNext()) {
            responseObserver.onNext((Object)iterator.next());
        }
        responseObserver.onCompleted();
    }

    private void returnPartialResultSet(Session session, Long updateCount, boolean exact, StreamObserver<PartialResultSet> responseObserver, TransactionSelector transaction) {
        StructType.Field field = StructType.Field.newBuilder().setName("UPDATE_COUNT").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build();
        if (exact) {
            responseObserver.onNext((Object)PartialResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(field).build()).setTransaction(Transaction.newBuilder().setId(transaction.getId()).build()).build()).setStats(ResultSetStats.newBuilder().setRowCountExact(updateCount.longValue()).build()).build());
        } else {
            responseObserver.onNext((Object)PartialResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(field).build()).setTransaction(Transaction.newBuilder().setId(transaction.getId()).build()).build()).setStats(ResultSetStats.newBuilder().setRowCountLowerBound(updateCount.longValue()).build()).build());
        }
        responseObserver.onCompleted();
    }

    private boolean isPartitionedDmlTransaction(ByteString transactionId) {
        return transactionId != null && this.isPartitionedDmlTransaction.get(transactionId) != null && (Boolean)this.isPartitionedDmlTransaction.get(transactionId) != false;
    }

    private boolean isReadWriteTransaction(ByteString transactionId) {
        return transactionId != null && this.transactions.get(transactionId) != null && ((Transaction)this.transactions.get(transactionId)).getReadTimestamp().getSeconds() == 0L;
    }

    private ByteString getTransactionId(Session session, TransactionSelector tx) {
        ByteString transactionId = null;
        switch (tx.getSelectorCase()) {
            case SELECTOR_NOT_SET: 
            case SINGLE_USE: {
                transactionId = null;
                break;
            }
            case BEGIN: {
                transactionId = this.beginTransaction(session, tx.getBegin()).getId();
                break;
            }
            case ID: {
                Transaction transaction = (Transaction)this.transactions.get(tx.getId());
                if (transaction == null) {
                    Optional aborted = Optional.fromNullable(this.abortedTransactions.get(tx.getId()));
                    if (((Boolean)aborted.or((Object)Boolean.FALSE)).booleanValue()) {
                        this.throwTransactionAborted(tx.getId());
                        break;
                    }
                    this.throwTransactionNotFound(tx.getId());
                    break;
                }
                transactionId = transaction.getId();
                this.transactionLastUsed.put(transactionId, Instant.now());
                break;
            }
            default: {
                throw Status.UNIMPLEMENTED.asRuntimeException();
            }
        }
        return transactionId;
    }

    private Transaction getTemporaryTransactionOrNull(TransactionSelector tx) {
        switch (tx.getSelectorCase()) {
            case SELECTOR_NOT_SET: 
            case SINGLE_USE: {
                Transaction.Builder builder = Transaction.newBuilder();
                this.setReadTimestamp(tx.getSingleUse(), builder);
                return builder.build();
            }
            case BEGIN: {
                Transaction.Builder builder = Transaction.newBuilder();
                this.setReadTimestamp(tx.getBegin(), builder);
                return builder.build();
            }
            case ID: {
                return (Transaction)this.transactions.get(tx.getId());
            }
        }
        return null;
    }

    public void beginTransaction(BeginTransactionRequest request, StreamObserver<Transaction> responseObserver) {
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.beginTransactionExecutionTime.simulateExecutionTime(this.exceptions);
            Transaction transaction = this.beginTransaction(session, request.getOptions());
            responseObserver.onNext((Object)transaction);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private Transaction beginTransaction(Session session, TransactionOptions options) {
        Transaction.Builder builder = Transaction.newBuilder().setId(this.generateTransactionName(session.getName()));
        if (options != null && options.getModeCase() == TransactionOptions.ModeCase.READ_ONLY) {
            this.setReadTimestamp(options, builder);
        }
        Transaction transaction = builder.build();
        this.transactions.put(transaction.getId(), transaction);
        this.isPartitionedDmlTransaction.put(transaction.getId(), options.getModeCase() == TransactionOptions.ModeCase.PARTITIONED_DML);
        if (this.abortNextTransaction.getAndSet(false)) {
            this.markAbortedTransaction(transaction.getId());
        }
        return transaction;
    }

    private void setReadTimestamp(TransactionOptions options, Transaction.Builder builder) {
        if (options.getReadOnly().getStrong()) {
            builder.setReadTimestamp(this.getCurrentGoogleTimestamp());
        } else if (options.getReadOnly().hasReadTimestamp()) {
            builder.setReadTimestamp(options.getReadOnly().getReadTimestamp());
        } else if (options.getReadOnly().hasMinReadTimestamp()) {
            builder.setReadTimestamp(options.getReadOnly().getMinReadTimestamp());
        } else if (options.getReadOnly().hasExactStaleness() || options.getReadOnly().hasMaxStaleness()) {
            com.google.protobuf.Timestamp timestamp = this.getCurrentGoogleTimestamp();
            Duration staleness = options.getReadOnly().hasExactStaleness() ? options.getReadOnly().getExactStaleness() : options.getReadOnly().getMaxStaleness();
            long seconds = timestamp.getSeconds() - staleness.getSeconds();
            int nanos = timestamp.getNanos() - staleness.getNanos();
            if (nanos < 0) {
                --seconds;
                nanos = 1000000000 + nanos;
            }
            timestamp = com.google.protobuf.Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
            builder.setReadTimestamp(timestamp);
        }
    }

    private void simulateAbort(Session session, ByteString transactionId) {
        if (this.isReadWriteTransaction(transactionId) && this.abortProbability > this.random.nextDouble()) {
            this.rollbackTransaction(transactionId);
            RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(100).build()).build();
            Metadata.Key key = Metadata.Key.of((String)(retryInfo.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)retryInfo));
            Metadata trailers = new Metadata();
            trailers.put(key, (Object)retryInfo);
            throw Status.ABORTED.withDescription(String.format("Transaction with id %s has been aborted", transactionId.toStringUtf8())).asRuntimeException(trailers);
        }
    }

    public void commit(CommitRequest request, StreamObserver<CommitResponse> responseObserver) {
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            Transaction transaction;
            this.commitExecutionTime.simulateExecutionTime(this.exceptions);
            if (request.hasSingleUseTransaction()) {
                transaction = this.beginTransaction(session, TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance()).build());
            } else if (request.getTransactionId() != null) {
                transaction = (Transaction)this.transactions.get(request.getTransactionId());
            } else {
                responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("No transaction mode specified").asRuntimeException());
                return;
            }
            if (transaction == null) {
                this.setTransactionNotFound(request.getTransactionId(), responseObserver);
                return;
            }
            this.simulateAbort(session, request.getTransactionId());
            this.commitTransaction(transaction.getId());
            responseObserver.onNext((Object)CommitResponse.newBuilder().setCommitTimestamp(this.getCurrentGoogleTimestamp()).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void commitTransaction(ByteString transactionId) {
        this.transactions.remove(transactionId);
        this.isPartitionedDmlTransaction.remove(transactionId);
        this.transactionLastUsed.remove(transactionId);
    }

    public void rollback(RollbackRequest request, StreamObserver<Empty> responseObserver) {
        Preconditions.checkNotNull((Object)request.getTransactionId());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.rollbackExecutionTime.simulateExecutionTime(this.exceptions);
            Transaction transaction = (Transaction)this.transactions.get(request.getTransactionId());
            if (transaction != null) {
                this.rollbackTransaction(transaction.getId());
            }
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    void rollbackTransaction(ByteString transactionId) {
        this.transactions.remove(transactionId);
        this.isPartitionedDmlTransaction.remove(transactionId);
        this.transactionLastUsed.remove(transactionId);
    }

    void markAbortedTransaction(ByteString transactionId) {
        this.abortedTransactions.put(transactionId, Boolean.TRUE);
        this.transactions.remove(transactionId);
        this.isPartitionedDmlTransaction.remove(transactionId);
        this.transactionLastUsed.remove(transactionId);
    }

    public void partitionQuery(PartitionQueryRequest request, StreamObserver<PartitionResponse> responseObserver) {
        try {
            this.partitionQueryExecutionTime.simulateExecutionTime(this.exceptions);
            this.partition(request.getSession(), request.getTransaction(), responseObserver);
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void partitionRead(PartitionReadRequest request, StreamObserver<PartitionResponse> responseObserver) {
        try {
            this.partitionReadExecutionTime.simulateExecutionTime(this.exceptions);
            this.partition(request.getSession(), request.getTransaction(), responseObserver);
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void partition(String sessionName, TransactionSelector transactionSelector, StreamObserver<PartitionResponse> responseObserver) {
        Session session = (Session)this.sessions.get(sessionName);
        if (session == null) {
            this.setSessionNotFound(sessionName, responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            ByteString transactionId = this.getTransactionId(session, transactionSelector);
            responseObserver.onNext((Object)PartitionResponse.newBuilder().addPartitions(Partition.newBuilder().setPartitionToken(this.generatePartitionToken(session.getName(), transactionId)).build()).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public List<AbstractMessage> getRequests() {
        return Collections.emptyList();
    }

    public void addResponse(AbstractMessage response) {
        throw new UnsupportedOperationException();
    }

    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }

    public ServerServiceDefinition getServiceDefinition() {
        return this.bindService();
    }

    public void reset() {
        this.sessions.clear();
        this.sessionLastUsed.clear();
        this.transactions.clear();
        this.isPartitionedDmlTransaction.clear();
        this.abortedTransactions.clear();
        this.transactionCounters.clear();
        this.partitionTokens.clear();
        this.transactionLastUsed.clear();
        this.exceptions.clear();
    }

    public void removeAllExecutionTimes() {
        this.beginTransactionExecutionTime = NO_EXECUTION_TIME;
        this.commitExecutionTime = NO_EXECUTION_TIME;
        this.createSessionExecutionTime = NO_EXECUTION_TIME;
        this.deleteSessionExecutionTime = NO_EXECUTION_TIME;
        this.executeBatchDmlExecutionTime = NO_EXECUTION_TIME;
        this.executeSqlExecutionTime = NO_EXECUTION_TIME;
        this.executeStreamingSqlExecutionTime = NO_EXECUTION_TIME;
        this.getSessionExecutionTime = NO_EXECUTION_TIME;
        this.listSessionsExecutionTime = NO_EXECUTION_TIME;
        this.partitionQueryExecutionTime = NO_EXECUTION_TIME;
        this.partitionReadExecutionTime = NO_EXECUTION_TIME;
        this.readExecutionTime = NO_EXECUTION_TIME;
        this.rollbackExecutionTime = NO_EXECUTION_TIME;
        this.streamingReadExecutionTime = NO_EXECUTION_TIME;
    }

    public SimulatedExecutionTime getBeginTransactionExecutionTime() {
        return this.beginTransactionExecutionTime;
    }

    public void setBeginTransactionExecutionTime(SimulatedExecutionTime beginTransactionExecutionTime) {
        this.beginTransactionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)beginTransactionExecutionTime);
    }

    public SimulatedExecutionTime getCommitExecutionTime() {
        return this.commitExecutionTime;
    }

    public void setCommitExecutionTime(SimulatedExecutionTime commitExecutionTime) {
        this.commitExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)commitExecutionTime);
    }

    public SimulatedExecutionTime getCreateSessionExecutionTime() {
        return this.createSessionExecutionTime;
    }

    public void setCreateSessionExecutionTime(SimulatedExecutionTime createSessionExecutionTime) {
        this.createSessionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)createSessionExecutionTime);
    }

    public SimulatedExecutionTime getDeleteSessionExecutionTime() {
        return this.deleteSessionExecutionTime;
    }

    public void setDeleteSessionExecutionTime(SimulatedExecutionTime deleteSessionExecutionTime) {
        this.deleteSessionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)deleteSessionExecutionTime);
    }

    public SimulatedExecutionTime getExecuteBatchDmlExecutionTime() {
        return this.executeBatchDmlExecutionTime;
    }

    public void setExecuteBatchDmlExecutionTime(SimulatedExecutionTime executeBatchDmlExecutionTime) {
        this.executeBatchDmlExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)executeBatchDmlExecutionTime);
    }

    public SimulatedExecutionTime getExecuteSqlExecutionTime() {
        return this.executeSqlExecutionTime;
    }

    public void setExecuteSqlExecutionTime(SimulatedExecutionTime executeSqlExecutionTime) {
        this.executeSqlExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)executeSqlExecutionTime);
    }

    public SimulatedExecutionTime getExecuteStreamingSqlExecutionTime() {
        return this.executeStreamingSqlExecutionTime;
    }

    public void setExecuteStreamingSqlExecutionTime(SimulatedExecutionTime executeStreamingSqlExecutionTime) {
        this.executeStreamingSqlExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)executeStreamingSqlExecutionTime);
    }

    public SimulatedExecutionTime getGetSessionExecutionTime() {
        return this.getSessionExecutionTime;
    }

    public void setGetSessionExecutionTime(SimulatedExecutionTime getSessionExecutionTime) {
        this.getSessionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)getSessionExecutionTime);
    }

    public SimulatedExecutionTime getListSessionsExecutionTime() {
        return this.listSessionsExecutionTime;
    }

    public void setListSessionsExecutionTime(SimulatedExecutionTime listSessionsExecutionTime) {
        this.listSessionsExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)listSessionsExecutionTime);
    }

    public SimulatedExecutionTime getPartitionQueryExecutionTime() {
        return this.partitionQueryExecutionTime;
    }

    public void setPartitionQueryExecutionTime(SimulatedExecutionTime partitionQueryExecutionTime) {
        this.partitionQueryExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)partitionQueryExecutionTime);
    }

    public SimulatedExecutionTime getPartitionReadExecutionTime() {
        return this.partitionReadExecutionTime;
    }

    public void setPartitionReadExecutionTime(SimulatedExecutionTime partitionReadExecutionTime) {
        this.partitionReadExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)partitionReadExecutionTime);
    }

    public SimulatedExecutionTime getReadExecutionTime() {
        return this.readExecutionTime;
    }

    public void setReadExecutionTime(SimulatedExecutionTime readExecutionTime) {
        this.readExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)readExecutionTime);
    }

    public SimulatedExecutionTime getRollbackExecutionTime() {
        return this.rollbackExecutionTime;
    }

    public void setRollbackExecutionTime(SimulatedExecutionTime rollbackExecutionTime) {
        this.rollbackExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)rollbackExecutionTime);
    }

    public SimulatedExecutionTime getStreamingReadExecutionTime() {
        return this.streamingReadExecutionTime;
    }

    public void setStreamingReadExecutionTime(SimulatedExecutionTime streamingReadExecutionTime) {
        this.streamingReadExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)streamingReadExecutionTime);
    }

    public static class SimulatedExecutionTime {
        private static final Random RANDOM = new Random();
        private final int minimumExecutionTime;
        private final int randomExecutionTime;

        public static SimulatedExecutionTime ofMinimumAndRandomTime(int minimumExecutionTime, int randomExecutionTime) {
            return new SimulatedExecutionTime(minimumExecutionTime, randomExecutionTime);
        }

        public static SimulatedExecutionTime none() {
            return new SimulatedExecutionTime(0, 0);
        }

        private SimulatedExecutionTime(int minimum, int random) {
            Preconditions.checkArgument((minimum >= 0 ? 1 : 0) != 0, (Object)"Minimum execution time must be >= 0");
            Preconditions.checkArgument((random >= 0 ? 1 : 0) != 0, (Object)"Random execution time must be >= 0");
            this.minimumExecutionTime = minimum;
            this.randomExecutionTime = random;
        }

        private void simulateExecutionTime(Queue<Exception> exceptions) {
            SimulatedExecutionTime.checkException(exceptions);
            if (this.minimumExecutionTime > 0 || this.randomExecutionTime > 0) {
                try {
                    Thread.sleep((this.randomExecutionTime == 0 ? 0 : RANDOM.nextInt(this.randomExecutionTime)) + this.minimumExecutionTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static void checkException(Queue<Exception> exceptions) {
            Exception e = exceptions.poll();
            if (e != null) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw Status.INTERNAL.withDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException();
            }
        }
    }

    public static class StatementResult {
        private final StatementResultType type;
        private final Statement statement;
        private final Long updateCount;
        private final ResultSet resultSet;
        private final StatusRuntimeException exception;

        public static StatementResult query(Statement statement, ResultSet resultSet) {
            return new StatementResult(statement, resultSet);
        }

        public static StatementResult read(String table, KeySet keySet, Iterable<String> columns, ResultSet resultSet) {
            return new StatementResult(table, keySet, columns, resultSet);
        }

        public static StatementResult update(Statement statement, long updateCount) {
            return new StatementResult(statement, updateCount);
        }

        public static StatementResult exception(Statement statement, StatusRuntimeException exception) {
            return new StatementResult(statement, exception);
        }

        public static Statement createReadStatement(String table, KeySet keySet, Iterable<String> columns) {
            Preconditions.checkNotNull((Object)table);
            Preconditions.checkNotNull((Object)keySet);
            Preconditions.checkNotNull(columns);
            Preconditions.checkArgument((boolean)StatementResult.isValidKeySet(keySet), (Object)"Currently only KeySet.all() and KeySet.singleKey(Key.of()) are supported for read statements");
            StringBuilder builder = new StringBuilder("SELECT ");
            boolean first = true;
            for (String col : columns) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(col);
            }
            builder.append(" FROM ").append(table);
            if (keySet.isAll()) {
                builder.append(" WHERE 1=1");
            } else {
                builder.append(" WHERE ID=1");
            }
            return Statement.of((String)builder.toString());
        }

        private static boolean isValidKeySet(KeySet keySet) {
            if (keySet.isAll()) {
                return true;
            }
            int keys = 0;
            for (Key key : keySet.getKeys()) {
                ++keys;
                if (key.size() == 0) continue;
                return false;
            }
            return keys == 1;
        }

        private StatementResult(Statement statement, Long updateCount) {
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement);
            this.updateCount = (Long)Preconditions.checkNotNull((Object)updateCount);
            this.resultSet = null;
            this.exception = null;
            this.type = StatementResultType.UPDATE_COUNT;
        }

        private StatementResult(Statement statement, ResultSet resultSet) {
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement);
            this.resultSet = (ResultSet)Preconditions.checkNotNull((Object)resultSet);
            this.updateCount = null;
            this.exception = null;
            this.type = StatementResultType.RESULT_SET;
        }

        private StatementResult(String table, KeySet keySet, Iterable<String> columns, ResultSet resultSet) {
            this.statement = StatementResult.createReadStatement(table, keySet, columns);
            this.resultSet = (ResultSet)Preconditions.checkNotNull((Object)resultSet);
            this.updateCount = null;
            this.exception = null;
            this.type = StatementResultType.RESULT_SET;
        }

        private StatementResult(Statement statement, StatusRuntimeException exception) {
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement);
            this.exception = (StatusRuntimeException)Preconditions.checkNotNull((Object)exception);
            this.resultSet = null;
            this.updateCount = null;
            this.type = StatementResultType.EXCEPTION;
        }

        private StatementResultType getType() {
            return this.type;
        }

        private ResultSet getResultSet() {
            Preconditions.checkState((this.type == StatementResultType.RESULT_SET ? 1 : 0) != 0, (Object)"This statement result does not contain a result set");
            return this.resultSet;
        }

        private Long getUpdateCount() {
            Preconditions.checkState((this.type == StatementResultType.UPDATE_COUNT ? 1 : 0) != 0, (Object)"This statement result does not contain an update count");
            return this.updateCount;
        }

        private StatusRuntimeException getException() {
            Preconditions.checkState((this.type == StatementResultType.EXCEPTION ? 1 : 0) != 0, (Object)"This statement result does not contain an exception");
            return this.exception;
        }

        private static enum StatementResultType {
            RESULT_SET,
            UPDATE_COUNT,
            EXCEPTION;

        }
    }

    private static class PartialResultSetsIterator
    implements Iterator<PartialResultSet> {
        private static final int MAX_ROWS_IN_CHUNK = 1;
        private final ResultSet resultSet;
        private boolean hasNext;
        private boolean first = true;
        private int currentRow = 0;

        private PartialResultSetsIterator(ResultSet resultSet) {
            this.resultSet = resultSet;
            this.hasNext = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public PartialResultSet next() {
            PartialResultSet.Builder builder = PartialResultSet.newBuilder();
            if (this.first) {
                builder.setMetadata(this.resultSet.getMetadata());
                this.first = false;
            }
            int recordCount = 0;
            while (recordCount < 1 && this.currentRow < this.resultSet.getRowsCount()) {
                builder.addAllValues((Iterable)this.resultSet.getRows(this.currentRow).getValuesList());
                ++recordCount;
                ++this.currentRow;
            }
            this.hasNext = this.currentRow < this.resultSet.getRowsCount();
            return builder.build();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

