/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.SessionPoolOptions;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SessionPoolOptionsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter
    public int minSessions;
    @Parameterized.Parameter(value=1)
    public int maxSessions;

    @Parameterized.Parameters(name="min sessions = {0}, max sessions = {1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{1, 1});
        params.add(new Object[]{500, 600});
        params.add(new Object[]{600, 500});
        return params;
    }

    @Test
    public void setMinMaxSessions() {
        if (this.minSessions > this.maxSessions) {
            this.expectedException.expect(IllegalArgumentException.class);
        }
        SessionPoolOptions options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(this.maxSessions).build();
        TestCase.assertEquals((int)this.minSessions, (int)options.getMinSessions());
        TestCase.assertEquals((int)this.maxSessions, (int)options.getMaxSessions());
    }
}

