/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=Parameterized.class)
public class SessionPoolStressTest
extends BaseSessionPoolTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public double writeSessionsFraction;
    @Parameterized.Parameter(value=1)
    public boolean shouldBlock;
    DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    SessionPool pool;
    SessionPoolOptions options;
    Object lock = new Object();
    Random random = new Random();
    BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
    Map<String, Boolean> sessions = new HashMap<String, Boolean>();
    Map<String, Exception> closedSessions = new HashMap<String, Exception>();
    Set<String> expiredSessions = new HashSet<String>();
    SpannerImpl mockSpanner;
    int maxAliveSessions;
    int minSessionsWhenSessionClosed = Integer.MAX_VALUE;
    Exception e;

    @Parameterized.Parameters(name="write fraction = {0}, should block = {1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (double writeFraction = 0.0; writeFraction <= 1.0; writeFraction += 0.5) {
            params.add(new Object[]{writeFraction, true});
            params.add(new Object[]{writeFraction, false});
        }
        return params;
    }

    private void setupSpanner(DatabaseId db) {
        this.mockSpanner = (SpannerImpl)Mockito.mock(SpannerImpl.class);
        Mockito.when((Object)this.mockSpanner.createSession(db)).thenAnswer((Answer)new Answer<Session>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Session answer(InvocationOnMock invocation) throws Throwable {
                Object object = SessionPoolStressTest.this.lock;
                synchronized (object) {
                    SessionImpl session = SessionPoolStressTest.this.mockSession();
                    SessionPoolStressTest.this.setupSession((Session)session);
                    SessionPoolStressTest.this.sessions.put(session.getName(), false);
                    if (SessionPoolStressTest.this.sessions.size() > SessionPoolStressTest.this.maxAliveSessions) {
                        SessionPoolStressTest.this.maxAliveSessions = SessionPoolStressTest.this.sessions.size();
                    }
                    return session;
                }
            }
        });
    }

    private void setupSession(final Session session) {
        ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
        final ResultSet mockResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)session.singleUse((TimestampBound)Matchers.any(TimestampBound.class))).thenReturn((Object)mockContext);
        Mockito.when((Object)mockContext.executeQuery((Statement)Matchers.any(Statement.class), new Options.QueryOption[0])).thenAnswer((Answer)new Answer<ResultSet>(){

            public ResultSet answer(InvocationOnMock invocation) throws Throwable {
                SessionPoolStressTest.this.resetTransaction(session);
                return mockResult;
            }
        });
        Mockito.when((Object)mockResult.next()).thenReturn((Object)true);
        ((Session)Mockito.doAnswer((Answer)new Answer<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void answer(InvocationOnMock invocation) throws Throwable {
                Object object = SessionPoolStressTest.this.lock;
                synchronized (object) {
                    if (SessionPoolStressTest.this.expiredSessions.contains(session.getName())) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found");
                    }
                    if (SessionPoolStressTest.this.sessions.remove(session.getName()) == null) {
                        SessionPoolStressTest.this.setFailed(SessionPoolStressTest.this.closedSessions.get(session.getName()));
                    }
                    SessionPoolStressTest.this.closedSessions.put(session.getName(), new Exception("Session closed at:"));
                    if (SessionPoolStressTest.this.sessions.size() < SessionPoolStressTest.this.minSessionsWhenSessionClosed) {
                        SessionPoolStressTest.this.minSessionsWhenSessionClosed = SessionPoolStressTest.this.sessions.size();
                    }
                }
                return null;
            }
        }).when((Object)session)).close();
        ((Session)Mockito.doAnswer((Answer)new Answer<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void answer(InvocationOnMock invocation) throws Throwable {
                if (SessionPoolStressTest.this.random.nextInt(100) < 10) {
                    SessionPoolStressTest.this.expireSession(session);
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found");
                }
                Object object = SessionPoolStressTest.this.lock;
                synchronized (object) {
                    if (SessionPoolStressTest.this.sessions.put(session.getName(), true).booleanValue()) {
                        SessionPoolStressTest.this.setFailed();
                    }
                }
                return null;
            }
        }).when((Object)session)).prepareReadWriteTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSession(Session session) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(session.getName());
            this.expiredSessions.add(session.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertWritePrepared(Session session) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.sessions.get(session.getName()).booleanValue()) {
                this.setFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTransaction(Session session) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.put(session.getName(), false);
        }
    }

    private void setFailed(Exception cause) {
        this.e = new Exception(cause);
    }

    private void setFailed() {
        this.e = new Exception();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception getFailedError() {
        Object object = this.lock;
        synchronized (object) {
            return this.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stressTest() throws Exception {
        int concurrentThreads = 10;
        int numOperationsPerThread = 1000;
        final CountDownLatch releaseThreads = new CountDownLatch(1);
        final CountDownLatch threadsDone = new CountDownLatch(concurrentThreads);
        int writeOperationFraction = 5;
        this.setupSpanner(this.db);
        int minSessions = 2;
        int maxSessions = concurrentThreads / 2;
        float writeSessionsFraction = 0.5f;
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder().setMinSessions(minSessions).setMaxSessions(maxSessions).setWriteSessionsFraction(writeSessionsFraction);
        if (this.shouldBlock) {
            builder.setBlockIfPoolExhausted();
        } else {
            builder.setFailIfPoolExhausted();
        }
        this.pool = SessionPool.createPool((SessionPoolOptions)builder.build(), (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(), (DatabaseId)this.db, (SpannerImpl)this.mockSpanner, (SessionPool.Clock)this.clock);
        for (int i = 0; i < concurrentThreads; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)releaseThreads);
                    for (int j = 0; j < 1000; ++j) {
                        try {
                            SessionPool.PooledSession session = null;
                            if (SessionPoolStressTest.this.random.nextInt(10) < 5) {
                                session = SessionPoolStressTest.this.pool.getReadWriteSession();
                                SessionPoolStressTest.this.assertWritePrepared((Session)session);
                            } else {
                                session = SessionPoolStressTest.this.pool.getReadSession();
                            }
                            Uninterruptibles.sleepUninterruptibly((long)SessionPoolStressTest.this.random.nextInt(5), (TimeUnit)TimeUnit.MILLISECONDS);
                            SessionPoolStressTest.this.resetTransaction((Session)session);
                            session.close();
                            continue;
                        }
                        catch (SpannerException e) {
                            if (e.getErrorCode() == ErrorCode.RESOURCE_EXHAUSTED && !SessionPoolStressTest.this.shouldBlock) continue;
                            SessionPoolStressTest.this.setFailed((Exception)((Object)e));
                            continue;
                        }
                        catch (Exception e) {
                            SessionPoolStressTest.this.setFailed(e);
                        }
                    }
                    threadsDone.countDown();
                }
            }).start();
        }
        final AtomicBoolean stopMaintenance = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopMaintenance.get()) {
                    SessionPoolStressTest.this.runMaintainanceLoop(SessionPoolStressTest.this.clock, SessionPoolStressTest.this.pool, 1L);
                }
            }
        }).start();
        releaseThreads.countDown();
        threadsDone.await();
        Object object = this.lock;
        synchronized (object) {
            Truth.assertThat((Integer)this.maxAliveSessions).isAtMost((Comparable)Integer.valueOf(maxSessions));
        }
        this.pool.closeAsync().get();
        Exception e = this.getFailedError();
        if (e != null) {
            throw e;
        }
    }
}

