/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.truth.Truth;
import io.grpc.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITReadTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME = "TestTable";
    private static final String INDEX_NAME = "TestTableByValue";
    private static final String DESC_INDEX_NAME = "TestTableByValueDesc";
    private static final List<String> ALL_COLUMNS = Arrays.asList("Key", "StringValue");
    private static final Type TABLE_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"Key", (Type)Type.string()), Type.StructField.of((String)"StringValue", (Type)Type.string())});
    private static Database db;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static DatabaseClient client;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable (  Key                STRING(MAX) NOT NULL,  StringValue        STRING(MAX),) PRIMARY KEY (Key)", "CREATE INDEX TestTableByValue ON TestTable(StringValue)", "CREATE INDEX TestTableByValueDesc ON TestTable(StringValue DESC)"});
        client = env.getTestHelper().getDatabaseClient(db);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 15; ++i) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k" + i)).set("StringValue").to("v" + i)).build());
        }
        client.write(mutations);
    }

    @Test
    public void emptyRead() {
        ResultSet resultSet = client.singleUse(TimestampBound.strong()).read(TABLE_NAME, KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k99"}), (Key)Key.of((Object[])new Object[]{"z"}))), ALL_COLUMNS, new Options.ReadOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)TABLE_TYPE);
    }

    @Test
    public void indexEmptyRead() {
        ResultSet resultSet = client.singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, INDEX_NAME, KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v99"}), (Key)Key.of((Object[])new Object[]{"z"}))), ALL_COLUMNS, new Options.ReadOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)TABLE_TYPE);
    }

    @Test
    public void pointRead() {
        Struct row = client.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)row.getString(1)).isEqualTo((Object)"v1");
        Truth.assertThat((Object)row).isEqualTo((Object)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("Key").to("k1")).set("StringValue").to("v1")).build());
    }

    @Test
    public void indexPointRead() {
        Struct row = client.singleUse(TimestampBound.strong()).readRowUsingIndex(TABLE_NAME, INDEX_NAME, Key.of((Object[])new Object[]{"v1"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNotNull();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)row.getString(1)).isEqualTo((Object)"v1");
    }

    @Test
    public void pointReadNotFound() {
        Struct row = client.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k999"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNull();
    }

    @Test
    public void indexPointReadNotFound() {
        Struct row = client.singleUse(TimestampBound.strong()).readRowUsingIndex(TABLE_NAME, INDEX_NAME, Key.of((Object[])new Object[]{"v999"}), ALL_COLUMNS);
        Truth.assertThat((Object)row).isNull();
    }

    @Test
    public void rangeReads() {
        this.checkRange(Source.BASE_TABLE, KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k1"})), 1);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 3, 4);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 3, 4, 5);
        this.checkRange(Source.BASE_TABLE, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 4, 5);
        this.checkRange(Source.BASE_TABLE, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k5"})), 4);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), 7, 8, 9);
        this.checkRange(Source.BASE_TABLE, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), 8, 9);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), 0, 1, 10);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), 0, 1, 10, 11);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"k7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.openOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.openClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"k11"})), new int[0]);
        this.checkRange(Source.BASE_TABLE, KeyRange.prefix((Key)Key.of((Object[])new Object[]{"k1"})), 1);
        this.checkRange(Source.BASE_TABLE, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"k1"}), (Key)Key.of((Object[])new Object[]{"k2"})), 1, 10, 11, 12, 13, 14);
        this.checkRange(Source.BASE_TABLE, KeySet.all(), 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
    }

    @Test
    public void limitRead() {
        this.checkRangeWithLimit(Source.BASE_TABLE, 2L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k7"})), 3, 4);
        this.checkRangeWithLimit(Source.BASE_TABLE, 0L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"k3"}), (Key)Key.of((Object[])new Object[]{"k7"})), 3, 4, 5, 6, 7);
    }

    @Test
    public void indexRangeReads() {
        this.checkRange(Source.INDEX, KeySet.singleKey((Key)Key.of((Object[])new Object[]{"v1"})), 1);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 3, 4);
        this.checkRange(Source.INDEX, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 3, 4, 5);
        this.checkRange(Source.INDEX, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 4, 5);
        this.checkRange(Source.INDEX, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v5"})), 4);
        this.checkRange(Source.INDEX, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), 7, 8, 9);
        this.checkRange(Source.INDEX, KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), 8, 9);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), 0, 1, 10);
        this.checkRange(Source.INDEX, KeyRange.closedClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), 0, 1, 10, 11);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[0])), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.openOpen((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.openClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[]{"v11"})), new int[0]);
        this.checkRange(Source.INDEX, KeyRange.prefix((Key)Key.of((Object[])new Object[]{"v1"})), 1);
        this.checkRange(Source.INDEX, KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"v1"}), (Key)Key.of((Object[])new Object[]{"v2"})), 1, 10, 11, 12, 13, 14);
        this.checkRange(Source.INDEX, KeySet.all(), 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.checkRange(Source.DESC_INDEX, KeySet.all(), 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0);
    }

    @Test
    public void limitReadUsingIndex() {
        this.checkRangeWithLimit(Source.INDEX, 2L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v3"}), (Key)Key.of((Object[])new Object[]{"v7"})), 3, 4);
        this.checkRangeWithLimit(Source.DESC_INDEX, 2L, KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"v7"}), (Key)Key.of((Object[])new Object[]{"v3"})), 7, 6);
    }

    @Test
    public void multiPointRead() {
        KeySet keys = KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"k3"})).addKey(Key.of((Object[])new Object[]{"k5"})).addKey(Key.of((Object[])new Object[]{"k7"})).build();
        this.checkRange(Source.BASE_TABLE, keys, 3, 5, 7);
    }

    @Test
    public void indexMultiPointRead() {
        KeySet keys = KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"v3"})).addKey(Key.of((Object[])new Object[]{"v5"})).addKey(Key.of((Object[])new Object[]{"v7"})).build();
        this.checkRange(Source.INDEX, keys, 3, 5, 7);
    }

    @Test
    public void rowsAreSnapshots() {
        ArrayList<Struct> rows = new ArrayList<Struct>();
        ResultSet resultSet = client.singleUse(TimestampBound.strong()).read(TABLE_NAME, KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{"k2"})).addKey(Key.of((Object[])new Object[]{"k3"})).addKey(Key.of((Object[])new Object[]{"k4"})).build(), ALL_COLUMNS, new Options.ReadOption[0]);
        while (resultSet.next()) {
            rows.add(resultSet.getCurrentRowAsStruct());
        }
        Truth.assertThat((Integer)rows.size()).isEqualTo((Object)3);
        Truth.assertThat((String)((Struct)rows.get(0)).getString(0)).isEqualTo((Object)"k2");
        Truth.assertThat((String)((Struct)rows.get(0)).getString(1)).isEqualTo((Object)"v2");
        Truth.assertThat((String)((Struct)rows.get(1)).getString(0)).isEqualTo((Object)"k3");
        Truth.assertThat((String)((Struct)rows.get(1)).getString(1)).isEqualTo((Object)"v3");
        Truth.assertThat((String)((Struct)rows.get(2)).getString(0)).isEqualTo((Object)"k4");
        Truth.assertThat((String)((Struct)rows.get(2)).getString(1)).isEqualTo((Object)"v4");
    }

    @Test
    public void invalidDatabase() {
        RemoteSpannerHelper helper = env.getTestHelper();
        DatabaseClient invalidClient = helper.getClient().getDatabaseClient(DatabaseId.of((InstanceId)helper.getInstanceId(), (String)"invalid"));
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        invalidClient.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k99"}), ALL_COLUMNS);
    }

    @Test
    public void tableNotFound() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        this.expectedException.expectMessage("BadTableName");
        client.singleUse(TimestampBound.strong()).readRow("BadTableName", Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
    }

    @Test
    public void columnNotFound() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        this.expectedException.expectMessage("BadColumnName");
        client.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), Arrays.asList("Key", "BadColumnName"));
    }

    @Test
    public void cursorErrorDeferred() {
        ResultSet resultSet = client.singleUse(TimestampBound.strong()).read("BadTableName", KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k1"})), ALL_COLUMNS, new Options.ReadOption[0]);
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        this.expectedException.expectMessage("BadTableName");
        resultSet.next();
    }

    @Test
    public void cancellation() {
        Context.CancellableContext context = Context.current().withCancellation();
        Runnable work = context.wrap(new Runnable(){

            @Override
            public void run() {
                client.singleUse(TimestampBound.strong()).readRow(ITReadTest.TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), (Iterable)ALL_COLUMNS);
            }
        });
        context.cancel((Throwable)new RuntimeException("Cancelled by test"));
        try {
            work.run();
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.CANCELLED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deadline() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Context.CancellableContext context = Context.current().withDeadlineAfter(10L, TimeUnit.NANOSECONDS, executor);
        Runnable work = context.wrap(new Runnable(){

            @Override
            public void run() {
                client.singleUse(TimestampBound.strong()).readRow(ITReadTest.TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), (Iterable)ALL_COLUMNS);
            }
        });
        try {
            work.run();
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        finally {
            executor.shutdown();
        }
    }

    private void checkReadRange(Source source, KeySet keySet, long limit, int[] expectedRows) {
        ResultSet resultSet;
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        for (int expectedRow : expectedRows) {
            expected.put("k" + expectedRow, "v" + expectedRow);
        }
        switch (source) {
            case INDEX: {
                resultSet = limit != 0L ? client.singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[]{Options.limit((long)limit)}) : client.singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[0]);
                break;
            }
            case DESC_INDEX: {
                resultSet = limit != 0L ? client.singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, DESC_INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[]{Options.limit((long)limit)}) : client.singleUse(TimestampBound.strong()).readUsingIndex(TABLE_NAME, DESC_INDEX_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[0]);
                break;
            }
            case BASE_TABLE: {
                resultSet = limit != 0L ? client.singleUse(TimestampBound.strong()).read(TABLE_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[]{Options.limit((long)limit)}) : client.singleUse(TimestampBound.strong()).read(TABLE_NAME, keySet, ALL_COLUMNS, new Options.ReadOption[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid source");
            }
        }
        LinkedHashMap<String, String> rows = new LinkedHashMap<String, String>();
        while (resultSet.next()) {
            rows.put(resultSet.getString(0), resultSet.getString(1));
        }
        Truth.assertWithMessage((String)("read of " + keySet)).that(rows).isEqualTo(expected);
    }

    private void checkRange(Source source, KeyRange range, int ... expectedRows) {
        this.checkRange(source, KeySet.range((KeyRange)range), expectedRows);
    }

    private void checkRange(Source source, KeySet keySet, int ... expectedRows) {
        this.checkReadRange(source, keySet, 0L, expectedRows);
    }

    private void checkRangeWithLimit(Source source, long limit, KeyRange range, int ... expectedRows) {
        this.checkReadRange(source, KeySet.range((KeyRange)range), limit, expectedRows);
    }

    private static enum Source {
        BASE_TABLE,
        INDEX,
        DESC_INDEX;

    }
}

