/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Value;
import com.google.common.truth.Truth;
import io.grpc.Context;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITWriteTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    private static int seq;
    private static DatabaseClient client;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private String lastKey;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K                   STRING(MAX) NOT NULL,  BoolValue           BOOL,  Int64Value          INT64,  Float64Value        FLOAT64,  StringValue         STRING(MAX),  BytesValue          BYTES(MAX),  TimestampValue      TIMESTAMP OPTIONS (allow_commit_timestamp = true),  DateValue           DATE,  BoolArrayValue      ARRAY<BOOL>,  Int64ArrayValue     ARRAY<INT64>,  Float64ArrayValue   ARRAY<FLOAT64>,  StringArrayValue    ARRAY<STRING(MAX)>,  BytesArrayValue     ARRAY<BYTES(MAX)>,  TimestampArrayValue ARRAY<TIMESTAMP>,  DateArrayValue      ARRAY<DATE>,) PRIMARY KEY (K)"});
        client = env.getTestHelper().getDatabaseClient(db);
    }

    private static String uniqueString() {
        return String.format("k%04d", seq++);
    }

    private Timestamp write(Mutation m) {
        return client.write(Arrays.asList(m));
    }

    private Mutation.WriteBuilder baseInsert() {
        this.lastKey = ITWriteTest.uniqueString();
        return (Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(this.lastKey);
    }

    private Struct readLastRow(String ... columns) {
        return client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{this.lastKey}), Arrays.asList(columns));
    }

    @Test
    public void writeAtLeastOnce() {
        Mutation[] mutationArray = new Mutation[1];
        this.lastKey = ITWriteTest.uniqueString();
        mutationArray[0] = ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(this.lastKey)).set("StringValue").to("v1")).build();
        client.writeAtLeastOnce(Arrays.asList(mutationArray));
        Struct row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"v1");
    }

    @Ignore
    @Test
    public void emptyWrite() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INVALID_ARGUMENT));
        client.write(Arrays.asList(new Mutation[0]));
    }

    @Test
    public void writeBool() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolValue").to(true)).build());
        Struct row = this.readLastRow("BoolValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Boolean)row.getBoolean(0)).isTrue();
    }

    @Test
    public void writeBoolNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolValue").to((Boolean)null)).build());
        Struct row = this.readLastRow("BoolValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeInt64() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64Value").to(1234L)).build());
        Struct row = this.readLastRow("Int64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1234L);
    }

    @Test
    public void writeInt64Null() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64Value").to((Long)null)).build());
        Struct row = this.readLastRow("Int64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeFloat64() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(2.0)).build());
        Struct row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isWithin(0.0).of(2.0);
    }

    @Test
    public void writeFloat64NonNumbers() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(Double.NEGATIVE_INFINITY)).build());
        Struct row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isNegativeInfinity();
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(Double.POSITIVE_INFINITY)).build());
        row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isPositiveInfinity();
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to(Double.NaN)).build());
        row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isNaN();
    }

    @Test
    public void writeFloat64Null() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64Value").to((Double)null)).build());
        Struct row = this.readLastRow("Float64Value");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeString() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringValue").to("V1")).build());
        Struct row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"V1");
    }

    @Test
    public void writeStringNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringValue").to((String)null)).build());
        Struct row = this.readLastRow("StringValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeBytes() {
        ByteArray data = ByteArray.copyFrom((String)"V1");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesValue").to(data)).build());
        Struct row = this.readLastRow("BytesValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytes(0)).isEqualTo((Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeBytesRandom() {
        Random rnd = new Random();
        long seed = rnd.nextLong();
        rnd.setSeed(seed);
        HashMap<String, ByteArray> expected = new HashMap<String, ByteArray>();
        boolean pass = false;
        try {
            for (int length : new int[]{1, 2, 5, 11}) {
                byte[] data = new byte[length];
                for (int i = 0; i < 3; ++i) {
                    rnd.nextBytes(data);
                    String key = ITWriteTest.uniqueString();
                    ByteArray value = ByteArray.copyFrom((byte[])data);
                    expected.put(key, value);
                    this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(key)).set("BytesValue").to(value)).build());
                }
            }
            KeySet.Builder keys = KeySet.newBuilder();
            for (String key : expected.keySet()) {
                keys.addKey(Key.of((Object[])new Object[]{key}));
            }
            ResultSet resultSet = client.singleUse(TimestampBound.strong()).read("T", keys.build(), Arrays.asList("K", "BytesValue"), new Options.ReadOption[0]);
            while (resultSet.next()) {
                String key = resultSet.getString(0);
                ByteArray value = resultSet.getBytes(1);
                Truth.assertThat(expected).containsKey((Object)key);
                ByteArray expectedValue = (ByteArray)expected.remove(key);
                Truth.assertThat((Iterable)value).isEqualTo((Object)expectedValue);
            }
            Truth.assertThat(expected).isEmpty();
            pass = true;
        }
        finally {
            if (!pass) {
                System.out.println("To reproduce failure, use seed " + seed);
            }
        }
    }

    @Test
    public void writeBytesNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesValue").to((ByteArray)null)).build());
        Struct row = this.readLastRow("BytesValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeTimestamp() {
        Timestamp timestamp = Timestamp.parseTimestamp((String)"2016-09-15T00:00:00.111111Z");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampValue").to(timestamp)).build());
        Struct row = this.readLastRow("TimestampValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Comparable)row.getTimestamp(0)).isEqualTo((Object)timestamp);
    }

    @Test
    public void writeTimestampNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampValue").to((Timestamp)null)).build());
        Struct row = this.readLastRow("TimestampValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeCommitTimestamp() {
        Timestamp commitTimestamp = this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampValue").to(Value.COMMIT_TIMESTAMP)).build());
        Struct row = this.readLastRow("TimestampValue");
        Truth.assertThat((Comparable)row.getTimestamp(0)).isEqualTo((Object)commitTimestamp);
    }

    @Test
    public void writeDate() {
        Date date = Date.parseDate((String)"2016-09-15");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateValue").to(date)).build());
        Struct row = this.readLastRow("DateValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Comparable)row.getDate(0)).isEqualTo((Object)date);
    }

    @Test
    public void writeDateNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateValue").to((Date)null)).build());
        Struct row = this.readLastRow("DateValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeBoolArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray((boolean[])null)).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeBoolArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray(new boolean[0])).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBooleanList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeBoolArray() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray(Arrays.asList(true, null, false))).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBooleanList(0)).containsExactly(new Object[]{true, null, false}).inOrder();
        this.expectedException.expect(NullPointerException.class);
        row.getBooleanArray(0);
    }

    @Test
    public void writeBoolArrayNoNulls() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BoolArrayValue").toBoolArray(Arrays.asList(true, false))).build());
        Struct row = this.readLastRow("BoolArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((boolean[])row.getBooleanArray(0)).isEqualTo((Object)new boolean[]{true, false});
    }

    @Test
    public void writeInt64ArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array((long[])null)).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeInt64ArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array(new long[0])).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getLongList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeInt64Array() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array(Arrays.asList(1L, 2L, null))).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getLongList(0)).containsExactly(new Object[]{1L, 2L, null}).inOrder();
        this.expectedException.expect(NullPointerException.class);
        row.getLongArray(0);
    }

    @Test
    public void writeInt64ArrayNoNulls() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Int64ArrayValue").toInt64Array(Arrays.asList(1L, 2L))).build());
        Struct row = this.readLastRow("Int64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((long[])row.getLongArray(0)).isEqualTo((Object)new long[]{1L, 2L});
    }

    @Test
    public void writeFloat64ArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array((double[])null)).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeFloat64ArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array(new double[0])).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDoubleList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeFloat64Array() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array(Arrays.asList(null, 1.0, 2.0))).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDoubleList(0)).containsExactly(new Object[]{null, 1.0, 2.0}).inOrder();
        this.expectedException.expect(NullPointerException.class);
        row.getDoubleArray(0);
    }

    @Test
    public void writeFloat64ArrayNoNulls() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("Float64ArrayValue").toFloat64Array(Arrays.asList(1.0, 2.0))).build());
        Struct row = this.readLastRow("Float64ArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Integer)row.getDoubleArray(0).length).isEqualTo((Object)2);
        Truth.assertThat((Double)row.getDoubleArray(0)[0]).isWithin(0.0).of(1.0);
        Truth.assertThat((Double)row.getDoubleArray(0)[1]).isWithin(0.0).of(2.0);
    }

    @Test
    public void writeStringArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringArrayValue").toStringArray(null)).build());
        Struct row = this.readLastRow("StringArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeStringArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringArrayValue").toStringArray(Arrays.asList(new String[0]))).build());
        Struct row = this.readLastRow("StringArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeStringArray() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringArrayValue").toStringArray(Arrays.asList("a", null, "b"))).build());
        Struct row = this.readLastRow("StringArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[]{"a", null, "b"}).inOrder();
    }

    @Test
    public void writeBytesArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesArrayValue").toBytesArray(null)).build());
        Struct row = this.readLastRow("BytesArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeBytesArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesArrayValue").toBytesArray(Arrays.asList(new ByteArray[0]))).build());
        Struct row = this.readLastRow("BytesArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytesList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeBytesArray() {
        List<ByteArray> data = Arrays.asList(ByteArray.copyFrom((String)"a"), ByteArray.copyFrom((String)"b"), null);
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("BytesArrayValue").toBytesArray(data)).build());
        Struct row = this.readLastRow("BytesArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytesList(0)).isEqualTo(data);
    }

    @Test
    public void writeTimestampArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampArrayValue").toTimestampArray(null)).build());
        Struct row = this.readLastRow("TimestampArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeTimestampArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampArrayValue").toTimestampArray(Arrays.asList(new Timestamp[0]))).build());
        Struct row = this.readLastRow("TimestampArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getTimestampList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeTimestampArray() {
        Timestamp t1 = Timestamp.parseTimestamp((String)"2016-09-18T00:00:00Z");
        Timestamp t2 = Timestamp.parseTimestamp((String)"2016-09-19T00:00:00Z");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("TimestampArrayValue").toTimestampArray(Arrays.asList(t1, null, t2))).build());
        Struct row = this.readLastRow("TimestampArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getTimestampList(0)).containsExactly(new Object[]{t1, null, t2}).inOrder();
    }

    @Test
    public void writeDateArrayNull() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateArrayValue").toDateArray(null)).build());
        Struct row = this.readLastRow("DateArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void writeDateArrayEmpty() {
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateArrayValue").toDateArray(Arrays.asList(new Date[0]))).build());
        Struct row = this.readLastRow("DateArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDateList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void writeDateArray() {
        Date d1 = Date.parseDate((String)"2016-09-18");
        Date d2 = Date.parseDate((String)"2016-09-19");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("DateArrayValue").toDateArray(Arrays.asList(d1, null, d2))).build());
        Struct row = this.readLastRow("DateArrayValue");
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDateList(0)).containsExactly(new Object[]{d1, null, d2}).inOrder();
    }

    @Test
    public void tableNotFound() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TableThatDoesNotExist").set("K").to(ITWriteTest.uniqueString())).set("StringuniqueString(Value").to("V1")).build());
    }

    @Test
    public void columnNotFound() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("ColumnThatDoesNotExist").to("V1")).build());
    }

    @Test
    public void incorrectType() {
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.FAILED_PRECONDITION));
        this.expectedException.expectMessage("Expected STRING");
        this.write(((Mutation.WriteBuilder)this.baseInsert().set("StringValue").to(1.234)).build());
    }

    @Test
    public void cancellation() {
        Context.CancellableContext context = Context.current().withCancellation();
        context.cancel((Throwable)new RuntimeException("Cancelled by test"));
        Runnable work = context.wrap(new Runnable(){

            @Override
            public void run() {
                ITWriteTest.this.write(((Mutation.WriteBuilder)ITWriteTest.this.baseInsert().set("BoolValue").to(true)).build());
            }
        });
        try {
            work.run();
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.CANCELLED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deadline() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Context.CancellableContext context = Context.current().withDeadlineAfter(10L, TimeUnit.NANOSECONDS, executor);
        Runnable work = context.wrap(new Runnable(){

            @Override
            public void run() {
                ITWriteTest.this.write(((Mutation.WriteBuilder)ITWriteTest.this.baseInsert().set("BoolValue").to(true)).build());
            }
        });
        try {
            work.run();
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)((Object)e), SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        }
        finally {
            executor.shutdown();
        }
    }
}

