/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class DatabaseClientImplTest {
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static Spanner spanner;
    private static final Statement UPDATE_STATEMENT;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private static final Statement SELECT1;
    private static final ResultSetMetadata SELECT1_METADATA;
    private static final ResultSet SELECT1_RESULTSET;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() throws IOException {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
    }

    @After
    public void tearDown() throws Exception {
        spanner.close();
    }

    @Test
    public void testExecutePartitionedDml() {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT);
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void testExecutePartitionedDmlAborted() {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        mockSpanner.abortNextTransaction();
        long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT);
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExecutePartitionedDmlWithQuery() {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        client.executePartitionedUpdate(SELECT1);
    }

    @Test(expected=SpannerException.class)
    public void testExecutePartitionedDmlWithException() {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        client.executePartitionedUpdate(INVALID_UPDATE_STATEMENT);
    }

    @Test
    public void testPartitionedDmlDoesNotTimeout() throws Exception {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)1L)).setMaxRpcTimeout(Duration.ofMillis((long)1L)).setMaxAttempts(1).setTotalTimeout(Duration.ofMillis((long)1L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.getSpannerStubSettingsBuilder().executeSqlSettings().setRetrySettings(retrySettings);
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            Assert.assertThat((Object)((SpannerOptions)spanner.getOptions()).getPartitionedDmlTimeout(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofHours((long)2L))));
            long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT);
            Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            try {
                client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                    public Void run(TransactionContext transaction) throws Exception {
                        transaction.executeUpdate(UPDATE_STATEMENT);
                        return null;
                    }
                });
                Assert.fail((String)"expected DEADLINE_EXCEEDED");
            }
            catch (SpannerException e) {
                if (e.getErrorCode() != ErrorCode.DEADLINE_EXCEEDED) {
                    Assert.fail((String)"expected DEADLINE_EXCEEDED");
                }
            }
        }
    }

    @Test
    public void testPartitionedDmlWithTimeout() throws Exception {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setPartitionedDmlTimeout(Duration.ofMillis((long)1L));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client;
            block14: {
                client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
                Assert.assertThat((Object)((SpannerOptions)spanner.getOptions()).getPartitionedDmlTimeout(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Duration.ofMillis((long)1L))));
                try {
                    client.executePartitionedUpdate(UPDATE_STATEMENT);
                    Assert.fail((String)"expected DEADLINE_EXCEEDED");
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED) break block14;
                    Assert.fail((String)"expected DEADLINE_EXCEEDED");
                }
            }
            long updateCount = (Long)client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

                public Long run(TransactionContext transaction) throws Exception {
                    return transaction.executeUpdate(UPDATE_STATEMENT);
                }
            });
            Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
        SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
        SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    }
}

