/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TestEnvConfig;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.ExternalResource;

public class IntegrationTestEnv
extends ExternalResource {
    public static final String TEST_ENV_CONFIG_CLASS_NAME = "spanner.testenv.config.class";
    public static final String TEST_INSTANCE_PROPERTY = "spanner.testenv.instance";
    private static final Logger logger = Logger.getLogger(IntegrationTestEnv.class.getName());
    private TestEnvConfig config;
    private InstanceAdminClient instanceAdminClient;
    private boolean isOwnedInstance;
    private RemoteSpannerHelper testHelper;

    public RemoteSpannerHelper getTestHelper() {
        this.checkInitialized();
        return this.testHelper;
    }

    protected void initializeConfig() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String configClassName = System.getProperty(TEST_ENV_CONFIG_CLASS_NAME, null);
        if (configClassName == null) {
            throw new NullPointerException("Property spanner.testenv.config.class needs to be set");
        }
        Class<?> configClass = Class.forName(configClassName);
        this.config = (TestEnvConfig)configClass.newInstance();
    }

    protected void before() throws Throwable {
        InstanceId instanceId;
        this.initializeConfig();
        this.config.setUp();
        SpannerOptions options = this.config.spannerOptions();
        String instanceProperty = System.getProperty(TEST_INSTANCE_PROPERTY, "");
        if (!instanceProperty.isEmpty()) {
            instanceId = InstanceId.of((String)instanceProperty);
            this.isOwnedInstance = false;
            logger.log(Level.INFO, "Using existing test instance: {0}", instanceId);
        } else {
            instanceId = InstanceId.of((String)this.config.spannerOptions().getProjectId(), (String)"test-instance");
            this.isOwnedInstance = true;
        }
        this.testHelper = this.createTestHelper(options, instanceId);
        this.instanceAdminClient = this.testHelper.getClient().getInstanceAdminClient();
        logger.log(Level.FINE, "Test env endpoint is {0}", options.getHost());
        if (this.isOwnedInstance) {
            this.initializeInstance(instanceId);
        }
    }

    RemoteSpannerHelper createTestHelper(SpannerOptions options, InstanceId instanceId) throws Throwable {
        return RemoteSpannerHelper.create((SpannerOptions)options, (InstanceId)instanceId);
    }

    protected void after() {
        this.cleanUpInstance();
        this.config.tearDown();
    }

    private void initializeInstance(InstanceId instanceId) {
        Instance createdInstance;
        InstanceConfig instanceConfig = (InstanceConfig)Iterators.get(this.instanceAdminClient.listInstanceConfigs(new Options.ListOption[0]).iterateAll().iterator(), (int)0, null);
        Preconditions.checkState((instanceConfig != null ? 1 : 0) != 0, (Object)"No instance configs found");
        InstanceConfigId configId = instanceConfig.getId();
        logger.log(Level.FINE, "Creating instance using config {0}", configId);
        InstanceInfo instance = InstanceInfo.newBuilder((InstanceId)instanceId).setNodeCount(1).setDisplayName("Test instance").setInstanceConfigId(configId).build();
        OperationFuture op = this.instanceAdminClient.createInstance(instance);
        try {
            createdInstance = (Instance)op.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)e);
        }
        logger.log(Level.INFO, "Created test instance: {0}", createdInstance.getId());
    }

    private void cleanUpInstance() {
        if (this.isOwnedInstance) {
            try {
                logger.log(Level.FINE, "Deleting test instance {0}", this.testHelper.getInstanceId());
                this.instanceAdminClient.deleteInstance(this.testHelper.getInstanceId().getInstance());
                logger.log(Level.INFO, "Deleted test instance {0}", this.testHelper.getInstanceId());
            }
            catch (SpannerException e) {
                logger.log(Level.SEVERE, "Failed to delete test instance " + this.testHelper.getInstanceId(), e);
            }
        } else {
            this.testHelper.cleanUp();
        }
    }

    void checkInitialized() {
        Preconditions.checkState((this.testHelper != null ? 1 : 0) != 0, (Object)"Setup has not completed successfully");
    }
}

