/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KeyRangeTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void basics() {
        KeyRangeTest.checkKeyRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})), Key.of((Object[])new Object[]{1}), KeyRange.Endpoint.CLOSED, Key.of((Object[])new Object[]{2}), KeyRange.Endpoint.OPEN);
        KeyRangeTest.checkKeyRange(KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})), Key.of((Object[])new Object[]{1}), KeyRange.Endpoint.CLOSED, Key.of((Object[])new Object[]{2}), KeyRange.Endpoint.CLOSED);
        KeyRangeTest.checkKeyRange(KeyRange.openOpen((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})), Key.of((Object[])new Object[]{1}), KeyRange.Endpoint.OPEN, Key.of((Object[])new Object[]{2}), KeyRange.Endpoint.OPEN);
        KeyRangeTest.checkKeyRange(KeyRange.openClosed((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})), Key.of((Object[])new Object[]{1}), KeyRange.Endpoint.OPEN, Key.of((Object[])new Object[]{2}), KeyRange.Endpoint.CLOSED);
    }

    private static void checkKeyRange(KeyRange r, Key start, KeyRange.Endpoint startType, Key end, KeyRange.Endpoint endType) {
        Truth.assertThat((Comparable)r.getStartType()).isEqualTo((Object)startType);
        Truth.assertThat((Comparable)r.geEndType()).isEqualTo((Object)endType);
        Truth.assertThat((Object)r.getStart()).isEqualTo((Object)start);
        Truth.assertThat((Object)r.getEnd()).isEqualTo((Object)end);
        KeyRange fromBuilder = KeyRange.newBuilder().setStart(start).setStartType(startType).setEnd(end).setEndType(endType).build();
        Truth.assertThat((Comparable)fromBuilder.getStartType()).isEqualTo((Object)startType);
        Truth.assertThat((Comparable)fromBuilder.geEndType()).isEqualTo((Object)endType);
        Truth.assertThat((Object)fromBuilder.getStart()).isEqualTo((Object)start);
        Truth.assertThat((Object)fromBuilder.getEnd()).isEqualTo((Object)end);
        Truth.assertThat((Object)fromBuilder).isEqualTo((Object)r);
        Truth.assertThat((Integer)fromBuilder.hashCode()).isEqualTo((Object)fromBuilder.hashCode());
    }

    @Test
    public void equalsAndHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})), KeyRange.newBuilder().setStart(Key.of((Object[])new Object[]{1})).setEnd(Key.of((Object[])new Object[]{2})).build(), KeyRange.newBuilder().setStart(Key.of((Object[])new Object[]{1})).setStartType(KeyRange.Endpoint.CLOSED).setEnd(Key.of((Object[])new Object[]{2})).setEndType(KeyRange.Endpoint.OPEN).build()});
        tester.addEqualityGroup(new Object[]{KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2}))});
        tester.addEqualityGroup(new Object[]{KeyRange.openOpen((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2}))});
        tester.addEqualityGroup(new Object[]{KeyRange.openClosed((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2}))});
        tester.addEqualityGroup(new Object[]{KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{2}), (Key)Key.of((Object[])new Object[]{1}))});
        tester.addEqualityGroup(new Object[]{KeyRange.closedClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[0]))});
        tester.addEqualityGroup(new Object[]{KeyRange.prefix((Key)Key.of((Object[])new Object[]{1, 2})), KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{1, 2}), (Key)Key.of((Object[])new Object[]{1, 2}))});
        tester.testEquals();
    }

    @Test
    public void toBuilder() {
        KeyRange r = KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2}));
        r.toBuilder().setEndType(KeyRange.Endpoint.CLOSED).build();
    }

    @Test
    public void builderRequiresStart() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("start(Key)");
        KeyRange.newBuilder().setEnd(Key.of((Object[])new Object[]{"z"})).build();
    }

    @Test
    public void builderRequiresEnd() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("end(Key)");
        KeyRange.newBuilder().setStart(Key.of((Object[])new Object[]{"a"})).build();
    }

    @Test
    public void testToString() {
        Truth.assertThat((String)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"})).toString()).isEqualTo((Object)"[[a],[b])");
        Truth.assertThat((String)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"})).toString()).isEqualTo((Object)"[[a],[b]]");
        Truth.assertThat((String)KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"})).toString()).isEqualTo((Object)"([a],[b])");
        Truth.assertThat((String)KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"a"}), (Key)Key.of((Object[])new Object[]{"b"})).toString()).isEqualTo((Object)"([a],[b]]");
        Truth.assertThat((String)KeyRange.closedClosed((Key)Key.of((Object[])new Object[0]), (Key)Key.of((Object[])new Object[0])).toString()).isEqualTo((Object)"[[],[]]");
    }

    @Test
    public void serialization() throws Exception {
        SerializableTester.reserializeAndAssert((Object)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})));
        SerializableTester.reserializeAndAssert((Object)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})));
        SerializableTester.reserializeAndAssert((Object)KeyRange.openOpen((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})));
        SerializableTester.reserializeAndAssert((Object)KeyRange.openClosed((Key)Key.of((Object[])new Object[]{1}), (Key)Key.of((Object[])new Object[]{2})));
    }
}

