/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KeyTest {
    @Test
    public void of() {
        Key k = Key.of((Object[])new Object[0]);
        Truth.assertThat((Integer)k.size()).isEqualTo((Object)0);
        Truth.assertThat((Iterable)k.getParts()).isEmpty();
        k = Key.of((Object[])new Object[]{"a", "b", "c"});
        Truth.assertThat((Integer)k.size()).isEqualTo((Object)3);
        Truth.assertThat((Iterable)k.getParts()).containsExactly(new Object[]{"a", "b", "c"}).inOrder();
        k = Key.of((Object[])new Object[]{"a", null, "c"});
        Truth.assertThat((Integer)k.size()).isEqualTo((Object)3);
        Truth.assertThat((Iterable)k.getParts()).containsExactly(new Object[]{"a", null, "c"}).inOrder();
        String timestamp = "2015-09-15T00:00:00Z";
        String date = "2015-09-15";
        k = Key.of((Object[])new Object[]{null, true, 32, 64L, Float.valueOf(2.0f), 4.0, "x", ByteArray.copyFrom((String)"y"), Timestamp.parseTimestamp((String)timestamp), Date.parseDate((String)date)});
        Truth.assertThat((Integer)k.size()).isEqualTo((Object)10);
        Truth.assertThat((Iterable)k.getParts()).containsExactly(new Object[]{null, Boolean.TRUE, 32L, 64L, 2.0, 4.0, "x", ByteArray.copyFrom((String)"y"), Timestamp.parseTimestamp((String)timestamp), Date.parseDate((String)date)}).inOrder();
        k = Key.of((Object[])new Object[]{null});
        Truth.assertThat((Integer)k.size()).isEqualTo((Object)1);
        Truth.assertThat((Iterable)k.getParts()).contains(null);
    }

    @Test
    public void builder() {
        String timestamp = "2015-09-15T00:00:00Z";
        String date = "2015-09-15";
        Key k = Key.newBuilder().append((Boolean)null).append(Boolean.valueOf(true)).append(32L).append(64L).append(2.0).append(4.0).append("x").append(ByteArray.copyFrom((String)"y")).append(Timestamp.parseTimestamp((String)timestamp)).append(Date.parseDate((String)date)).build();
        Truth.assertThat((Integer)k.size()).isEqualTo((Object)10);
        Truth.assertThat((Iterable)k.getParts()).containsExactly(new Object[]{null, Boolean.TRUE, 32L, 64L, 2.0, 4.0, "x", ByteArray.copyFrom((String)"y"), Timestamp.parseTimestamp((String)timestamp), Date.parseDate((String)date)}).inOrder();
    }

    @Test
    public void toBuilder() {
        Key k = Key.of((Object[])new Object[]{1, 2}).toBuilder().append(3L).build();
        Truth.assertThat((Integer)k.size()).isEqualTo((Object)3);
        Truth.assertThat((Iterable)k.getParts()).containsExactly(new Object[]{1L, 2L, 3L}).inOrder();
    }

    @Test
    public void testToString() {
        Truth.assertThat((String)Key.of((Object[])new Object[0]).toString()).isEqualTo((Object)"[]");
        Truth.assertThat((String)Key.of((Object[])new Object[]{null}).toString()).isEqualTo((Object)"[<null>]");
        Truth.assertThat((String)Key.of((Object[])new Object[]{true}).toString()).isEqualTo((Object)"[true]");
        Truth.assertThat((String)Key.of((Object[])new Object[]{32}).toString()).isEqualTo((Object)"[32]");
        Truth.assertThat((String)Key.of((Object[])new Object[]{2.0}).toString()).isEqualTo((Object)"[2.0]");
        Truth.assertThat((String)Key.of((Object[])new Object[]{"xyz"}).toString()).isEqualTo((Object)"[xyz]");
        ByteArray b = ByteArray.copyFrom((String)"xyz");
        Truth.assertThat((String)Key.of((Object[])new Object[]{b}).toString()).isEqualTo((Object)("[" + b.toString() + "]"));
        String timestamp = "2015-09-15T00:00:00Z";
        Truth.assertThat((String)Key.of((Object[])new Object[]{Timestamp.parseTimestamp((String)timestamp)}).toString()).isEqualTo((Object)("[" + timestamp + "]"));
        String date = "2015-09-15";
        Truth.assertThat((String)Key.of((Object[])new Object[]{Date.parseDate((String)date)}).toString()).isEqualTo((Object)("[" + date + "]"));
        Truth.assertThat((String)Key.of((Object[])new Object[]{1, 2, 3}).toString()).isEqualTo((Object)"[1,2,3]");
    }

    @Test
    public void equalsAndHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[0]), Key.newBuilder().build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{null}), Key.newBuilder().append((Boolean)null).build(), Key.newBuilder().append((Long)null).build(), Key.newBuilder().append((Double)null).build(), Key.newBuilder().append((String)null).build(), Key.newBuilder().append((ByteArray)null).build(), Key.newBuilder().append((Timestamp)null).build(), Key.newBuilder().append((Date)null).build(), Key.newBuilder().appendObject(null).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{true}), Key.newBuilder().append(Boolean.valueOf(true)).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{false}), Key.newBuilder().append(Boolean.valueOf(false)).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{1}), Key.of((Object[])new Object[]{1L}), Key.newBuilder().append(1L).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{2}), Key.of((Object[])new Object[]{2L}), Key.newBuilder().append(2L).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{1, 2})});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{Float.valueOf(1.0f)}), Key.of((Object[])new Object[]{1.0}), Key.newBuilder().append(1.0).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{Float.valueOf(2.0f)}), Key.of((Object[])new Object[]{2.0}), Key.newBuilder().append(2.0).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{"a"}), Key.newBuilder().append("a").build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{"a", "b", "c"})});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{ByteArray.copyFrom((String)"a")}), Key.newBuilder().append(ByteArray.copyFrom((String)"a")).build()});
        Timestamp t = Timestamp.parseTimestamp((String)"2015-09-15T00:00:00Z");
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{t}), Key.newBuilder().append(t).build()});
        Date d = Date.parseDate((String)"2016-09-15");
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{d}), Key.newBuilder().append(d).build()});
        tester.addEqualityGroup(new Object[]{Key.of((Object[])new Object[]{"a", 2, null})});
        tester.testEquals();
    }

    @Test
    public void serialization() throws Exception {
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[0]));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{null}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{true}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{32}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{2.0}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{"xyz"}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{ByteArray.copyFrom((String)"xyz")}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{Timestamp.parseTimestamp((String)"2015-09-15T00:00:00Z")}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{Date.parseDate((String)"2015-09-15")}));
        SerializableTester.reserializeAndAssert((Object)Key.of((Object[])new Object[]{1, 2, 3}));
    }

    @Test
    public void toProto() {
        String timestamp = "2015-09-15T00:00:00Z";
        String date = "2015-09-15";
        Key k = Key.newBuilder().append((Boolean)null).append(Boolean.valueOf(true)).append(32L).append(64L).append(2.0).append(4.0).append("x").append(ByteArray.copyFrom((String)"y")).append(Timestamp.parseTimestamp((String)timestamp)).append(Date.parseDate((String)date)).build();
        ListValue.Builder builder = ListValue.newBuilder();
        builder.addValuesBuilder().setNullValue(NullValue.NULL_VALUE);
        builder.addValuesBuilder().setBoolValue(true);
        builder.addValuesBuilder().setStringValue("32");
        builder.addValuesBuilder().setStringValue("64");
        builder.addValuesBuilder().setNumberValue(2.0);
        builder.addValuesBuilder().setNumberValue(4.0);
        builder.addValuesBuilder().setStringValue("x");
        builder.addValuesBuilder().setStringValue("eQ==");
        builder.addValuesBuilder().setStringValue(timestamp);
        builder.addValuesBuilder().setStringValue(date);
        Truth.assertThat((Object)k.toProto()).isEqualTo((Object)builder.build());
    }
}

