/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiClock;
import com.google.cloud.RetryOption;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Operation;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import com.google.rpc.Status;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.Database;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class OperationTest {
    private static final String NAME = "projects/test-project/instances/test-instance/databases/database-1";
    @Mock
    private SpannerRpc rpc;
    @Mock
    private DatabaseAdminClient dbClient;
    @Mock
    private ApiClock clock;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void failedOperation() {
        com.google.longrunning.Operation proto = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(true).setError(Status.newBuilder().setCode(Code.NOT_FOUND.getNumber())).build();
        Operation op = Operation.create((SpannerRpc)this.rpc, (com.google.longrunning.Operation)proto, (Operation.Parser)new ParserImpl());
        Truth.assertThat((String)op.getName()).isEqualTo((Object)"op1");
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((Boolean)op.isSuccessful()).isFalse();
        Truth.assertThat((String)((String)op.getMetadata())).isNull();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.NOT_FOUND));
        op.getResult();
    }

    @Test
    public void successfulOperation() {
        com.google.spanner.admin.database.v1.Database db = com.google.spanner.admin.database.v1.Database.newBuilder().setName(NAME).setState(Database.State.READY).build();
        com.google.longrunning.Operation proto = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(true).setResponse(Any.pack((Message)db)).build();
        Operation op = Operation.create((SpannerRpc)this.rpc, (com.google.longrunning.Operation)proto, (Operation.Parser)new ParserImpl());
        Truth.assertThat((String)op.getName()).isEqualTo((Object)"op1");
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((Boolean)op.isSuccessful()).isTrue();
        Truth.assertThat((String)((String)op.getMetadata())).isNull();
        Truth.assertThat((String)((Database)op.getResult()).getId().getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void pendingOperation() {
        com.google.longrunning.Operation proto = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(false).setMetadata(Any.pack((Message)CreateDatabaseMetadata.newBuilder().setDatabase(NAME).build())).build();
        Operation op = Operation.create((SpannerRpc)this.rpc, (com.google.longrunning.Operation)proto, (Operation.Parser)new ParserImpl());
        Truth.assertThat((String)op.getName()).isEqualTo((Object)"op1");
        Truth.assertThat((Boolean)op.isDone()).isFalse();
        Truth.assertThat((Boolean)op.isSuccessful()).isFalse();
        Truth.assertThat((String)((String)op.getMetadata())).isEqualTo((Object)NAME);
        Truth.assertThat((Object)op.getResult()).isNull();
    }

    @Test
    public void reload() {
        com.google.longrunning.Operation proto = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(false).build();
        Operation op = Operation.create((SpannerRpc)this.rpc, (com.google.longrunning.Operation)proto, (Operation.Parser)new ParserImpl());
        com.google.spanner.admin.database.v1.Database db = com.google.spanner.admin.database.v1.Database.newBuilder().setName(NAME).setState(Database.State.READY).build();
        proto = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(true).setResponse(Any.pack((Message)db)).build();
        Mockito.when((Object)this.rpc.getOperation("op1")).thenReturn((Object)proto);
        op = op.reload();
        Truth.assertThat((String)op.getName()).isEqualTo((Object)"op1");
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((Boolean)op.isSuccessful()).isTrue();
        Truth.assertThat((String)((String)op.getMetadata())).isNull();
        Truth.assertThat((String)((Database)op.getResult()).getId().getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void waitForCompletes() throws Exception {
        com.google.longrunning.Operation proto = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(false).build();
        Operation op = Operation.create((SpannerRpc)this.rpc, (com.google.longrunning.Operation)proto, (Operation.Parser)new ParserImpl());
        com.google.spanner.admin.database.v1.Database db = com.google.spanner.admin.database.v1.Database.newBuilder().setName(NAME).setState(Database.State.READY).build();
        com.google.longrunning.Operation proto2 = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(true).setResponse(Any.pack((Message)db)).build();
        Mockito.when((Object)this.rpc.getOperation("op1")).thenReturn((Object)proto, (Object[])new com.google.longrunning.Operation[]{proto2});
        op = op.waitFor(new RetryOption[]{RetryOption.totalTimeout((Duration)Duration.ofSeconds((long)3L)), RetryOption.initialRetryDelay((Duration)Duration.ZERO)});
        Truth.assertThat((String)op.getName()).isEqualTo((Object)"op1");
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((Boolean)op.isSuccessful()).isTrue();
        Truth.assertThat((String)((String)op.getMetadata())).isNull();
        Truth.assertThat((String)((Database)op.getResult()).getId().getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void waitForTimesout() throws Exception {
        com.google.longrunning.Operation proto = com.google.longrunning.Operation.newBuilder().setName("op1").setDone(false).build();
        Operation op = Operation.create((SpannerRpc)this.rpc, (com.google.longrunning.Operation)proto, (Operation.Parser)new ParserImpl(), (ApiClock)this.clock);
        Mockito.when((Object)this.rpc.getOperation("op1")).thenReturn((Object)proto);
        Mockito.when((Object)this.clock.nanoTime()).thenReturn((Object)0L, (Object[])new Long[]{50000000L, 100000000L, 150000000L});
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        op.waitFor(new RetryOption[]{RetryOption.totalTimeout((Duration)Duration.ofMillis((long)100L)), RetryOption.initialRetryDelay((Duration)Duration.ZERO)});
    }

    private class ParserImpl
    implements Operation.Parser<Database, String> {
        private ParserImpl() {
        }

        public Database parseResult(Any response) {
            try {
                return Database.fromProto((com.google.spanner.admin.database.v1.Database)((com.google.spanner.admin.database.v1.Database)response.unpack(com.google.spanner.admin.database.v1.Database.class)), (DatabaseAdminClient)OperationTest.this.dbClient);
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }

        public String parseMetadata(Any metadata) {
            try {
                return ((CreateDatabaseMetadata)metadata.unpack(CreateDatabaseMetadata.class)).getDatabase();
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }
    }
}

