/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class SessionPoolTest
extends BaseSessionPoolTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter
    public int minSessions;
    @Mock
    SpannerImpl client;
    DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    SessionPool pool;
    SessionPoolOptions options;

    @Parameterized.Parameters(name="min sessions = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {1});
    }

    private SessionPool createPool() {
        return SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (DatabaseId)this.db, (SpannerImpl)this.client);
    }

    private SessionPool createPool(SessionPool.Clock clock) {
        return SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (DatabaseId)this.db, (SpannerImpl)this.client, (SessionPool.Clock)clock);
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(2).setBlockIfPoolExhausted().build();
    }

    private void setupMockSessionCreation() {
        Mockito.when((Object)this.client.createSession(this.db)).thenAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                return SessionPoolTest.this.mockSession();
            }
        });
    }

    @Test
    public void sessionCreation() {
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        try (SessionPool.PooledSession session = this.pool.getReadSession();){
            Truth.assertThat((Object)session).isNotNull();
        }
    }

    @Test
    public void poolClosure() throws Exception {
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        this.pool.closeAsync().get();
    }

    @Test
    public void poolClosureClosesLeakedSessions() throws Exception {
        SessionImpl mockSession1 = this.mockSession();
        SessionImpl mockSession2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.pool = this.createPool();
        SessionPool.PooledSession session1 = this.pool.getReadSession();
        this.pool.getReadSession();
        session1.close();
        this.pool.closeAsync().get();
        ((SessionImpl)Mockito.verify((Object)mockSession1)).close();
        ((SessionImpl)Mockito.verify((Object)mockSession2)).close();
    }

    @Test
    public void poolClosesWhenMaintenanceLoopIsRunning() throws Exception {
        this.setupMockSessionCreation();
        final BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        this.pool = this.createPool(clock);
        final AtomicBoolean stop = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stop.get()) {
                    SessionPoolTest.this.runMaintainanceLoop(clock, SessionPoolTest.this.pool, 1L);
                }
            }
        }).start();
        this.pool.closeAsync().get();
        stop.set(true);
    }

    @Test
    public void poolClosureFailsPendingReadWaiters() throws Exception {
        final CountDownLatch insideCreation = new CountDownLatch(1);
        final CountDownLatch releaseCreation = new CountDownLatch(1);
        SessionImpl session1 = this.mockSession();
        SessionImpl session2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session1).thenAnswer((Answer)new Answer<Session>((Session)session2){
            final /* synthetic */ Session val$session2;
            {
                this.val$session2 = session;
            }

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insideCreation.countDown();
                releaseCreation.await();
                return this.val$session2;
            }
        });
        this.pool = this.createPool();
        this.pool.getReadSession();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getSessionAsync(latch, failed);
        insideCreation.await();
        this.pool.closeAsync();
        releaseCreation.countDown();
        latch.await();
        Truth.assertThat((Boolean)failed.get()).isTrue();
    }

    @Test
    public void poolClosureFailsPendingWriteWaiters() throws Exception {
        final CountDownLatch insideCreation = new CountDownLatch(1);
        final CountDownLatch releaseCreation = new CountDownLatch(1);
        SessionImpl session1 = this.mockSession();
        SessionImpl session2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session1).thenAnswer((Answer)new Answer<Session>((Session)session2){
            final /* synthetic */ Session val$session2;
            {
                this.val$session2 = session;
            }

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insideCreation.countDown();
                releaseCreation.await();
                return this.val$session2;
            }
        });
        this.pool = this.createPool();
        this.pool.getReadSession();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getReadWriteSessionAsync(latch, failed);
        insideCreation.await();
        this.pool.closeAsync();
        releaseCreation.countDown();
        latch.await();
        Truth.assertThat((Boolean)failed.get()).isTrue();
    }

    @Test
    public void poolClosesEvenIfCreationFails() throws Exception {
        final CountDownLatch insideCreation = new CountDownLatch(1);
        final CountDownLatch releaseCreation = new CountDownLatch(1);
        Mockito.when((Object)this.client.createSession(this.db)).thenAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insideCreation.countDown();
                releaseCreation.await();
                throw SpannerExceptionFactory.newSpannerException((Throwable)new RuntimeException());
            }
        });
        this.pool = this.createPool();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getSessionAsync(latch, failed);
        insideCreation.await();
        ListenableFuture f = this.pool.closeAsync();
        releaseCreation.countDown();
        f.get();
        Truth.assertThat((Boolean)f.isDone()).isTrue();
    }

    @Test
    public void poolClosesEvenIfPreparationFails() throws Exception {
        SessionImpl session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        final CountDownLatch insidePrepare = new CountDownLatch(1);
        final CountDownLatch releasePrepare = new CountDownLatch(1);
        ((SessionImpl)Mockito.doAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocation) throws Throwable {
                insidePrepare.countDown();
                releasePrepare.await();
                throw SpannerExceptionFactory.newSpannerException((Throwable)new RuntimeException());
            }
        }).when((Object)session)).prepareReadWriteTransaction();
        this.pool = this.createPool();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getReadWriteSessionAsync(latch, failed);
        insidePrepare.await();
        ListenableFuture f = this.pool.closeAsync();
        releasePrepare.countDown();
        f.get();
        Truth.assertThat((Boolean)f.isDone()).isTrue();
    }

    @Test
    public void poolClosureFailsNewRequests() throws Exception {
        SessionImpl session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        this.pool = this.createPool();
        this.pool.getReadSession();
        this.pool.closeAsync();
        this.expectedException.expect(IllegalStateException.class);
        this.pool.getReadSession();
    }

    @Test
    public void atMostMaxSessionsCreated() {
        this.setupMockSessionCreation();
        AtomicBoolean failed = new AtomicBoolean(false);
        this.pool = this.createPool();
        int numSessions = 10;
        CountDownLatch latch = new CountDownLatch(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            this.getSessionAsync(latch, failed);
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        ((SpannerImpl)Mockito.verify((Object)this.client, (VerificationMode)Mockito.atMost((int)this.options.getMaxSessions()))).createSession(this.db);
        Truth.assertThat((Boolean)failed.get()).isFalse();
    }

    @Test
    public void creationExceptionPropagatesToReadSession() {
        Mockito.when((Object)this.client.createSession(this.db)).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)"")});
        this.pool = this.createPool();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        this.pool.getReadSession();
    }

    @Test
    public void creationExceptionPropagatesToReadWriteSession() {
        Mockito.when((Object)this.client.createSession(this.db)).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)"")});
        this.pool = this.createPool();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        this.pool.getReadWriteSession();
    }

    @Test
    public void prepareExceptionPropagatesToReadWriteSession() {
        SessionImpl session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        ((SessionImpl)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)"")).when((Object)session)).prepareReadWriteTransaction();
        this.pool = this.createPool();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.INTERNAL));
        this.pool.getReadWriteSession();
    }

    @Test
    public void getReadWriteSession() {
        SessionImpl mockSession = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession);
        this.pool = this.createPool();
        try (SessionPool.PooledSession session = this.pool.getReadWriteSession();){
            Truth.assertThat((Object)session).isNotNull();
            ((SessionImpl)Mockito.verify((Object)mockSession)).prepareReadWriteTransaction();
        }
    }

    @Test
    public void getMultipleReadWriteSessions() {
        SessionImpl mockSession1 = this.mockSession();
        SessionImpl mockSession2 = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.pool = this.createPool();
        SessionPool.PooledSession session1 = this.pool.getReadWriteSession();
        SessionPool.PooledSession session2 = this.pool.getReadWriteSession();
        ((SessionImpl)Mockito.verify((Object)mockSession1)).prepareReadWriteTransaction();
        ((SessionImpl)Mockito.verify((Object)mockSession2)).prepareReadWriteTransaction();
        session1.close();
        session2.close();
    }

    @Test
    public void getMultipleConcurrentReadWriteSessions() {
        AtomicBoolean failed = new AtomicBoolean(false);
        SessionImpl session = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        this.pool = this.createPool();
        int numSessions = 5;
        CountDownLatch latch = new CountDownLatch(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            this.getReadWriteSessionAsync(latch, failed);
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
    }

    @Test
    public void sessionIsPrePrepared() {
        SessionImpl mockSession1 = this.mockSession();
        SessionImpl mockSession2 = this.mockSession();
        final CountDownLatch prepareLatch = new CountDownLatch(1);
        ((SessionImpl)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock arg0) throws Throwable {
                prepareLatch.countDown();
                return null;
            }
        }).when((Object)mockSession1)).prepareReadWriteTransaction();
        ((SessionImpl)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock arg0) throws Throwable {
                prepareLatch.countDown();
                return null;
            }
        }).when((Object)mockSession2)).prepareReadWriteTransaction();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.options = SessionPoolOptions.newBuilder().setMinSessions(2).setMaxSessions(2).setWriteSessionsFraction(0.5f).build();
        this.pool = this.createPool();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)prepareLatch);
        SessionPool.PooledSession readSession = this.pool.getReadSession();
        SessionPool.PooledSession writeSession = this.pool.getReadWriteSession();
        ((SessionImpl)Mockito.verify((Object)writeSession.delegate, (VerificationMode)Mockito.times((int)1))).prepareReadWriteTransaction();
        ((SessionImpl)Mockito.verify((Object)readSession.delegate, (VerificationMode)Mockito.never())).prepareReadWriteTransaction();
        readSession.close();
        writeSession.close();
    }

    @Test
    public void getReadSessionFallsBackToWritePreparedSession() throws Exception {
        SessionImpl mockSession1 = this.mockSession();
        final CountDownLatch prepareLatch = new CountDownLatch(2);
        ((SessionImpl)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock arg0) throws Throwable {
                prepareLatch.countDown();
                return null;
            }
        }).when((Object)mockSession1)).prepareReadWriteTransaction();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1);
        this.options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(1).setWriteSessionsFraction(1.0f).build();
        this.pool = this.createPool();
        this.pool.getReadWriteSession().close();
        prepareLatch.await();
        SessionPool.PooledSession readSession = this.pool.getReadSession();
        ((SessionImpl)Mockito.verify((Object)readSession.delegate, (VerificationMode)Mockito.times((int)2))).prepareReadWriteTransaction();
    }

    @Test
    public void failOnPoolExhaustion() {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setFailIfPoolExhausted().build();
        SessionImpl mockSession = this.mockSession();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession);
        this.pool = this.createPool();
        SessionPool.PooledSession session1 = this.pool.getReadSession();
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.RESOURCE_EXHAUSTED));
        this.pool.getReadSession();
        session1.close();
        session1 = this.pool.getReadSession();
        Truth.assertThat((Object)session1).isNotNull();
        session1.close();
    }

    @Test
    public void poolWorksWhenSessionNotFound() {
        SessionImpl mockSession1 = this.mockSession();
        SessionImpl mockSession2 = this.mockSession();
        ((SessionImpl)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found")).when((Object)mockSession1)).prepareReadWriteTransaction();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)mockSession1).thenReturn((Object)mockSession2);
        this.pool = this.createPool();
        Truth.assertThat((Object)this.pool.getReadWriteSession().delegate).isEqualTo((Object)mockSession2);
    }

    @Test
    public void idleSessionCleanup() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(3).setMaxIdleSessions(0).build();
        SessionImpl session1 = this.mockSession();
        SessionImpl session2 = this.mockSession();
        SessionImpl session3 = this.mockSession();
        final AtomicInteger numSessionClosed = new AtomicInteger();
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session1).thenReturn((Object)session2).thenReturn((Object)session3);
        for (Session session : new Session[]{session1, session2, session3}) {
            ((Session)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    numSessionClosed.incrementAndGet();
                    return null;
                }
            }).when((Object)session)).close();
        }
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        this.pool.getReadSession().close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Integer)numSessionClosed.get()).isEqualTo((Object)0);
        SessionPool.PooledSession readSession1 = this.pool.getReadSession();
        SessionPool.PooledSession readSession2 = this.pool.getReadSession();
        SessionPool.PooledSession readSession3 = this.pool.getReadSession();
        readSession1.close();
        readSession2.close();
        readSession3.close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Integer)numSessionClosed.get()).isEqualTo((Object)0);
        this.pool.getReadSession().close();
        this.pool.getReadSession().close();
        this.pool.getReadSession().close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Integer)numSessionClosed.get()).isEqualTo((Object)2);
        this.pool.closeAsync().get();
    }

    @Test
    public void keepAlive() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(2).setMaxSessions(3).build();
        SessionImpl session = this.mockSession();
        this.mockKeepAlive((Session)session);
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)session);
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        SessionPool.PooledSession session1 = this.pool.getReadSession();
        SessionPool.PooledSession session2 = this.pool.getReadSession();
        session1.close();
        session2.close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((SessionImpl)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).singleUse((TimestampBound)Matchers.any(TimestampBound.class));
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((SessionImpl)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)2))).singleUse((TimestampBound)Matchers.any(TimestampBound.class));
        clock.currentTimeMillis += clock.currentTimeMillis + 0x200B20L;
        session1 = this.pool.getReadSession();
        session1.writeAtLeastOnce(new ArrayList());
        session1.close();
        this.runMaintainanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((SessionImpl)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)3))).singleUse((TimestampBound)Matchers.any(TimestampBound.class));
        this.pool.closeAsync().get();
    }

    @Test
    public void testSessionNotFoundSingleUse() {
        Statement statement = Statement.of((String)"SELECT 1");
        SessionImpl closedSession = this.mockSession();
        ReadContext closedContext = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet closedResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)closedResultSet.next()).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found")});
        Mockito.when((Object)closedContext.executeQuery(statement, new Options.QueryOption[0])).thenReturn((Object)closedResultSet);
        Mockito.when((Object)closedSession.singleUse()).thenReturn((Object)closedContext);
        SessionImpl openSession = this.mockSession();
        ReadContext openContext = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet openResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)openResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)openContext.executeQuery(statement, new Options.QueryOption[0])).thenReturn((Object)openResultSet);
        Mockito.when((Object)openSession.singleUse()).thenReturn((Object)openContext);
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)closedSession, (Object[])new SessionImpl[]{openSession});
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        ReadContext context = this.pool.getReadSession().singleUse();
        ResultSet resultSet = context.executeQuery(statement, new Options.QueryOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
    }

    @Test
    public void testSessionNotFoundReadOnlyTransaction() {
        Statement statement = Statement.of((String)"SELECT 1");
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.readOnlyTransaction()).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found")});
        SessionImpl openSession = this.mockSession();
        ReadOnlyTransaction openTransaction = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        ResultSet openResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)openResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)openTransaction.executeQuery(statement, new Options.QueryOption[0])).thenReturn((Object)openResultSet);
        Mockito.when((Object)openSession.readOnlyTransaction()).thenReturn((Object)openTransaction);
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)closedSession, (Object[])new SessionImpl[]{openSession});
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        ReadOnlyTransaction transaction = this.pool.getReadSession().readOnlyTransaction();
        ResultSet resultSet = transaction.executeQuery(statement, new Options.QueryOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
    }

    @Test
    public void testSessionNotFoundReadWriteTransaction() {
        final Statement queryStatement = Statement.of((String)"SELECT 1");
        final Statement updateStatement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE ID=2");
        SpannerException sessionNotFound = SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found");
        ReadWriteTransactionTestStatementType[] readWriteTransactionTestStatementTypeArray = ReadWriteTransactionTestStatementType.values();
        int n = readWriteTransactionTestStatementTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ReadWriteTransactionTestStatementType statementType;
            final ReadWriteTransactionTestStatementType executeStatementType = statementType = readWriteTransactionTestStatementTypeArray[i];
            boolean[] blArray = new boolean[]{true, false};
            int n2 = blArray.length;
            for (int j = 0; j < n2; ++j) {
                boolean prepared;
                final boolean hasPreparedTransaction = prepared = blArray[j];
                SpannerRpc.StreamingCall closedStreamingCall = (SpannerRpc.StreamingCall)Mockito.mock(SpannerRpc.StreamingCall.class);
                ((SpannerRpc.StreamingCall)Mockito.doThrow((Throwable)sessionNotFound).when((Object)closedStreamingCall)).request(Mockito.anyInt());
                SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
                Mockito.when((Object)rpc.executeQuery((ExecuteSqlRequest)Matchers.any(ExecuteSqlRequest.class), (SpannerRpc.ResultStreamConsumer)Matchers.any(SpannerRpc.ResultStreamConsumer.class), (Map)Matchers.any(Map.class))).thenReturn((Object)closedStreamingCall);
                Mockito.when((Object)rpc.executeQuery((ExecuteSqlRequest)Matchers.any(ExecuteSqlRequest.class), (Map)Matchers.any(Map.class))).thenThrow(new Throwable[]{sessionNotFound});
                Mockito.when((Object)rpc.executeBatchDml((ExecuteBatchDmlRequest)Matchers.any(ExecuteBatchDmlRequest.class), (Map)Matchers.any(Map.class))).thenThrow(new Throwable[]{sessionNotFound});
                Mockito.when((Object)rpc.commit((CommitRequest)Matchers.any(CommitRequest.class), (Map)Matchers.any(Map.class))).thenThrow(new Throwable[]{sessionNotFound});
                ((SpannerRpc)Mockito.doThrow((Throwable)sessionNotFound).when((Object)rpc)).rollback((RollbackRequest)Matchers.any(RollbackRequest.class), (Map)Matchers.any(Map.class));
                SessionImpl closedSession = (SessionImpl)Mockito.mock(SessionImpl.class);
                Mockito.when((Object)closedSession.getName()).thenReturn((Object)"projects/dummy/instances/dummy/database/dummy/sessions/session-closed");
                ByteString preparedTransactionId = hasPreparedTransaction ? ByteString.copyFromUtf8((String)"test-txn") : null;
                final TransactionRunnerImpl.TransactionContextImpl closedTransactionContext = new TransactionRunnerImpl.TransactionContextImpl(closedSession, preparedTransactionId, rpc, 10);
                Mockito.when((Object)closedSession.newTransaction()).thenReturn((Object)closedTransactionContext);
                Mockito.when((Object)closedSession.beginTransaction()).thenThrow(new Throwable[]{sessionNotFound});
                TransactionRunnerImpl closedTransactionRunner = new TransactionRunnerImpl(closedSession, rpc, 10);
                Mockito.when((Object)closedSession.readWriteTransaction()).thenReturn((Object)closedTransactionRunner);
                SessionImpl openSession = (SessionImpl)Mockito.mock(SessionImpl.class);
                Mockito.when((Object)openSession.getName()).thenReturn((Object)"projects/dummy/instances/dummy/database/dummy/sessions/session-open");
                final TransactionRunnerImpl.TransactionContextImpl openTransactionContext = (TransactionRunnerImpl.TransactionContextImpl)Mockito.mock(TransactionRunnerImpl.TransactionContextImpl.class);
                Mockito.when((Object)openSession.newTransaction()).thenReturn((Object)openTransactionContext);
                Mockito.when((Object)openSession.beginTransaction()).thenReturn((Object)ByteString.copyFromUtf8((String)"open-txn"));
                TransactionRunnerImpl openTransactionRunner = new TransactionRunnerImpl(openSession, (SpannerRpc)Mockito.mock(SpannerRpc.class), 10);
                Mockito.when((Object)openSession.readWriteTransaction()).thenReturn((Object)openTransactionRunner);
                ResultSet openResultSet = (ResultSet)Mockito.mock(ResultSet.class);
                Mockito.when((Object)openResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
                ResultSet planResultSet = (ResultSet)Mockito.mock(ResultSet.class);
                Mockito.when((Object)planResultSet.getStats()).thenReturn((Object)ResultSetStats.getDefaultInstance());
                Mockito.when((Object)openTransactionContext.executeQuery(queryStatement, new Options.QueryOption[0])).thenReturn((Object)openResultSet);
                Mockito.when((Object)openTransactionContext.analyzeQuery(queryStatement, ReadContext.QueryAnalyzeMode.PLAN)).thenReturn((Object)planResultSet);
                Mockito.when((Object)openTransactionContext.executeUpdate(updateStatement)).thenReturn((Object)1L);
                Mockito.when((Object)openTransactionContext.batchUpdate(Arrays.asList(updateStatement, updateStatement))).thenReturn((Object)new long[]{1L, 1L});
                Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)closedSession, (Object[])new SessionImpl[]{openSession});
                BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
                clock.currentTimeMillis = System.currentTimeMillis();
                SessionPoolOptions options = SessionPoolOptions.newBuilder().setMinSessions(0).setMaxSessions(2).setBlockIfPoolExhausted().build();
                SessionPool pool = SessionPool.createPool((SessionPoolOptions)options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (DatabaseId)this.db, (SpannerImpl)this.client, (SessionPool.Clock)clock);
                TransactionRunner runner = pool.getReadWriteSession().readWriteTransaction();
                try {
                    runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
                        private int callNumber = 0;

                        public Integer run(TransactionContext transaction) throws Exception {
                            ++this.callNumber;
                            if (hasPreparedTransaction) {
                                if (this.callNumber == 1) {
                                    Truth.assertThat((Object)transaction).isEqualTo((Object)closedTransactionContext);
                                } else {
                                    Truth.assertThat((Object)transaction).isEqualTo((Object)openTransactionContext);
                                }
                            } else {
                                Truth.assertThat((Object)transaction).isEqualTo((Object)openTransactionContext);
                            }
                            switch (executeStatementType) {
                                case QUERY: {
                                    ResultSet resultSet = transaction.executeQuery(queryStatement, new Options.QueryOption[0]);
                                    Truth.assertThat((Boolean)resultSet.next()).isTrue();
                                    break;
                                }
                                case ANALYZE: {
                                    ResultSet planResultSet = transaction.analyzeQuery(queryStatement, ReadContext.QueryAnalyzeMode.PLAN);
                                    Truth.assertThat((Boolean)planResultSet.next()).isFalse();
                                    Truth.assertThat((Object)planResultSet.getStats()).isNotNull();
                                    break;
                                }
                                case UPDATE: {
                                    long updateCount = transaction.executeUpdate(updateStatement);
                                    Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
                                    break;
                                }
                                case BATCH_UPDATE: {
                                    long[] updateCounts = transaction.batchUpdate(Arrays.asList(updateStatement, updateStatement));
                                    Truth.assertThat((long[])updateCounts).isEqualTo((Object)new long[]{1L, 1L});
                                    break;
                                }
                                case WRITE: {
                                    transaction.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{1L})));
                                    break;
                                }
                                case EXCEPTION: {
                                    throw new RuntimeException("rollback at call " + this.callNumber);
                                }
                                default: {
                                    Assert.fail((String)("Unknown statement type: " + (Object)((Object)executeStatementType)));
                                }
                            }
                            return this.callNumber;
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    Truth.assertThat((Boolean)(executeStatementType == ReadWriteTransactionTestStatementType.EXCEPTION && e.getMessage().contains("rollback at call 1") ? 1 : 0)).isTrue();
                }
            }
        }
    }

    @Test
    public void testSessionNotFoundOnPrepareTransaction() {
        SpannerException sessionNotFound = SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found");
        SessionImpl closedSession = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)closedSession.getName()).thenReturn((Object)"projects/dummy/instances/dummy/database/dummy/sessions/session-closed");
        Mockito.when((Object)closedSession.beginTransaction()).thenThrow(new Throwable[]{sessionNotFound});
        ((SessionImpl)Mockito.doThrow((Throwable)sessionNotFound).when((Object)closedSession)).prepareReadWriteTransaction();
        SessionImpl openSession = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)openSession.getName()).thenReturn((Object)"projects/dummy/instances/dummy/database/dummy/sessions/session-open");
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)closedSession, (Object[])new SessionImpl[]{openSession});
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        SessionPool.PooledSession session = this.pool.getReadWriteSession();
        Truth.assertThat((Object)session.delegate).isEqualTo((Object)openSession);
    }

    @Test
    public void testSessionNotFoundWrite() {
        SpannerException sessionNotFound = SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found");
        List<Mutation> mutations = Arrays.asList(Mutation.newInsertBuilder((String)"FOO").build());
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.write(mutations)).thenThrow(new Throwable[]{sessionNotFound});
        SessionImpl openSession = this.mockSession();
        Mockito.when((Object)openSession.write(mutations)).thenReturn((Object)Timestamp.now());
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)closedSession, (Object[])new SessionImpl[]{openSession});
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        DatabaseClientImpl impl = new DatabaseClientImpl(this.pool);
        Truth.assertThat((Comparable)impl.write(mutations)).isNotNull();
    }

    @Test
    public void testSessionNotFoundWriteAtLeastOnce() {
        SpannerException sessionNotFound = SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found");
        List<Mutation> mutations = Arrays.asList(Mutation.newInsertBuilder((String)"FOO").build());
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.writeAtLeastOnce(mutations)).thenThrow(new Throwable[]{sessionNotFound});
        SessionImpl openSession = this.mockSession();
        Mockito.when((Object)openSession.writeAtLeastOnce(mutations)).thenReturn((Object)Timestamp.now());
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)closedSession, (Object[])new SessionImpl[]{openSession});
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        DatabaseClientImpl impl = new DatabaseClientImpl(this.pool);
        Truth.assertThat((Comparable)impl.writeAtLeastOnce(mutations)).isNotNull();
    }

    @Test
    public void testSessionNotFoundPartitionedUpdate() {
        SpannerException sessionNotFound = SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"Session not found");
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE 1=1");
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.executePartitionedUpdate(statement)).thenThrow(new Throwable[]{sessionNotFound});
        SessionImpl openSession = this.mockSession();
        Mockito.when((Object)openSession.executePartitionedUpdate(statement)).thenReturn((Object)1L);
        Mockito.when((Object)this.client.createSession(this.db)).thenReturn((Object)closedSession, (Object[])new SessionImpl[]{openSession});
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        DatabaseClientImpl impl = new DatabaseClientImpl(this.pool);
        Truth.assertThat((Long)impl.executePartitionedUpdate(statement)).isEqualTo((Object)1L);
    }

    private void mockKeepAlive(Session session) {
        ReadContext context = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)session.singleUse((TimestampBound)Matchers.any(TimestampBound.class))).thenReturn((Object)context);
        Mockito.when((Object)context.executeQuery((Statement)Matchers.any(Statement.class), new Options.QueryOption[0])).thenReturn((Object)resultSet);
    }

    private void getSessionAsync(final CountDownLatch latch, final AtomicBoolean failed) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (SessionPool.PooledSession session = SessionPoolTest.this.pool.getReadSession();){
                    failed.compareAndSet(false, session == null);
                    Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                catch (SpannerException e) {
                    failed.compareAndSet(false, true);
                }
                finally {
                    latch.countDown();
                }
            }
        }).start();
    }

    private void getReadWriteSessionAsync(final CountDownLatch latch, final AtomicBoolean failed) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (SessionPool.PooledSession session = SessionPoolTest.this.pool.getReadWriteSession();){
                    failed.compareAndSet(false, session == null);
                    Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                catch (SpannerException e) {
                    failed.compareAndSet(false, true);
                }
                finally {
                    latch.countDown();
                }
            }
        }).start();
    }

    private static enum ReadWriteTransactionTestStatementType {
        QUERY,
        ANALYZE,
        UPDATE,
        BATCH_UPDATE,
        WRITE,
        EXCEPTION;

    }
}

