/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.protobuf.ByteString;
import com.google.rpc.Status;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import java.util.Arrays;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class TransactionContextImplTest {
    @Test(expected=AbortedException.class)
    public void batchDmlAborted() {
        this.batchDml(10);
    }

    @Test(expected=SpannerBatchUpdateException.class)
    public void batchDmlException() {
        this.batchDml(9);
    }

    private void batchDml(int status) {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)"test");
        SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
        ExecuteBatchDmlResponse response = ExecuteBatchDmlResponse.newBuilder().setStatus(Status.newBuilder().setCode(status).build()).build();
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1");
        Mockito.when((Object)rpc.executeBatchDml((ExecuteBatchDmlRequest)Mockito.any(ExecuteBatchDmlRequest.class), Mockito.anyMap())).thenReturn((Object)response);
        try (TransactionRunnerImpl.TransactionContextImpl impl = new TransactionRunnerImpl.TransactionContextImpl(session, ByteString.copyFromUtf8((String)"test"), rpc, 10);){
            impl.batchUpdate(Arrays.asList(statement));
        }
    }
}

