/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetStats;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TransactionRunnerImplTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SessionImpl session;
    @Mock
    private TransactionRunnerImpl.TransactionContextImpl txn;
    private TransactionRunnerImpl transactionRunner;
    private boolean firstRun;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.firstRun = true;
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        this.transactionRunner = new TransactionRunnerImpl(this.session, this.rpc, 1);
    }

    @Test
    public void commitSucceeds() {
        final AtomicInteger numCalls = new AtomicInteger(0);
        this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                numCalls.incrementAndGet();
                return null;
            }
        });
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)1);
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).ensureTxn();
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).commit();
    }

    @Test
    public void runAbort() {
        Mockito.when((Object)this.txn.isAborted()).thenReturn((Object)true);
        this.runTransaction((Exception)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)""));
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)2))).ensureTxn();
    }

    @Test
    public void commitAbort() {
        SpannerException error = SpannerExceptionFactory.newSpannerException((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)""));
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)error).doNothing().when((Object)this.txn)).commit();
        final AtomicInteger numCalls = new AtomicInteger(0);
        this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                numCalls.incrementAndGet();
                return null;
            }
        });
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)2);
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)2))).ensureTxn();
    }

    @Test
    public void commitFailsWithNonAbort() {
        SpannerException error = SpannerExceptionFactory.newSpannerException((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)""));
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)error).when((Object)this.txn)).commit();
        final AtomicInteger numCalls = new AtomicInteger(0);
        try {
            this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) throws Exception {
                    numCalls.incrementAndGet();
                    return null;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
        }
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)1);
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)1))).ensureTxn();
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void runResourceExhaustedNoRetry() throws Exception {
        try {
            this.runTransaction((Exception)new StatusRuntimeException(io.grpc.Status.fromCodeValue((int)Status.Code.RESOURCE_EXHAUSTED.value())));
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException spannerException) {
            // empty catch block
        }
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).rollback();
    }

    @Test
    public void batchDmlAborted() {
        long[] updateCount = this.batchDmlException(10);
        Truth.assertThat((Integer)updateCount.length).isEqualTo((Object)2);
        Truth.assertThat((Long)updateCount[0]).isEqualTo((Object)1L);
        Truth.assertThat((Long)updateCount[1]).isEqualTo((Object)1L);
    }

    @Test
    public void batchDmlFailedPrecondition() {
        try {
            this.batchDmlException(9);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerBatchUpdateException e) {
            Truth.assertThat((Integer)e.getUpdateCounts().length).isEqualTo((Object)1);
            Truth.assertThat((Long)e.getUpdateCounts()[0]).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)(e.getCode() == 9 ? 1 : 0));
        }
    }

    private long[] batchDmlException(int status) {
        Preconditions.checkArgument((status != 0 ? 1 : 0) != 0);
        TransactionRunnerImpl.TransactionContextImpl transaction = new TransactionRunnerImpl.TransactionContextImpl(this.session, ByteString.copyFromUtf8((String)"test"), this.rpc, 10);
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)transaction);
        Mockito.when((Object)this.session.getName()).thenReturn((Object)"test");
        TransactionRunnerImpl runner = new TransactionRunnerImpl(this.session, this.rpc, 10);
        ExecuteBatchDmlResponse response1 = ExecuteBatchDmlResponse.newBuilder().addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L)).build()).setStatus(Status.newBuilder().setCode(status).build()).build();
        ExecuteBatchDmlResponse response2 = ExecuteBatchDmlResponse.newBuilder().addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L)).build()).addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L)).build()).setStatus(Status.newBuilder().setCode(0).build()).build();
        Mockito.when((Object)this.rpc.executeBatchDml((ExecuteBatchDmlRequest)Mockito.any(ExecuteBatchDmlRequest.class), Mockito.anyMap())).thenReturn((Object)response1, (Object[])new ExecuteBatchDmlResponse[]{response2});
        CommitResponse commitResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.getDefaultInstance()).build();
        Mockito.when((Object)this.rpc.commit((CommitRequest)Mockito.any(CommitRequest.class), Mockito.anyMap())).thenReturn((Object)commitResponse);
        final Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1");
        final AtomicInteger numCalls = new AtomicInteger(0);
        long[] updateCount = (long[])runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<long[]>(){

            public long[] run(TransactionContext transaction) throws Exception {
                numCalls.incrementAndGet();
                return transaction.batchUpdate(Arrays.asList(statement, statement));
            }
        });
        if (status == 10) {
            Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)2);
        }
        return updateCount;
    }

    private void runTransaction(final Exception exception) {
        this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                if (TransactionRunnerImplTest.this.firstRun) {
                    TransactionRunnerImplTest.this.firstRun = false;
                    throw SpannerExceptionFactory.newSpannerException((Throwable)exception);
                }
                return null;
            }
        });
    }
}

